//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Philipp E. Lim 1995
// 
// uCalendar.h -- 
// 
// Author           : Philipp E. Lim
// Created On       : Tue Dec 19 11:58:22 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Mar 19 17:47:12 1999
// Update Count     : 179
// 


#ifndef __U_CALENDAR_H__
#define __U_CALENDAR_H__


#include <time.h>
#include <sys/time.h>					// not all systems include this in time.h


#define CLOCKGRAN 15000000L				// ALWAYS in nanoseconds, MUST BE less than 1 second
#define TIMEGRAN 1000000000L				// nanosecond granularity, except for timeval
#define GETTIMEOFDAY( tp ) gettimeofday( (tp), (struct timezone *)0 )


#if defined( REALTIME_POSIX )
#define tv_XSEC tv_nsec
#else
#define tv_XSEC tv_usec
#endif

#if ! defined( __svr4__ ) && defined( __sun__ )
// fake a few things
#define	CLOCK_REALTIME	0				// real (clock on the wall) time
extern long timezone;					// missing from time.h
extern "C" int gettimeofday(struct timeval *, struct timezone *); // missing from sys/time.h
extern "C" int setitimer(int, struct itimerval *, struct itimerval *); // missing from time.h
#endif

#if defined( __aix__ ) && defined( __ibm__ )
// fake a few things
#define	CLOCK_REALTIME	0				// real (clock on the wall) time
extern "C" int setitimer(int, const struct itimerval *, struct itimerval *); // missing from sys/time.h
#endif

#if defined( __hpux__ ) && defined( __hp__ )
// fake a few things
#define	CLOCK_REALTIME	0				// real (clock on the wall) time
#endif

#if defined( __ultrix__ ) && defined( __dec__ )
// fake a few things
#define	CLOCK_REALTIME	0				// real (clock on the wall) time
extern "C" int gettimeofday(struct timeval *, struct timezone *); // missing from sys/time.h
extern "C" int setitimer(int, struct itimerval *, struct itimerval *); // missing from time.h
#endif

#if defined( __linux__ )
// fake a few things
#define	CLOCK_REALTIME	0				// real (clock on the wall) time
#endif

#if defined( __gizmo__ )
extern "C" time_t mktime(struct tm *timeptr);		// missing from time.h
#endif


class uDuration;					// forward declaration
class uTime;						// forward declaration
class uClock;						// forward declaration
class uOStream;						// forward declaration


//######################### uDuration #########################


uDuration operator-( uDuration op );			// forward declaration
inline uDuration operator-( uDuration op1, uDuration op2 ); // forward declaration
uDuration operator+( uDuration op );			// forward declaration
inline uDuration operator+( uDuration op1, uDuration op2 ); // forward declaration
uDuration operator*( uDuration op1, long int op2 );	// forward declaration
uDuration operator*( long int op1, uDuration op2 );	// forward declaration
uDuration operator/( uDuration op1, long int op2 );	// forward declaration
long long int operator/( uDuration op1, uDuration op2 ); // forward declaration
bool operator>( uDuration op1, uDuration op2 );		// forward declaration
bool operator<( uDuration op1, uDuration op2 );		// forward declaration
bool operator>=( uDuration op1, uDuration op2 );	// forward declaration
bool operator<=( uDuration op1, uDuration op2 );	// forward declaration
inline bool operator==( uDuration op1, uDuration op2 );	// forward declaration
inline bool operator!=( uDuration op1, uDuration op2 );	// forward declaration
uOStream &operator<<( uOStream &os, const uDuration op ); // forward declaration


//######################### uTime #########################


inline uDuration operator-( uTime op1, uTime op2 );	// forward declaration
inline uTime operator-( uTime op1, uDuration op2 );	// forward declaration
inline uTime operator+( uTime op1, uDuration op2 );	// forward declaration
inline uTime operator+( uDuration op1, uTime op2 );	// forward declaration
bool operator>( uTime op1, uTime op2 );			// forward declaration
bool operator<( uTime op1, uTime op2 );			// forward declaration
bool operator>=( uTime op1, uTime op2 );		// forward declaration
bool operator<=( uTime op1, uTime op2 );		// forward declaration
inline bool operator==( uTime op1, uTime op2 );		// forward declaration
inline bool operator!=( uTime op1, uTime op2 );		// forward declaration
uOStream &operator<<( uOStream &os, const uTime op );	// forward declaration


//######################### uDuration (cont) #########################


class uDuration {
    friend class uTime;
    friend class uClock;
    friend uDuration operator-( uDuration op );
    friend uDuration operator-( uDuration op1, uDuration op2 );
    friend uDuration operator+( uDuration op1 );
    friend uDuration operator+( uDuration op1, uDuration op2 );
    friend uDuration operator*( uDuration op1, long int op2 );
    friend uDuration operator/( uDuration op1, long int op2 );
    friend long long int operator/( uDuration op1, uDuration op2 );
    friend long long int operator%( uDuration op1, uDuration op2 );
    friend bool operator>( uDuration op1, uDuration op2 );
    friend bool operator<( uDuration op1, uDuration op2 );
    friend bool operator>=( uDuration op1, uDuration op2 ); 
    friend bool operator<=( uDuration op1, uDuration op2 );
    friend bool operator==( uDuration op1, uDuration op2 );
    friend bool operator!=( uDuration op1, uDuration op2 );
    friend uOStream &operator<<( uOStream &os, const uDuration op );
    friend uDuration operator-( uTime op1, uTime op2 );
    friend uTime operator-( uTime op1, uDuration op2 );
    friend uTime operator+( uTime op1, uDuration op2 );
    friend uDuration abs( uDuration op );

    long long int tv;					// gcc specific
  public:
    uDuration() {
    } // uDuration::uDuration

    uDuration( long int sec ) {				// implicit conversion routine
	tv = (long long int)sec * TIMEGRAN;
    } // uDuration::uDuration

    uDuration( long int sec, long int nsec ) {
	tv = (long long int)sec * TIMEGRAN + nsec;
    } // uDuration::uDuration

    uDuration &operator-=( uDuration op );
    uDuration &operator+=( uDuration op );
    uDuration &operator*=( long int op );
    uDuration &operator/=( long int op );

    operator timeval() const;
    operator timespec() const;
}; // uDuration


inline uDuration operator-( uDuration op1, uDuration op2 ) {
    uDuration ans;
    ans.tv = op1.tv - op2.tv;
    return ans;
} // operator-

inline uDuration &uDuration::operator-=( uDuration op ) {
    *this = *this - op;
    return *this;
} // uDuration::operator-=

inline uDuration operator+( uDuration op1, uDuration op2 ) {
    uDuration ans;
    ans.tv = op1.tv + op2.tv;
    return ans;
} // operator+

inline uDuration &uDuration::operator+=( uDuration op ) {
    *this = *this + op;
    return *this;
} // uDuration::operator+=

inline bool operator==( uDuration op1, uDuration op2 ) {
    return op1.tv == op2.tv;
} // operator==

inline bool operator!=( uDuration op1, uDuration op2 ) {
    return op1.tv != op2.tv;
} // operator!=


//######################### uTime (cont) #########################


class uTime {
    friend class uDuration;
    friend class uClock;
    friend uDuration operator-( uTime op1, uTime op2 );
    friend uTime operator-( uTime op1, uDuration op2 );
    friend uTime operator+( uTime op1, uDuration op2 );
    friend bool operator>( uTime op1, uTime op2 );
    friend bool operator<( uTime op1, uTime op2 );
    friend bool operator>=( uTime op1, uTime op2 ); 
    friend bool operator<=( uTime op1, uTime op2 );
    friend bool operator==( uTime op1, uTime op2 );
    friend bool operator!=( uTime op1, uTime op2 );
    friend uOStream &operator<<( uOStream &os, const uTime op );

    long long int tv;					// gcc specific

    void uCreateTime( int year, int month, int day, int hour, int min, int sec, long int nsec );
  public:
    uTime() {
    } // uTime::uTime

    uTime( long int sec );
    uTime( long int sec, long int nsec );
    uTime( int min, int sec, long int nsec );
    uTime( int hour, int min, int sec, long int nsec );
    uTime( int day, int hour, int min, int sec, long int nsec );
    uTime( int month, int day, int hour, int min, int sec, long int nsec );
    uTime( int year, int month, int day, int hour, int min, int sec, long int nsec );

    uTime &operator-=( uDuration op );
    uTime &operator+=( uDuration op );
    operator timeval() const;
    operator timespec() const;
}; // uTime

inline uDuration operator-( uTime op1, uTime op2 ) {
    uDuration ans;
    ans.tv = op1.tv - op2.tv;
    return ans;
} // operator-

inline uTime operator-( uTime op1, uDuration op2 ) {
    uTime ans;
    ans.tv = op1.tv - op2.tv;
    return ans;
} // operator-

inline uTime &uTime::operator-=( uDuration op ) {
    *this = *this - op;
    return *this;
} // uTime::operator-=

inline uTime operator+( uTime op1, uDuration op2 ) {
    uTime ans;
    ans.tv = op1.tv + op2.tv;
    return ans;
} // operator+

inline uTime &uTime::operator+=( uDuration op ) {
    *this = *this + op;
    return *this;
} //  uTime::operator+=

inline uTime operator+( uDuration op1, uTime op2 ) {
    return op2 + op1;
} // operator+

inline bool operator==( uTime op1, uTime op2 ) {
    return op1.tv == op2.tv;
} // operator==

inline bool operator!=( uTime op1, uTime op2 ) {
    return op1.tv != op2.tv;
} // operator!=


//######################### uClock #########################


class uClock {
    uTime offset;					// for virtual clock: contains offset from real-time
    int clocktype;					// implementation only -1 (virtual), CLOCK_REALTIME
  public:
    uClock() {
	clocktype = CLOCK_REALTIME;
    } // uClock::uClock

//    uClock( int clockId );
    uClock( uTime adj );
    uTime uGetTime();
    void uGetTime( int &year, int &month, int &day, int &hour, int &minutes, int &seconds, long int &nsec );

    void uResetClock() {
	clocktype = CLOCK_REALTIME;
    } // uClock::uResetClock

    void uResetClock( uTime adj );
}; // uClock


#endif __U_CALENDAR_H__


// Local Variables:
// compile-command: "dmake"
// End:
