//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Philipp E. Lim 1996
// 
// uCalendar.cc -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Jan 11 08:23:17 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Mar 19 17:47:15 1999
// Update Count     : 154
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uOStream.h>
//#include <uDebug.h>


#if defined( __gizmo__ )
extern "C" {
time_t mktime(struct tm *tptr) {
    uAbort( "mktime not implemented for gizmo." );
}
} // extern "C"
#endif


//######################### uDuration #########################


uDuration::operator timeval() const {
    timeval dummy = { tv / TIMEGRAN,			// seconds
		      tv % TIMEGRAN / ( TIMEGRAN / 1000000L ) }; // microseconds
    return dummy;
} // uDuration::operator timeval

uDuration::operator timespec() const {
    timespec dummy = { tv / TIMEGRAN,			// seconds
		       tv % TIMEGRAN };			// nanoseconds
    return dummy;
} // uDuration::operator timespec

uDuration operator-( uDuration op ) {
    uDuration ans;
    ans.tv = -op.tv;
    return ans;
} // operator-

uDuration operator+( uDuration op ) {
    uDuration ans;
    ans.tv = +op.tv;
    return ans;
} // operator+

uDuration operator*( uDuration op1, long int op2 ) {
    uDuration ans;
    ans.tv = op1.tv * op2;
    return ans;
} // operator*

uDuration &uDuration::operator*=( long int op ) {
    *this = *this * op;
    return *this;
} // uDuration::operator*=

uDuration operator*( long int op1, uDuration op2 ) {
    return op2 * op1;
} // operator*

uDuration operator/( uDuration op1, long int op2 ) {
    uDuration ans;
    ans.tv = op1.tv / op2;
    return ans;
} // operator/

uDuration &uDuration::operator/=( long int op ) {
    *this = *this / op;
    return *this;
} // uDuration::operator/=

long long int operator/( uDuration op1, uDuration op2 ) {
    return op1.tv / op2.tv;
} // operator/

long long int operator%( uDuration op1, uDuration op2 ) {
    return op1.tv % op2.tv;
} // operator%

uDuration abs( uDuration op1 ) {
    if ( op1.tv < 0 ) op1.tv = -op1.tv;
    return op1;
} // abs

bool operator>( uDuration op1, uDuration op2 ) {
    return op1.tv > op2.tv;
} // operator>

bool operator<( uDuration op1, uDuration op2 ) {
    return op1.tv < op2.tv;
} // operator<

bool operator>=( uDuration op1, uDuration op2 ) { 
    return op1.tv >= op2.tv;
} // operator>=

bool operator<=( uDuration op1, uDuration op2 ) {
    return op1.tv <= op2.tv;
} // operator<=


uOStream &operator<<( uOStream &os, const uDuration op ) {
    uIosWrapper wrapper( os );

    os << op.tv / TIMEGRAN << ".";
    os.width(9);					// nanoseconds
    char oc = os.fill( '0' );
    os << ( op.tv < 0 ? -op.tv : op.tv ) % TIMEGRAN;
    os.fill( oc );
    return os;
} // operator<<


//######################### uTime #########################


#ifdef __U_DEBUG__
static char uTimeMsg[] = ": attempt to create uTime( year=%d, month=%d, day=%d, hour=%d, min=%d, sec=%d, nsec=%d ), "
			 "which exceeds range 00:00:00 UTC, January 1, 1970 to 03:14:07 UTC, January 19, 2038.";
#endif __U_DEBUG__

// The first two constructors must not call uCreateTime because of its call to
// mktime, which subsequently calls malloc. The malloc calls to lead to
// recursion problems because uTime values are created from the sigalrm handler
// in composing the next context switch event.

uTime::uTime( long int sec ) {
    tv = (long long int)sec * TIMEGRAN;
#ifdef __U_DEBUG__
    if ( tv < 0 || tv > 2147483647LL * TIMEGRAN ) {	// between 00:00:00 UTC, January 1, 1970 and 03:14:07 UTC, January 19, 2038.
	uAbort( uTimeMsg, 1970, 0, 0, 0, 0, sec, 0 );
    } // if
#endif __U_DEBUG__
} // uTime::uTime

uTime::uTime( long int sec, long int nsec ) {
    tv = (long long int)sec * TIMEGRAN + nsec;
#ifdef __U_DEBUG__
    if ( tv < 0 || tv > 2147483647LL * TIMEGRAN ) {	// between 00:00:00 UTC, January 1, 1970 and 03:14:07 UTC, January 19, 2038.
	uAbort( uTimeMsg, 1970, 0, 0, 0, 0, sec, nsec );
    } // if
#endif __U_DEBUG__
} // uTime::uTime

void uTime::uCreateTime( int year, int month, int day, int hour, int min, int sec, long int nsec ) {
    tm t;

    tzset();						// initialize time global variables
    t.tm_year = year - 1900;				// mktime uses 1900 as its starting point
    t.tm_mon = month;
    t.tm_mday = day + 1;				// mktime uses range 1-31
    t.tm_hour = hour;
    t.tm_min = min;
    t.tm_sec = sec - ::timezone;			// adjust off the timezone (global variable!) to get GMT
    t.tm_isdst = -1;					// do not adjust for day light savings
    time_t epochsec = mktime( &t );
#ifdef __U_DEBUG__
    if ( epochsec == (time_t)-1 ) {
	uAbort( uTimeMsg, year, month, day, hour, min, sec, nsec );
    } // if
#endif __U_DEBUG__
    tv = (long long int)(epochsec) * TIMEGRAN + nsec;	// convert to nanoseconds
#ifdef __U_DEBUG__
    if ( tv > 2147483647LL * TIMEGRAN ) {		// between 00:00:00 UTC, January 1, 1970 and 03:14:07 UTC, January 19, 2038.
	uAbort( uTimeMsg, year, month, day, hour, min, sec, nsec );
    } // if
#endif __U_DEBUG__
} // uTime::uCreateTime

uTime::uTime( int min, int sec, long int nsec ) {
    uCreateTime( 1970, 0, 0, 0, min, sec, nsec );
} // uTime::uTime

uTime::uTime( int hour, int min, int sec, long int nsec ) {
    uCreateTime( 1970, 0, 0, hour, min, sec, nsec );
} // uTime::uTime

uTime::uTime( int day, int hour, int min, int sec, long int nsec ) {
    uCreateTime( 1970, 0, day, hour, min, sec, nsec );
} // uTime::uTime

uTime::uTime( int month, int day, int hour, int min, int sec, long int nsec ) {
    uCreateTime( 1970, month, day, hour, min, sec, nsec );
} // uTime::uTime

uTime::uTime( int year, int month, int day, int hour, int min, int sec, long int nsec ) {
    uCreateTime( year, month, day, hour, min, sec, nsec );
} // uTime::uTime

uTime::operator timeval() const {
    timeval dummy = { tv / TIMEGRAN,			// seconds
		      tv % TIMEGRAN / ( TIMEGRAN / 1000000L ) }; // microseconds
    return dummy;
} // uTime::operator timeval

uTime::operator timespec() const {
    timespec dummy = { tv / TIMEGRAN,			// seconds
		       tv % TIMEGRAN };			// nanoseconds
    return dummy;
} // uTime::operator timespec

bool operator>( uTime op1, uTime op2 ) {
    return op1.tv > op2.tv;
} // operator>

bool operator<( uTime op1, uTime op2 ) {
    return op1.tv < op2.tv;
} // operator<

bool operator>=( uTime op1, uTime op2 ) { 
    return op1.tv >= op2.tv;
} // operator>=

bool operator<=( uTime op1, uTime op2 ) {
    return op1.tv <= op2.tv;
} // operator<=


uOStream &operator<<( uOStream &os, const uTime op ) {
    uIosWrapper wrapper( os );

    os << op.tv / TIMEGRAN << ".";
    os.width(9);					// nanoseconds
    char oc = os.fill( '0' );
    os << ( op.tv < 0 ? -op.tv : op.tv ) % TIMEGRAN;
    os.fill( oc );
    return os;
} // operator<<


//######################### uClock #########################


uClock::uClock( uTime adj ) {
    uResetClock( adj );
} // uClock::uClock


// uClock::uClock( int ) {
//     // Use exceptions here later on, to see if clock call works
//     //		clock_gettime( CLOCK_REALTIME, &curr );
//     // Right now, only support one real clock.  Later, appropriately set clocktype
//     //		clocktype=clock_id;
//     clocktype = CLOCK_REALTIME;
// } // uClock::uClock


uTime uClock::uGetTime() {
#if defined( REALTIME_POSIX )
    timespec curr;
    if ( clocktype < 0 ) type = CLOCK_REALTIME;
    clock_gettime( type, &curr );
#else
    timeval curr;
    GETTIMEOFDAY( &curr );
#endif
    uTime currtime( curr.tv_sec, curr.tv_usec * 1000 );	// convert to nanoseconds

    if ( clocktype < 0 ) {				// using virtual clock if < 0
	currtime.tv -= offset.tv;			// adjust the time to reflect the "virtual" time.
    } // if

    return currtime;
} // uClock::uGetTime


void uClock::uGetTime( int &year, int &month, int &day, int &hour, int &min, int &sec, long int &nsec ) {
    const timeval temp = uGetTime();
    tm &t = *localtime( (const time_t *)&temp.tv_sec );
    year = t.tm_year; month = t.tm_mon; day = t.tm_mday; hour = t.tm_hour; min = t.tm_min; sec = t.tm_sec;
    nsec = temp.tv_XSEC;
} // uClock::uGetTime


void uClock::uResetClock( uTime adj ) {
#if defined( REALTIME_POSIX )
    timespec curr;
    clock_gettime( CLOCK_REALTIME, &curr );
#else
    timeval curr;
    GETTIMEOFDAY( &curr );
#endif
    uTime currtime( curr.tv_sec, curr.tv_usec * 1000 );	// convert to nanoseconds
    clocktype = -1;
    offset.tv = currtime.tv - adj.tv;
} // uClock::uResetClock


// Local Variables: //
// compile-command: "dmake" //
// End: //
