//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uC++.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Dec 17 22:04:27 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun  1 17:29:45 1999
// Update Count     : 3257
// 


#ifndef __U_CPLUSPLUS_H__
#define __U_CPLUSPLUS_H__

#pragma __U_NOT_USER_CODE__


#include <uAssert.h>
//#include <uDebug.h>


//#include <typeinfo>					// rtti

#include <uStack.h>
#include <uQueue.h>
#include <uSequence.h>

#include "uAlign.h"
#include "uDefault.h"
#include <stddef.h>					// prototype: ptrdiff_t
#include <stdlib.h>					// prototype: malloc, calloc, realloc, free


#define uMonitor uMutex class				// simple definition of a monitor
#define uCoMonitor uMutex uCoroutine			// simple definition of a coroutine monitor

class uKernelBoot;					// forward declaration
uTask uBootTask;					// forward declaration
uTask uSystemTask;					// forward declaration
class uMachContext;					// forward declaration
class uBaseCoroutine;					// forward declaration
class uBaseTask;					// forward declaration
class uSpinLock;					// forward declaration
class uLock;						// forward declaration
class uProcessor;					// forward declaration
class uDefaultScheduler;				// forward declaration
class uCluster;						// forward declaration
class uIOCluster;					// forward declaration
class uNBIO;						// forward declaration
uTask uCollector;					// forward declaration
class uTrace;						// forward declaration
uCoroutine uProcessorKernel;				// forward declaration
uTask uProcessorTask;					// forward declaration
class uHeap;						// forward declaration
class uSerial;						// forward declaration
class uSerialMember;                                    // forward declaration
class uNBIOnode;                                        // forward declaration

extern uBaseCoroutine &uThisCoroutine();		// forward declaration
extern uBaseTask &uThisTask();				// forward declaration
extern uProcessor &uThisProcessor();			// forward declaration
extern uCluster &uThisCluster();			// forward declaration


//######################### Profiling ########################


uTask uProfiler;                                        // forward declaration
class uProfileStack;					// forward declaration
class uHashTable;					// forward declaration
class uHashTableEntry;					// forward declaration
class uProfileTaskSampler;				// forward declaration

extern "C" unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *);
extern "C" void uFunctionEpilogue();
#if defined( __sparc__ )
extern "C" void uMcount();
#else
extern "C" void mcount();
#endif __sparc__


//######################### uAbort/uExit #########################


extern void uAbort( const char *fmt = "", ... );
extern void uExit( int code );


//######################### Signal Handling #########################


// define parameter types for signal handlers

#ifdef __svr4__
#include <sys/types.h>
#include <sys/siginfo.h>
#define __U_SIGCXT__ void *
#define __U_SIGPARMS__ int sig, siginfo_t *sfp, __U_SIGCXT__ cxt
#define __U_SIGTYPE__ int, siginfo_t *, __U_SIGCXT__
#else
#ifdef __linux__
#ifdef __U_SIGCONTEXT_STRUCT_H__
#define sigcontext_struct sigcontext
#endif
#include <asm/sigcontext.h>
#define __U_SIGCXT__ struct sigcontext
#define __U_SIGPARMS__ int sig, __U_SIGCXT__ cxt
#define __U_SIGTYPE__ int, __U_SIGCXT__
#else
#define __U_SIGCXT__ struct sigcontext *
#define __U_SIGPARMS__ int sig, int code, __U_SIGCXT__ cxt, char *addr
#define __U_SIGTYPE__ int, int, __U_SIGCXT__, char *
#endif
#endif


class uSigHandlerModule {
    friend class uKernelBoot;				// access: uSigHandlerModule
    friend uTask uLocalDebugger;			// access: uSSignal

    static void *beginUserCode;
    static void *endUserCode;
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
    static void *beginInlineUserCode;
    static void *endInlineUserCode;
#endif

    static void uSSignal( int sig, void (*handler)(__U_SIGPARMS__), int flags = 0 );
    static void *uSignalContextPC( __U_SIGCXT__ cxt );
    static void *uFunctionAddress( void (*function)() );
    static bool uInUserCode( __U_SIGCXT__ cxt );
    static void uSigChldHandler( __U_SIGPARMS__ );
    static void uSigTermHandler( __U_SIGPARMS__ );
    static void uSigAlrmHandler( __U_SIGPARMS__ );
    static void uSigSegvBusHandler( __U_SIGPARMS__ );

    uSigHandlerModule( uSigHandlerModule & );		// no copy
    uSigHandlerModule &operator=( uSigHandlerModule & ); // no assignment

    uSigHandlerModule();
  public:
}; // uSigHandlerModule


//######################### Memory Management #########################


#if defined( __hpux__ ) && defined( __hp__ )
#define __U_SBRKTYPE__ void *sbrk( int size )
#define __U_BRKTYPE__  int brk( const void *endds )
#elif defined( __osf__ ) && defined( __dec__ )
#define __U_SBRKTYPE__ void *sbrk( ssize_t size )
#define __U_BRKTYPE__  int  brk( char *endds )
#elif defined( __linux__ )
#define __U_SBRKTYPE__ __ptr_t sbrk __P ((ptrdiff_t size))
#define __U_BRKTYPE__  int brk __P ((__ptr_t endds))
#else
#define __U_SBRKTYPE__ void *sbrk( int size )
#define __U_BRKTYPE__  int  brk( void *endds )
#endif

extern "C" __U_SBRKTYPE__;
extern "C" __U_BRKTYPE__;


class uMemoryModule {
    friend class uKernelBoot;				// access: uMemoryModule
    friend class uSigHandlerModule;			// access: uCheckAndMap
    friend uCoroutine uProcessorKernel;			// access: uStackInit
    friend __U_SBRKTYPE__;				// access: uDoSbrk
    friend __U_BRKTYPE__;				// access: uDoSbrk
    friend void *malloc( size_t size );			// access: uMapLock
    friend void *realloc( void *addr, size_t size );	// access: uMapLock
    friend void *calloc( size_t noOfElems, size_t elemSize ); // access: uMapLock

    static int uProgramFile;				// file containing shared program data
    static char *uProgramFileBegin;			// starting address of mapped area
    static char *uProgramFileEnd;			// ending address of mapped area (no storage at this address)
    static uSpinLock *uMapLock;				// spin lock for mutual exclusion of mapping operations

    static void *uDoCheckAndMap();
    static void *uDoSbrk( int size );
    static void *uCheckAndMap();
    static void uStackInit();
    static void uMemoryInit();

    uMemoryModule( uMemoryModule & );			// no copy
    uMemoryModule &operator=( uMemoryModule & );	// no assignment

    uMemoryModule();
  public:
}; // uMemoryModule


//######################### uProcessor #########################


class uProcessorDL : public uSeqable {
    uProcessor &uWho;
  public:
    uProcessorDL( uProcessor &w );
    uProcessor &uGet() const;
}; // uProcessorDL

typedef uSequence<uProcessorDL> uProcessorSeq;


//######################### uCluster #########################


class uClusterDL : public uSeqable {
    uCluster &uWho;
  public:
    uClusterDL( uCluster &w );
    uCluster &uGet() const;
}; // uClusterDL

typedef uSequence<uClusterDL> uClusterSeq;


//######################### uBaseTask #########################


class uBaseTaskDL : public uSeqable {
    uBaseTask &uWho;
  public:
    uBaseTaskDL( uBaseTask &w );
    uBaseTask &uGet() const;
}; // uBaseTaskDL

class uBaseTaskSL : public uColable {
    uBaseTask &uWho;
  public:
    uBaseTaskSL( uBaseTask &w );
    uBaseTask &uGet() const;
}; // uBaseTaskSL

typedef uQueue<uBaseTaskSL> uBaseTaskQueue;
typedef uSequence<uBaseTaskDL> uBaseTaskSeq;


//######################### uKernelModule #########################


#include <uPageSize.h>


class uKernelModule {
    friend class uMemoryModule;				// access: uMyProgramFileEnd, uMappingBuffer
    friend void uAbortExit();				// access: uGlobalProcessors
    friend void uExit( int retcode );			// access: uGlobalAbort, uGlobalAbortLock, uGlobalProcessorLock
    friend void uAbort( const char *fmt, ... );		// access: uProcessorKernelStorage, uDisableInt, uCoreDumped, uGlobalAbort, uGlobalProcessorLock
    friend class uSigHandlerModule;			// access: uCoreDumped
    friend class uMachContext;				// access: uProcessorKernelStack
    friend class uBaseTask;				// access: uActiveProcessorKernel
    friend class uSerial;				// access: uActiveProcessorKernel
    friend class uSerialMember;				// access: uActiveTask
    friend class uSerialDestructor;			// access: uActiveProcessorKernel
    friend class uCondition;				// access: uActiveProcessorKernel
    friend class uContext;				// access: uDisableInt
    friend class uCoroutineMain;			// access: uDisableInt
    friend class uCoroutineConstructor;			// access: uActiveTask
    friend class uTaskConstructor;			// access: uActiveTask
    friend class uSerialConstructor;			// access: uActiveTask        
    friend class uTaskMain;				// access: uDisableInt
    friend uCoroutine uProcessorKernel;			// access: everything
    friend class uProcessor;				// access: uGlobalProcessorLock, uDisableInt, uEnableInt
    friend class uSpinLock;				// access: uGlobalSpinAbort
    friend uBaseTask &uThisTask();			// access: uActiveTask
    friend uProcessor &uThisProcessor();		// access: uActiveProcessor
    friend uCluster &uThisCluster();			// access: uActiveProcessor
    friend uTask uProcessorTask;			// access: uGlobalProcessorLock, uGlobalProcessors, uSystemProcessor, uProcessorKernelStorage
    friend class uCluster;				// access: uGlobalClusterLock, uGlobalClusters, uProcessorKernelStorage, uInKernelRF
    friend class uBaseCoroutine;			// access: uDisableInterrupts, uEnInterrupts
    friend uTask uBootTask;				// access: uSystemCluster
    friend uTask uSystemTask;				// access: uSystemCluster
    friend class uKernelBoot;				// access: uSystemCluster
    friend class uIStreamBoot;				// access: uSystemCluster
    friend class uOStreamBoot;				// access: uSystemCluster
    friend uTask uCollector;				// access: uSystemCluster
    friend class uHeap;					// access: uHeapManager, uTaskBootStorage
    friend void *malloc( size_t size );			// access: uHeapManager
    friend void *realloc( void *addr, size_t size );	// access: uHeapManager
    friend void *calloc( size_t noOfElems, size_t elemSize ); // access: uHeapManager
    friend void free( void *addr );			// access: uHeapManager
    friend uTask uTaskBoot;				// access: uAttaching
    friend class uNBIO;					// access: uActiveProcessorKernel
    friend int uGethostname( const char *const name, int len );	// access: uActiveProcessorKernel
    friend int uGethostbyname( const char *const name, struct hostent *h ); // access: uActiveProcessorKernel
    friend class uClock;				// access : uSettingTimerRF

    // real-time

    friend class uEventList;                            // access: uActiveProcessorKernel
    friend class uEventListPop;				// access: uActiveProcessorKernel, uInKernelRF

    // kernel visualization

    friend class uKernelSampler;			// access: uGlobalClusters
    friend class uClusterSampler;			// access: uGlobalClusters

    // debugger

    friend uTask uLocalDebugger;			// access: uActiveProcessorKernel, uActiveCluster, uActiveTask
    friend uTask uLocalDebuggerMisc;			// access: uActiveProcessorKernel, uGlobalAbort
    friend class uLocalDebuggerHandler;			// access: uActiveCluster, uActiveTask

    // profiling

    friend unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *); // access: uActiveTask
    friend void uFunctionEpilogue();
#if defined( __sparc__ )
    friend void uMcount();
#else
    friend void mcount();
#endif __sparc__  
    friend class uProfileStack;				// access: uActiveTask
    friend uTask uProfiler;				// access: uActiveTask
    friend class uProfilerBoot;				// access: uTaskBoot, uSystemCluster, uSystemProcessor
    friend class uProcessorProfileInfo;			// access: uSystemProcessor, uUserProcessor
    friend class uProfileTaskSampler;			// access: uActiveProcessor
    friend class uNameFilter;				// access: uBeginUserCode, uEndProfileUserCode

    // private, initialized in uPrivate.cc

#   define uActiveProcessorKernel ((uProcessorKernel *)&uKernelModule::uProcessorKernelStorage)
    static uProcessor *uActiveProcessor;		// current active processor
    // The next two private variables shadow the corresponding fields in the
    // processor data structure. They are an optimization so that routines
    // uThisCluster and uThisTask do not have to be atomic routines, and as a
    // consequence can be inlined. The problem is the multiple uActiveProcessor
    // variables (one per UNIX process). A task executing on one processor can
    // be time sliced after loading the address of the active processor into a
    // register, rescheduled on another processor and restarted, but now the
    // previously loaded processor pointer is incorrect. By updating these two
    // shadow variables whenever the corresponding processor field is changed
    // (and this occurs atomically in the kernel), the appropriate data
    // structure (cluster or task) can be accessed with a single load
    // instruction, which is atomic.
    static uCluster  *uActiveCluster;			// current active cluster for processor
    static uBaseTask *uActiveTask;			// current active task for processor

    static bool uDisableInt;				// task in kernel: no time slice interrupts
    static unsigned int uDisableIntCnt;

    static bool uDisableIntSpin;			// task in spin lock; no time slice interrupts
    static unsigned int uDisableIntSpinCnt;

    static unsigned int uInKernelRF;			// in kernel roll forward flag
    static bool uSettingTimerRF;			// task in setitimer; no time slice interrupts

    static char *uMyProgramFileEnd;			// end of this address space
    static double uProcessorKernelStorage[];		// storage for processor kernel instance (size defined at definition)
    static double uProcessorKernelStack[(__U_DEFAULT_STACK_SIZE__ + sizeof(double)) / sizeof(double)]; // processor kernel stack
    static char uMappingBuffer[__U_PAGE_SIZE__];	// alignment buffer for memory mapping; not used

    static void uRollForward( bool inKernel = false );

    inline static void uDisableInterrupts() {
	uDisableInt = true;				// disable interrupts
	uDisableIntCnt += 1;				// increment number of disablings
    } // uKernelModule::uDisableInterrupts

    inline static void uEnableInterrupts() {
	uAssert( uDisableInt && uDisableIntCnt > 0 );

	uDisableIntCnt -= 1;				// decrement number of disablings
	if ( uDisableIntCnt == 0 ) {
	    // Enable interrupts first, otherwise a window exists in which a
	    // signal could occur but a rollforward is not done.
	    uDisableInt = false;			// enable interrupts
	    if ( uInKernelRF ) {			// SIGALRM undelivered ?
		uRollForward();				// deliver SIGALRM
	    } // if
	} // if
    } // KernelModule::uEnableInterrupts

    class uNoInterrupts {
	uNoInterrupts( const uNoInterrupts & );
	uNoInterrupts &operator=( const uNoInterrupts & );
      public:
	uNoInterrupts::uNoInterrupts() {
	    uDisableInterrupts();
	} // uKernelModule::uNoInterrupts::uNoInterrupts

	uNoInterrupts::~uNoInterrupts() {
	    uEnableInterrupts();
	} // uKernelModule::uNoInterrupts::~uNoInterrupts
    }; // uKernelModule::uNoInterrupts
    friend class uNoInterrupts;				// access: uDisableInterrupts, uEnableInterrupts

    inline static void uDisableIntSpinLock() {
	uAssert( ! uDisableIntSpin && uDisableIntSpinCnt == 0 || uDisableIntSpin && uDisableIntSpinCnt > 0 );
	uDisableIntSpin = true;				// disable interrupts
	uDisableIntSpinCnt += 1;			// increment number of disablings
	uAssert( uDisableIntSpinCnt > 0 );
	uAssert( uDisableIntSpin );
    } // uKernelModule::uDisableIntSpinLock

    inline static void uEnableIntSpinLock() {
	uAssert( uDisableIntSpinCnt > 0 );
	uAssert( uDisableIntSpin );

	uDisableIntSpinCnt -= 1;			// decrement number of disablings
	if ( uDisableIntSpinCnt == 0 ) {
	    uDisableIntSpin = false;			// enable interrupts
	} // if
	uAssert( ! uDisableIntSpin && uDisableIntSpinCnt == 0 || uDisableIntSpin && uDisableIntSpinCnt > 0 );
    } // uKernelModule::uEnableIntSpinLock

    // shared, initialized in uC++.cc

    static unsigned int uAttaching;			// flag to signal the local kernel to start attaching.
    static bool uCoreDumped;				// ensure only one core file
#ifndef __U_MULTI__
    static bool uDeadlock;				// deadlock detected in kernel
#endif ! __U_MULTI__
    static bool uTerminate;				// terminate signal received
    static bool uGlobalAbort;				// indicate aborting processor
    static bool uGlobalSpinAbort;			// indicate aborting processor to spin locks
    static uLock *uGlobalAbortLock;			// only one aborting processors
    static uSpinLock *uGlobalProcessorLock;		// mutual exclusion for global processor operations
    static uProcessorSeq *uGlobalProcessors;		// global list of processors
    static uSpinLock *uGlobalClusterLock;		// mutual exclusion for global cluster operations
    static uClusterSeq *uGlobalClusters;		// global list of cluster
    static uHeap *uHeapManager;				// pointer to heap manager object
    static uDefaultScheduler *uSystemScheduler;		// pointer to systen scheduler for system cluster
    static uIOCluster *uSystemCluster;			// pointer to system cluster
    static uProcessor *uSystemProcessor;		// pointer to system processor
    static uBootTask *uTaskBoot;			// pointer to boot task for global constructors/destructors
    static uSystemTask *uTaskSystem;			// pointer to system task for global constructors/destructors
    static uProcessor *uUserProcessor;			// pointer to user processor
    static double uSystemClusterStorage[];
    static double uTaskBootStorage[];

    // profiling

    static unsigned int uDisableExactProfilingCnt;	// disable exact profiling during dynamically allocating memory

#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
    static void uBeginInlineUserCode();
    static void uEndInlineUserCode();
#endif
    static void uBeginUserCode();
    static void uEndUserCode();
    static void uBeginNDebugCode();
    static void uEndNDebugCode();
    static void uEndProfileUserCode();
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
    static void uEndInlineProfileUserCode();
#endif

    uKernelModule( uKernelModule & );			// no copy
    uKernelModule &operator=( uKernelModule & );	// no assignment
  public:
    static uCluster *uUserCluster;			// pointer to user cluster
}; // uKernelModule


//######################### uSpinLock #########################


class uSpinLock {
    // The SGI lock library cannot be used, which supports atomic operations on
    // R-2000 and R-3000 MIPS processors, because it calls malloc. We require
    // spinlocks to be working *before* initialization of our memory manager;
    // otherwise there is a dependency cycle.  Therefore, only R-4000 style
    // MIPS processors are supported because they have atomic operations.

    friend class uKernelBoot;				// access: new
    friend class uMemoryModule;				// access: new

    int uValue;

    uSpinLock( uSpinLock & );				// no copy
    uSpinLock &operator=( uSpinLock & );		// no assignment

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
  public:
    uSpinLock();
    void uAcquire();
    bool uTryAcquire();
    void uRelease();
}; // uSpinLock


// Implement mutual exclusion for a block through a class whose constructor
// acquires a lock and whose destructor releases the lock.  Useful for mutual
// exclusion in free routines. Handles exception termination and multiple block
// exit or return.

class uCSpinLock {
    uSpinLock &SpinLock;

    uCSpinLock( uCSpinLock & );				// no copy
    uCSpinLock &operator=( uCSpinLock &);		// no assignment
  public:
    uCSpinLock( uSpinLock &SpinLock );
    ~uCSpinLock();
}; // uCSpinLock


//######################### uLock #########################


// Implement a lock that works in the uni and multi versions.  In the uni
// version, simply yield if it is not possible to get the lock immediately.

class uLock {
    friend class uKernelBoot;;				// access: new
    friend class uSerial;				// access: SpinLock

    unsigned int uValue;
    uSpinLock SpinLock;

    uLock( uLock & );					// no copy
    uLock &operator=( uLock &);				// no assignment

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
  public:
    uLock();
    uLock( unsigned int value );
    void uAcquire();
    bool uTryAcquire();
    void uRelease();
}; // uLock


//######################### Abnormal Event Handling #########################


#include <uAEHM.h>


//######################### Real-Time #########################


#include <uCalendar.h>
#include <uAlarm.h>


class uSignalHandler {
  protected:
    uBaseTask *uThis;
  public:
    virtual void uHandler() = 0;
}; // uSignalHandler

class uWakeupHndlr : public uSignalHandler {
    friend class uBaseTask;				// access: uWakeupHndlr

    uWakeupHndlr( uBaseTask &t );
    void uHandler();
}; // uWakeupHndlr

class uCxtSwtchHndlr : public uSignalHandler {
    void uHandler();
}; // uCxtSwtchHndlr

class uTimeoutHndlr : public uSignalHandler {
    friend class uSerial;				// access: uWakeupHndlr
    
    uSerial &userial;

    uTimeoutHndlr( uBaseTask &t, uSerial &serial );
    uTimeoutHndlr( uSerial &serial );
    void uHandler();
}; // uTimeoutHndlr

class uSelectTimeoutHndlr : public uSignalHandler {
    friend class uNBIO;
  
    uNBIOnode &uNode;
  
    uSelectTimeoutHndlr( uBaseTask &t, uNBIOnode &n );
    void uHandler();
}; // uTimeoutHndlr

class uBaseScheduleFriend;				// forward declaration


//######################### uContext #########################


class uContext : public uSeqable {
    void *uKey;
  public:
    uContext();
    uContext( void *key );
    virtual ~uContext();

    // These two routines cannot be abstract (i.e., = 0) because there is a
    // race condition during initialization of a derived class when the base
    // class constructor is invoked. A context switch can occur immediately
    // after the base instance has put itself on the task context list but
    // before the virtual function vector is updated for the derived class.
    // Hence, the uSave or uRestore routine of the base class may be called.
    // This situtation is not a problem because either the task has not
    // performed any operations that involve the new context or the task is
    // removing the context and not performing anymore operations using it.

    virtual void uSave() {}
    virtual void uRestore() {}
}; // uContext

typedef uSequence<uContext> uContextSeq;


//######################### uFloatingPointContext #########################


// Provide floating point context switch support for coroutines and tasks.  It
// is built with the more general context class in the same way that a user can
// extend the amount of context that is saved and restored with a coroutine or
// task.

#if defined( __i386__ )
#define uFloatingPointDataSize 31
#elif defined( __m68k__ )
#define uFloatingPointDataSize 24
#elif defined( __mips__ )
#define uFloatingPointDataSize 12
#elif defined( __alpha__ )
#define uFloatingPointDataSize 16
#elif defined( __rs6000__ )
#define uFloatingPointDataSize 36
#endif


// Some architectures store the floating point registers with the integers
// registers during a basic context switch, so there is no need for a data area
// to storage the floating point registers.

#ifdef uFloatingPointDataSize

class uFloatingPointContext : public uContext {
    static int uUniqueKey;
    float uFloatingPointData[uFloatingPointDataSize];
  public:
    uFloatingPointContext() : uContext( &uUniqueKey ) {}
    void uSave();
    void uRestore();
}; // uFloatingPointContext

#else

class uFloatingPointContext {
  public:
    void uSave();
    void uRestore();
};

#endif uFloatingPointDataSize


//######################### uMachContext #########################


extern int errno;


// The default is that stacks grow down. If the stack grows up, it is necessary
// to change the way some things in the context creation and context
// verfication software work.

#ifdef __hppa__
#define __U_STACK_GROWS_UP__
#endif __hppa__


#ifdef __sparc__
#ifdef __svr4__
#include <sys/stack.h>
#else
#include <machine/trap.h>
#include <machine/asm_linkage.h>
#include <machine/psl.h>
#endif __svr4__
#endif __sparc__


// Define a class that contains the machine dependent context and routines that
// initialize and switch between contexts.

class uMachContext {
    friend class uContext;				// access: uAdditionalContexts
    friend class uBaseCoroutine;			// access: uMachContext
    friend class uCoroutineConstructor;			// access: uStartHere
    friend class uTaskConstructor;			// access: uStartHere
    friend uTask uBootTask;				// access: uStorage
    friend uCoroutine uProcessorKernel;			// access: uStorage
    friend class uKernelBoot;				// access: uBase, uSP
    friend class uMemoryModule;				// access: uSP
    friend class uSigHandlerModule;			// access: uRtnAdr
    friend class uProfilerBoot;				// access: uSP, uLimit
    friend uTask uProfiler;				// access: uSP, uLimit
    friend unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *); // access: uSP
    friend void uFunctionEpilogue();			// access: uSP
    friend class uNameFilter;				// access: uRtnAdr

    void *uSP;						// must be offset 0

    // Some machines don't have/use frame pointers (FP).

#ifdef __i386__
    void *uFP;						// must be offset 4
    void *uPC;						// must be offset 8
#endif __i386__

#ifdef __m68k__
#endif __m68k__

#ifdef __sparc__
    void *uFP;						// must be offset 4
    void *uPC;						// must be offset 8
#endif __sparc__

#ifdef __mips__
    void *uProcVal;					// must be offset 4
#endif __mips__

#ifdef __alpha__
    void *uProcVal;					// must be offset 8 (quad words)
#endif __alpha__

#ifdef __rs6000__
#endif __rs6000__

#ifdef __hppa__
#endif __hppa__

    unsigned int uSize;					// size of stack
    void *uStorage;					// pointer to stack
    void *uBase;					// base of stack
    void *uLimit;					// stack grows towards stack limit
    int uError;						// copy of global UNIX variable errno

    void (*uTerminateRtn)();				// per task exception handling termination routine

    union {
	long int uAllExtras;				// allow access to all extra flags
	struct {					// put all extra flags in this structure
	    unsigned int uContexts : 1;			// user defined contexts
	} uIs;
    } uExtras;						// indicates extra work during the context switch

    void uCreateContext( unsigned int stacksize );	// used by all constructors

    static void uInvokeCoroutine( uBaseCoroutine &This );
    static void uInvokeTask( uBaseTask &This );
    static void *uRtnAdr( void (*rtn)() );

    // This routine returns the magic word that is placed at both ends of an
    // allocated stack.  Later, those locations can be checked to see if the
    // magic word is still intact.
    // Should be replaced by unmapping the page of memory after the end of the
    // stack. However, keeping the stacks up to date across UNIX processes is
    // non-trival.

    unsigned long int uMagic();

    void uStartHere( void (*uInvoke)( uMachContext & ) );

    uMachContext( double );

    uMachContext( uMachContext & );			// no copy
    uMachContext &operator=( uMachContext & );		// no assignment
  protected:
    uContextSeq uAdditionalContexts;			// list of additional contexts for this execution state

    void uExtraSave();
    void uExtraRestore();

    void uSave();
    void uRestore();

    virtual void main() = 0;				// starting routine for coroutine or task
  public:
    uMachContext( unsigned int stacksize );
    virtual ~uMachContext();

    void *uStackPointer() const;
    unsigned int uStackSize() const;
    ptrdiff_t uStackFree() const;
    ptrdiff_t uStackUsed() const;
    void uVerify();
}; // uMachContext


extern "C" void uSwitch( uMachContext *to, uMachContext *from ) asm ("uSwitch"); // assembler routine that performs the context switch


//######################### uBaseCoroutine #########################


class uBaseCoroutine : public uMachContext {
    friend class uCoroutineMain;			// access: uState, uCoStarter, uCoFinish
    friend class uTaskMain;				// access: uState
    friend class uKernelBoot;				// access: uContextSw
    friend void uMachContext::uInvokeCoroutine( uBaseCoroutine &This ); // access: uCoStarter, uCoFinish, uStart
    friend void uMachContext::uInvokeTask( uBaseTask &This ); // access: uNotHalted
    friend uTask uBootTask;				// access: uNotHalted
    friend class uCoroutineConstructor;			// access: uName
    friend class uTaskConstructor;			// access: uName
    friend uCoroutine uProcessorKernel;			// access: uContextSw

    // profiler

    friend unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *); // access: uName
    friend void uFunctionEpilogue();			// access: uName
    friend class uProfileTaskSampler;			// access: uProfileActive
    friend class uExecutionMonitor;			// access: uProfileActive

    // abnormal event handling

    friend class uAEHM;					// access: uSyncHandlers, uAsyncHandlers, uDAEStack
    friend class uAEHM::uResumptionHandlers;		// access: uSyncHandlers, uAsyncHandlers
    friend class uAEHM::uDeliverAEStack;		// access: uDAEStack
    friend class uAEHM::uRaiseWorkHorseInit;		// access: uSyncHandlers
  public:
    enum uCoroutineState { uHalt, uActive, uInActive };
  private:
    bool uNotHalted;					// indicate if execuation state is not halted
    const char *uName;					// text name, initialized by uC++ generated code
    uCoroutineState uState;				// current execution status for coroutine
    uBaseCoroutine *uStart;				// first coroutine to resume this one
    uBaseCoroutine *uLast;				// last coroutine to resume this one

    // abnormal event handling

    uAEHM::uResumptionHandlers *uSyncHandlers, *uAsyncHandlers;
    uAEHM::uDeliverAEStack *uDAEStack;

    // The profiler flag is set in this peculiar way, since conditional
    // inlining of code produces multiple, different copies of the routine
    // code.  This technique moves the conditional differences to the call site
    // so the routine code is the same for all inlined modules.

    void uCreateCoroutine();

    uBaseCoroutine( double );
    uCoroutineState uSetState( uCoroutineState state );
    void uContextSw();					// switch between a task and the kernel
    void uContextSw2();					// switch between two coroutine contexts
    void uCoStarter();					// remembers who started a coroutine
    void uCoFinish();

    uBaseCoroutine( uBaseCoroutine & );			// no copy
    uBaseCoroutine &operator=( uBaseCoroutine & );	// no assignment
  protected:
    virtual void uOrderEvents() {};			// user specific ordering of asynchronous events

    // profiling

    bool uProfileActive;				// indicates if this context is supposed to be profiled

    // Duplicate "main" (see uMachContext) to get better error message about
    // missing "main" member for coroutine.
    virtual void main() = 0;				// starting routine for coroutine
  public:
    uBaseCoroutine();
    uBaseCoroutine( unsigned int stacksize );

    // uC++ semantics allow destroying a coroutine before it executes to the
    // end of its main body.  The destructor ensures that a coroutine must
    // terminate when it is destroyed.  By setting the uNotHalted flag, no more
    // asynchronous messages can be sent to this coroutine.  The destructor for
    // the event queue is executed only after the flag is set.

    ~uBaseCoroutine();

    const char *uSetName( const char *name );
    const char *uGetName() const;
    uCoroutineState uGetState() const;

    // abnormal events

    uDualEvent uFailure;				// general failure
    uDualEvent uTerminated;

    // These members should be private but cannot be because they are
    // referenced from user code.

    void uCoResume();
    void uCoSuspend();

    uBaseCoroutine &uLastResume() const;		// last coroutine that resumed the current coroutine

    // abnormal event handling

    uAEHM::uAsyncAEMsgBuffer uAsyncAEBuf;		// list of pending asynchronous events
    int uThrowEventCnt;					// incremented at each uThrow

    bool uUncaughtException();				// necessary because uncaught_exception is not thread safe
}; // uBaseCoroutine


//######################### Abnormal Event Handling #########################


// Include the kernel generated abnormal event definitions.

#include <uKernelEvent.h>


//######################### uBaseCoroutine (cont) #########################


uDualEvent uBaseCoroutine::uFailure : public uKernelFailure {
    const uBaseCoroutine &cor;
    char uName[uAEHMMaxName + sizeof("...")];		// room for "...\0"

    void uCreateFailure();
  public:
    uFailure( const uBaseCoroutine &cor, const char *const msg = "" );
    uFailure( const char *const msg = "" );
    virtual ~uFailure();
    const uBaseCoroutine &uDst() const;
    const char *uGetName() const;
    virtual void uDefaultTerminate() const;
}; // uBaseCoroutine::uFailure


uDualEvent uBaseCoroutine::uTerminated : public uBaseCoroutine::uFailure {
  public:
    uTerminated( const uBaseCoroutine &cor, const char *const msg = "" );
    uTerminated( const char *const msg = "" );
    virtual ~uTerminated();
    virtual void uDefaultTerminate() const;
}; // uBaseCoroutine::uTerminated


//######################### Real-Time (cont) #########################


class uBaseScheduleFriend {
  public:
    enum uTaskCategory { uNonRealtime, uRealtime, uPeriodic, uSporadic };
  protected:
    uTaskCategory uGetCategory( uBaseTask &t ) const;
    uBaseTask &uGetInheritTask( uBaseTask &t ) const;
    int uGetActivePriority( uBaseTask &t ) const;
    int uSetActivePriority( uBaseTask &t1, uBaseTask &t2 );
    int uGetBasePriority( uBaseTask &t ) const;
    int uSetBasePriority( uBaseTask &t, int p );
}; // uBaseScheduleFriend


template<class Node> class uBaseSchedule : protected uBaseScheduleFriend {
  public:
    virtual bool uEmpty() const = 0;
    virtual void uAdd( Node *node ) = 0;
    virtual Node *uDrop() = 0;
    virtual bool uCheckPriority( Node &owner, Node &calling ) = 0;
    virtual void uResetPriority( Node &owner, Node &calling ) = 0;
    virtual void uAddInitialize( uBaseTaskSeq &TaskList ) = 0;
    virtual void uRemoveInitialize( uBaseTaskSeq &TaskList ) = 0;
    virtual void uRescheduleTask( uBaseTaskDL *TaskNode, uBaseTaskSeq &TaskList ) = 0;
}; // uBaseSchedule


class uBasePrioritySeq : public uBaseScheduleFriend {
    uBaseTaskSeq list;
  public:
    virtual bool uEmpty() const;
    virtual uBaseTaskDL *uHead() const;
    virtual void uAdd( uBaseTaskDL *node );
    virtual uBaseTaskDL *uDrop();
    virtual void uRemove( uBaseTaskDL *node ); 
    virtual void uAfterEntry( uBaseTask &uOwner ){ }
}; // uBasePriorityScheduleSeq


class uDefaultScheduler : public uBaseSchedule<uBaseTaskDL> {
    uBaseTaskSeq list;					// list of tasks awaiting execution
  public:
    bool uEmpty() const;
    void uAdd( uBaseTaskDL *node );
    uBaseTaskDL *uDrop();
    bool uCheckPriority( uBaseTaskDL &owner, uBaseTaskDL &calling );
    void uResetPriority( uBaseTaskDL &owner, uBaseTaskDL &calling );
    void uAddInitialize( uBaseTaskSeq &TaskList );
    void uRemoveInitialize( uBaseTaskSeq &TaskList );
    void uRescheduleTask( uBaseTaskDL *TaskNode, uBaseTaskSeq &TaskList );
}; // uDefaultScheduler


//######################### Translator Generated Definitions #########################


enum uAction { uNo, uYes };				// used to indicate the most derived constructor/destructor of an object


class uCoroutineConstructor {				// placed in the constructor of a coroutine
  public:
    uCoroutineConstructor( uAction f, uBaseCoroutine &c, char *n );
}; // uCoroutineConstructor


class uCoroutineMain {					// placed in the main member of a coroutine
  private:
    uBaseCoroutine &c;
  public:
    uCoroutineMain( uBaseCoroutine &c );
    ~uCoroutineMain();
}; // uCoroutineMain


class uSerial {
    friend class uCondition;				// access: uAcceptSignalled
    friend class uSerialConstructor;			// access: uMutexOwner
    friend class uSerialDestructor;			// access: uAcceptSignalled
    friend class uTaskConstructor;			// access: uAcceptSignalled
    friend class uProcessor;				// access: uAcceptSignalled
    friend class uSerialMember;                         // access: uLastRendezvous, uLastAcceptor
    friend uTask uBootTask;				// access: uAcceptSignalled
    friend void uMachContext::uInvokeTask( uBaseTask &This ); // access: uMutexOwner, uLeave2

    class uBitMask {					// assumes 2's complement, 32-bit word
	int bits[4];					// 128 bits
      public:
	bool isSet( int n ) { return 0 != ( bits[n >> 5] & (1u << (n & 0x1f)) ); }
	bool isZero() { return 0 == ( bits[0] | bits[1] | bits[2] | bits[3] ); }
	void zero() { bits[0] = bits[1] = bits[2] = bits[3] = 0; }
	// When a mutex object is inactive, all mutex members are open except
	// the timeout, which is always the first bit in the mask.
	void one() { bits[0] = 0x7fffffff; bits[1] = bits[2] = bits[3] = 0xffffffff; }
	void set( int n ) { bits[n >> 5] |= (1u << (n & 0x1f)); }
	void clr( int n ) { bits[n >> 5] &= ~(1u << (n & 0x1f)); }
	int operator[]( int i ) { return bits[i]; }
    }; // uBitMask

    class uProtectAcceptStmt {
	uSerial &s;
	unsigned int uMutexMaskPosn;
      public:
	uProtectAcceptStmt( uSerial &s );
	uProtectAcceptStmt( uSerial &s, bool );
	~uProtectAcceptStmt();
    }; // uSerial::uProtectAcceptStmt

    bool uAlive;					// serial destroyed ?
    uSpinLock lock;					// provide mutual exclusion while examining serial state
    uBaseTask *uMutexOwner;				// active thread in the mutex object
    uBitMask uMask;					// entry mask of accepted mutex members
    uBasePrioritySeq &uEntryList;			// tasks waiting to enter mutex object
    uStack<uBaseTaskDL> uAcceptSignalled;		// tasks suspended within the mutex object
    bool uTimedoutRF;					// timeout roll forward flag
    uEventNode uTimeoutEvent;				// event node for event list
    uProcessor *uProc;					// active processor when event added
    uEventList *uEvents;				// event list when event added

    // abnormal events

    uBaseTask *uLastAcceptor;				// acceptor of current entry for communication between acceptor and caller

    uSerial( uSerial & );				// no copy
    uSerial &operator=( uSerial & );			// no assignment
  public:
    // These members should be private but cannot be because they are
    // referenced from user code.

    unsigned int uMutexMaskPosn;			// bit position (0-127) in the entry mask for active mutex member

    uSerial( uBasePrioritySeq &uEntryList );
    ~uSerial();

    void uEnter( int &ms, uBasePrioritySeq &entry, int maskPosn );
    void uEnterNoPoll( int &ms, uBasePrioritySeq &entry, int maskPosn );
    void uEnterTimeout();
    void uDoTimeout();
    void uLeave( int ms );
    void uLeave2();
    void uAcceptStart( unsigned int &uMutexMaskPosn );
    bool uAcceptTry( uBasePrioritySeq &entry, int maskPosn );
    void uAcceptTry();
    bool uAcceptTestMask();
    void uAcceptElse();
    void uAcceptPause();
    void uAcceptPause( uDuration duration );
    void uAcceptPause( uTime time );
    void uAcceptEnd( unsigned int uMutexMaskPosn );
    void uRemoveTimeout();

    // abnormal events

    uDualEvent uFailure;				// raised when entry encounter an abnormal condition
    uDualEvent uEntryFailure;				// derived from uFailure
    uDualEvent uRendezvousFailure;			// derived from uFailure as accepted statement may be hidden inside any mutex entry
}; // uSerial


uDualEvent uSerial::uFailure : public uKernelFailure {	// general event for failure in a mutex member routine
    // The field serial is to identify the mutex object involved, which can be
    // a uMutexCoroutine or uTask.

    const uSerial *const serial;			// no bound exception in uC++
  public:
    uFailure( const uSerial *const serial, const char *const msg = "" );
    uFailure( const char *const msg = "" );
    virtual ~uFailure();
    const uSerial *const uSerialID();
    virtual void uDefaultTerminate() const;
}; // uSerial::uFailure


uDualEvent uSerial::uEntryFailure : public uSerial::uFailure {
    // this is raised at an execution when it is in either the entry queue or
    // the suspended stack of a mutex object
  public:
    uEntryFailure( const uSerial *const serial, const char *const msg = "" );
    uEntryFailure( const char *const msg = "" );
    virtual ~uEntryFailure();
    virtual void uDefaultTerminate() const;
}; // uSerial::uEntryFailure


uDualEvent uSerial::uRendezvousFailure : public uSerial::uFailure {
    // event when failing during a rendezvous

    // This event should be raised at the acceptor asynchronously.  Rendezvous
    // failure is a entry failure because an accepted statement can be hidden
    // inside a mutex object entry.

    const uBaseCoroutine *const caller;
  public:
    uRendezvousFailure( const uSerial *const serial_id, const char *const msg = "" );
    virtual ~uRendezvousFailure();
    const uBaseCoroutine *const uCaller();
    virtual void uDefaultTerminate() const;
}; // uSerial::uRendezvousFailure


class uTaskConstructor {				// placed in the constructor of a task
  public:
    uTaskConstructor( uAction f, uSerial &s, uBaseTask &t, const char *n, bool a );
}; // uTaskConstructor


class uTaskDestructor {					// placed in the destructor of a task
    uAction flag;
    uBaseTask &t;
  public:
    uTaskDestructor( uAction f, uBaseTask &t );
    ~uTaskDestructor();
}; // uTaskDestructor


class uTaskMain {					// placed in the main member of a task
    uSerial &s;
  public:
    uTaskMain( uSerial &s );
    ~uTaskMain();
}; // uTaskMain


class uSerialConstructor {				// placed in the constructor of a mutex class
    uAction flag;
    uSerial &s;
  public:
    uSerialConstructor( uAction f, uSerial &s );
    ~uSerialConstructor();
}; // uSerialConstructor


class uSerialDestructor {				// placed in the destructor of a mutex class
    int mutexRecursion;
    uAction flag;
    uSerial &s;
  public:
    uSerialDestructor( uAction f, uSerial &s, uBasePrioritySeq &e, int m );
    ~uSerialDestructor();
}; // uSerialDestructor


class uSerialMember {					// placed in the mutex member of a mutex class
    int mutexRecursion;					// counter for number of recursive calls
    uSerial &s;

    // real-time

    uBaseTask &uInheritTask;				// priority of task prior to entering mutex object

    // abnormal events

    friend class uSerial;				// access: caller, acceptor
    friend class uCondition;				// access: caller

    uBaseTask *acceptor;				// acceptor of the entry invocation, NULL => no acceptor
    bool uAcceptorSuspended;                            // true only when the acceptor, if there is one, remains blocked
    bool noUserOverride;                                // true when uAcceptor has not been called
  public:
    uSerialMember( uSerial &s, uBasePrioritySeq &e, int m );
    ~uSerialMember();

    // Return the acceptor only when the acceptor remains suspended and the
    // mutex object has yet to be destroyed, otherwise return NULL reference.
    // Side-effect: prevent the kernel from resuming (uRaise) an asynchronous
    // event at the suspended acceptor if the rendezvous terminates with an
    // exception.

    uBaseCoroutine *uAcceptor();
}; // uSerialMember


//######################### uBaseTask (cont) #########################


class uBaseTask : public uBaseCoroutine {
    friend class uSerial;				// access: uEntryRef, uMutexRef, uSetState
    friend class uTaskConstructor;			// access: uStartHere, uName, uProfileActive, uSerialInstance, uCurrCluster
    friend class uTaskDestructor;			// access: uCurrCluster
    friend class uTaskMain;				// access: uRecursion
    friend class uSerialConstructor;			// access: uMutexRecursion
    friend class uSerialDestructor;			// access: uMutexRef, uSetState, uWake
    friend class uCondition;				// access: uMutexRef, uSetState, uInfo
    friend class uBaseCoroutine;			// access: uCurrCoroutine
    friend uBaseCoroutine &uThisCoroutine();		// access: uCurrCoroutine
    friend class uCluster;				// access: uClusterRef, uReadyRef, uWakeupTasks
    friend uTask uProcessorTask;			// access: uBound
    friend uCoroutine uProcessorKernel;			// access: uCurrCoroutine
    friend uTask uBootTask;				// access: uWake
    friend void uMachContext::uInvokeTask( uBaseTask &This ); // access: uSerialInstance
    friend void *malloc( size_t size );			// access: uCurrCoroutine, uInheritTask
    friend void *realloc( void *addr, size_t size );	// access: uCurrCoroutine
    friend void *calloc( size_t noOfElems, size_t elemSize ); // access: uCurrCoroutine

    // event tracing

    friend class uTraceConstructor;			// access: trace
    friend class uTraceDestructor;			// access: trace
    friend class uTraceAcceptStart;			// access: trace
    friend class uTraceAcceptDone;			// access: trace
    friend class uTraceResume;				// access: trace
    friend class uTraceSuspend;				// access: trace
    friend class uTraceEntry;				// access: trace
    friend class uTraceMain;				// access: trace
    friend class uTracePetition;			// access: trace
    friend class uTraceInit;				// access: trace

    // debugger

    friend class uLocalDebuggerHandler;			// access: uTaskDebugMask
    friend uTask uLocalDebugger;			// access: DebugPCandSRR
    friend uTask uLocalDebuggerReader;			// access: DebugPCandSRR, uWake
    friend class uSigHandlerModule;			// access: DebugPCandSRR

    // profiling

    friend class uCoroutineConstructor;			// access: uProfileTaskSamplerInstance
    friend void uAbort( const char *fmt, ... );         // access: uProfileTaskSamplerInstance
    friend unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *); // access: uState, uMutexRef
    friend void uFunctionEpilogue();                    // access: uMutexRef
    friend class uProfileTaskSampler;			// access: uFuncID, uState, uName
    friend uTask uProfiler;                             // access: uProfileTaskSamplerInstance
#if defined( __sparc__ )
    friend void uMcount();				// access: inside_uFunctionPrologue, uProfileTaskSamplerInstance
#else
    friend void mcount();
#endif
    friend class uTaskSampler;				// access: uProfileTaskSamplerInstance
    friend class uExecutionMonitor;			// access: uProfileTaskSamplerInstance
  public:
    enum uTaskState { uReady, uRunning, uBlocked };
  private:
    void uCreateTask( uCluster &uClus );
    uBaseTask( uCluster &uClus, uProcessor &uProc );	// only used by uProcessorTask
    uTaskState uSetState( uTaskState state );
    void uWake();

    uBaseTask( uBaseTask & );				// no copy
    uBaseTask &operator=( uBaseTask & );		// no assignment

    // debugger

    char uTaskDebugMask[8];				// 64 bit breakpoint mask for task (used only by debugger)
    void *DebugPCandSRR;				// PC of break point; address of return message for IPC SRR
    bool uProcessBP;					// true if task is in the middle of processing a breakpoint

    int uRecursion;					// allow recursive entry of main member
    uTaskState uState;					// current state of task
    int uMutexRecursion;				// number of recursive calls while holding mutex
    uCluster *uCurrCluster;				// cluster task is executing on
    uBaseCoroutine *uCurrCoroutine;			// coroutine being executed by tasks thread
    long int uInfo;					// condition information stored with blocked task

    uBaseTaskDL uClusterRef;				// double link field: list of tasks on cluster
    uBaseTaskDL uReadyRef;				// double link field: ready queue
    uBaseTaskDL uEntryRef;				// double link field: general entry deque (all waiting tasks)
    uBaseTaskDL uMutexRef;				// double link field: mutex member, suspend stack, condition variable
    uProcessor &uBound;					// processor to which this task is bound, if applicable
    uBasePrioritySeq *uCalledEntryMem;			// pointer to called mutex queue

    // event tracing

    uTrace *uTraceInstance;

    // profiling

    uProfileTaskSampler *uProfileTaskSamplerInstance;	// pointer to related profiling object

    // abnormal event

    uSerialMember *uAcceptedCall;                       // pointer to the last mutex entry accepted by this thread
  protected:
    uBaseScheduleFriend::uTaskCategory uCategory;	// TEMPORARY, until RTTI works

    // real-time

    friend class uSerialMember;				// access: uSetActivePriority, uAcceptedCall
    friend class uBaseScheduleFriend;			// access: uGetCategory, uGetInheritTask, uGetActivePriority, uSetActivePriority, uGetBasePriority, uSetBasePriority
    friend class uWakeupHndlr;                          // access: uWake

    // Duplicate "main" (see uMachContext) to get better error message about
    // missing "main" member for task.
    virtual void main() = 0;				// starting routine for task

    int uPriority;
    int uActivePriority;
    uBaseTask *uInheritTask;

    uBaseScheduleFriend::uTaskCategory uGetCategory() const;
    uBaseTask &uGetInheritTask();
    int uSetActivePriority( uBaseTask &t );
    int uSetBasePriority( int p );
  public:
    uBaseTask();
    uBaseTask( unsigned int stacksize );
    uBaseTask( uCluster &uClus );
    uBaseTask( uCluster &uClus, unsigned int stacksize );
    ~uBaseTask();

    void uYield();
    void uYield( unsigned int times );

    uCluster &uMigrate( uCluster &uClus );
    uCluster &uGetCluster() const;

    uTaskState uGetState() const;

    int uGetActivePriority() const;
    int uGetBasePriority() const;

    // profiling

    void uProfileActivate();
    void uProfileInactivate();
    void uPrintCallStack( char * const buf, unsigned int const bufsize, const char * const format, ... ) const;
    void uPrintCallStack( const char * const format, ... ) const;

    // These members should be private but cannot be because they are
    // referenced from user code.

    void uYieldNoPoll();
    void uYieldYield( unsigned int times );		// inserted by translator for -yield

    void uSleep( uDuration duration );
    void uSleep( uTime time );
}; // uBaseTask


//######################### uCondition #########################


class uCondition {
    uQueue<uBaseTaskDL> uCondQueue;			// queue of blocked tasks
    uSerial *owner;					// mutex object owning condition, only set in uWait

    uCondition( uCondition & );				// no copy
    uCondition &operator=( uCondition & );		// no assignment
  public:
    uCondition();
    ~uCondition();

    bool uEmpty() const;				// test for tasks on a condition
    long int uFront() const;				// return task information

    // abnormal events

    uDualEvent uWaitingFailure;				// condition queue deleted before restarted from waiting
    friend uDualEvent uCondition::uWaitingFailure;	// access: owner

    // These members should be private but cannot be because they are
    // referenced from user code.

    void uW( uSerial &s );				// wait on a condition
    void uW( uSerial &s, long int info );		// wait on a condition with information
    void uS( uSerial &s );				// signal a condition
    void uSBlock( uSerial &s );				// signal a condition
}; // uCondition


uDualEvent uCondition::uWaitingFailure : public uSerial::uFailure {
    const uCondition *const cond;
  public:
    uWaitingFailure( const uCondition *const cond, const char *const msg = "" );
    virtual ~uWaitingFailure();
    const uCondition *const uConditionID() const;
    virtual void uDefaultTerminate() const;
}; // uCondition::uWaitingFailure 


//######################### Trace #########################


// Include the trace code so that any objects after this point can be traced.

#ifdef __U_TRACE__
#include <uCollect.h>
#endif __U_TRACE__


//######################### uBaseCoroutine (cont) #########################


inline const char *uBaseCoroutine::uSetName( const char *name ) {
    // MUST BE INLINED BECAUSE NO TRACE VERSON OF KERNEL CREATED
    const char *prev = uName;
    uName = name;
#ifdef __U_TRACE__
    if ( uCollector::uCollectorServer == (uCollector *)0 ) uCollector::uCollectorServer->uEventNoPartnerNamed( *uThisTask().uTraceInstance, __DBG_OBJECT_NAME__, uName, 0 );
#endif __U_TRACE__
    return prev;
} // uBaseCoroutine::uSetName


//######################### uProcessorKernel #########################


uCoroutine uProcessorKernel {
    friend class uKernelBoot;				// access: ~uProcessorKernel
    friend class uSerial;				// access: uSchedule
    friend class uSerialDestructor;			// access: uSchedule
    friend class uCondition;				// access: uSchedule
    friend class uBaseTask;				// access: uSchedule
    friend uTask uProcessorTask;			// access: uTerminated, uForkChild, uNewProc
    friend void uAbort( const char *fmt, ... );		// access: uSchedule

    // debugger

    friend uTask uLocalDebuggerMisc;			// access: uSchedule

    bool uTerminated;					// terminate processor kernel ?
    bool uForkChild;					// fork a new processor ?
    int uCode;						// schedule state
    uSpinLock *uPrevLock;				// comunication
    uBaseTask *uNextTask;				// task to be wakened
    uProcessor *uNewProc;				// new processor for fork

    // real-time

    friend class uEventList;                            // access: uContextSwitchHandler, uSetTimer
    friend class uEventListPop;				// access: uContextSwitchHandler, uSetTimer
    friend class uSigHandlerModule;			// access: uSetTimer
    friend class uCluster;                              // access: uSetContextSwitchEvent
    friend class uNBIO;					// access: uSetContextSwitchEvent
    friend class uCxtSwtchHndlr;                        // access uSchedule

    void uOnBehalfOfUser();
    void nextProcessor( int &uPrevPreemption, uSeqGen<uProcessorDL> &uGenProc, uProcessorDL *&uCurrProc );
    void main();
    void uFork();
    void uSchedule();
    void uSchedule( uSpinLock *l );
    void uSchedule( uBaseTask *t );
    void uSchedule( uSpinLock *l, uBaseTask *t );
    void uSchedule( uLock *l, uSpinLock *sl );

    void uSetTimer( uDuration time );
    void uSetTimer( uTime time );

    uProcessorKernel();
    ~uProcessorKernel();

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
  public:
    uClock uKernelClock;
}; // uProcessorKernel


//######################### uProcessor (cont) #########################


class uProcessor {
    friend class uKernelBoot;				// access: uEvents
    friend class uCluster;				// access: uIdleRef, uExternal, uProcessorRef
    friend class uIOCluster;				// access: uProcessorRef
    friend class uTaskMain;				// access: uProcTask
    friend uTask uBootTask;				// access: uCurrTask
    friend uCoroutine uProcessorKernel;			// access: uCurrCluster, uExternal, uCurrTask, uProcTask
    friend uTask uProcessorTask;			// access: uGlobalRef, uPid, uCurrCluster
    friend class uSerial;				// access: uEvents
    friend void uKernelModule::uRollForward( bool inKernel ); // access: uEvents
    friend class uNBIO;					// access: uEvents
    friend class uBaseTask;				// access: uEvents
    friend class uEventList;				// access: uEvents
    friend class uEventListPop;                         // access: uContextSwitchHandler
    friend int uGethostname( const char *const name, int len );	// access: uSetContextSwitchEvent
    friend int uGethostbyname( const char *const name, struct hostent *h ); // access: uSetContextSwitchEvent

    // debugger

    friend uTask uLocalDebugger;			// access: uDebugIgnore
    friend uTask uLocalDebuggerReader;			// access: uDebugIgnore

    bool uDebugIgnore;					// ignore processor migration

    // profiling
    
    friend unsigned int uFunctionPrologue( register char*, register unsigned short *, register unsigned short  * ); // access: uProcTask
#if defined( __sparc__ )
    friend void uMcount();				// access: uProcTask
#else
    friend void mcount();                               // access: uProcTask
#endif __sparc__  
    friend class uProfileTaskSampler;
    friend uTask uProfiler;
    friend class uProfilerBoot;				// access: uProcTask

#ifndef __U_MULTI__
    static						// shared info on uniprocessor
#endif ! __U_MULTI__
    uEventList *uEvents;				// list of events for this processor
#ifndef __U_MULTI__
    static						// shared info on uniprocessor
#endif ! __U_MULTI__
    uEventNode *uContextEvent;				// context-switch node for event list
#ifndef __U_MULTI__
    static						// shared info on uniprocessor
#endif ! __U_MULTI__
    uCxtSwtchHndlr *uContextSwitchHandler;		// special time slice handler

    uProcessor( uProcessor & );				// no copy
    uProcessor &operator=( uProcessor &);		// no assignment
  protected:
    uClock *uProcessorClock;                            // clock bound to processor

    int uPid;						// UNIX pid

    int uPreemption;
    int uSpin;

    uProcessorTask *uProcTask;				// handle processor specific requests
    uBaseTaskSeq uExternal;				// ready queue for processor task

    uBaseTask *uCurrTask;				// task executing on processor
    uCluster *uCurrCluster;				// cluster processor currently associated with

    uProcessorDL uIdleRef;				// double link field: list of idle processors
    uProcessorDL uProcessorRef;				// double link field: list of processors on a cluster
    uProcessorDL uGlobalRef;				// double link field: list of all processors

    void uCreateProcessor( uCluster &uClus, int ms, int spin );
    void uFork( uProcessor *np );
    void uSetContextSwitchEvent( int msecs );		// set the real-time timer
    void uSetContextSwitchEvent( uDuration dur );	// set the real-time timer

    uProcessor( uCluster &uClus, double );		// used solely during kernel boot
  public:
    uProcessor( int ms = uDefaultPreemption(), int spin = uDefaultSpin() );
    uProcessor( uCluster &uClus, int ms = uDefaultPreemption(), int spin = uDefaultSpin() );
    ~uProcessor();

    uClock &uGetClock() const;
    int uGetPid() const;
    uCluster &uGetCluster() const;
    uCluster &uSetCluster( uCluster &uClus );
    uBaseTask &uGetTask() const;
    int uSetPreemption( int ms );
    int uGetPreemption() const;
    int uSetSpin( int spin );
    int uGetSpin() const;
    bool uIdle() const;
    void *uMmap( void *begin, int size, int prot, int flags, int fd, int off );
}; // uProcessor


//######################### uCluster (cont) #########################


#ifdef __svr4__
#include <sys/select.h>					// type: fd_set
#else
#if defined( __aix__ ) && defined( __ibm__ )
#include <sys/select.h>					// type: fd_set
#endif
#include <sys/types.h>					// type: fd_set
#endif


class uCluster {
    friend class uBaseTask;				// access: uMakeTaskReady, uTaskAdd, uTaskRemove
    friend class uNBIO;					// access: uMakeProcessorIdle, uMakeProcessorActive
    friend class uKernelBoot;				// access: new, NBIO
    friend uCoroutine uProcessorKernel;			// access: NBIO, uReadyTaskTryRemove, uReadyTasksEmpty
    friend uTask uProcessorTask;			// access: uProcessorRemove, uProcessorAdd
    friend class uTaskConstructor;			// access: uTaskAdd
    friend class uTaskDestructor;			// access: uTaskRemove
    friend class uProcessor;				// access: uProcessorAdd, uProcessorRemove
    friend uMonitor uClusterSampler;			// access: uProcessorsOnCluster
    friend class uSerial;				// access: uTaskResetPriority
    friend class uRealTimeBaseTask;
    friend class uPeriodicBaseTask;
    friend class uSporadicBaseTask;

    // debugger

    friend uTask uLocalDebugger;			// access: uDebugIgnore
    friend uTask uLocalDebuggerReader;			// access: uDebugIgnore

    bool uDebugIgnore;					// ignore cluster migration

    // profiling

    friend class uTaskProfileInfo; 	                // access: uName
    friend class uProfileTaskSampler;			// access uProcessorsOnCluster
    friend unsigned int uFunctionPrologue (register char*, register unsigned short *, register unsigned short  *); // access &uCluster::uTaskRemove

    // real-time

    friend class uEventList;                            // access: uWakeProcessor

    uClusterDL uGlobalRef;				// double link field: list of all clusters

    uCluster( uCluster & );				// no copy
    uCluster &operator=( uCluster & );			// no assignment

    void *operator new( size_t, void *storage ) { return storage; }
  protected:
    const char *uName;					// textual name for cluster

    // The cluster cannot be a monitor because the processor kernel is only a
    // coroutine. If the kernel called a mutex routine in the cluster and could
    // not get in, the previous task executed by the kernel is put on the mutex
    // entry queue and the kernel is restarted. When the kernel restarts, it
    // now enters the critical section when it should be scheduling a new
    // task. Therefore explicit locks must be used for these queues.

    uSpinLock uReadyIdleLock;				// protect uReadyTasks, uIdleProcessors and uTasksOnCluster
    uBaseSchedule<uBaseTaskDL> *uReadyTasks;		// list of tasks awaiting execution by processors on this cluster
    bool uDefaultReadyTasks;				// indicates if the cluster allocated the ready task
    uProcessorSeq uIdleProcessors;			// list of idle processors associated with this cluster
    uBaseTaskSeq uTasksOnCluster;			// list of tasks on this cluster
    uSpinLock uProcessorsOnClusterLock;
    uProcessorSeq uProcessorsOnCluster;			// list of processors associated with this cluster

    unsigned int uStackSize;				// default stack size

    void uCreateCluster( unsigned int stacksize, const char *name );
    void uWakeProcessor( int uPid );
    void uProcessorPause();
    void uMakeProcessorIdle( uProcessor &p );
    void uMakeProcessorActive( uProcessor &p );
    bool uReadyTasksEmpty();
    void uMakeTaskReady( uBaseTask &uReadyTask );
    uBaseTask &uReadyTaskTryRemove();
    void uTaskAdd( uBaseTask &t );
    void uTaskRemove( uBaseTask &t );
    virtual void uProcessorAdd( uProcessor &p );
    void uProcessorRemove( uProcessor &p );
    void uTaskReschedule( uBaseTask &t );
  public:
    void *operator new( size_t size ) { return ::operator new( size ); }

    uCluster( unsigned int stacksize = uDefaultStackSize(), const char *name = "" );
    uCluster( const char *name );
    uCluster( uBaseSchedule<uBaseTaskDL> &ReadyQueue, unsigned int stacksize = uDefaultStackSize(), const char *name = "" );
    uCluster( uBaseSchedule<uBaseTaskDL> &ReadyQueue, const char *name = "" );
    virtual ~uCluster();

    const char *uSetName( const char *name );
    const char *uGetName() const;
    unsigned int uSetStackSize( unsigned int stacksize );
    unsigned int uGetStackSize() const;

    void uTaskResetPriority( uBaseTask &owner, uBaseTask &calling );
}; // uCluster


class uIOCluster : public uCluster {
    friend class uKernelModule;				// access: processor
    friend class uKernelBoot;				// access: uIOCluster
    friend uTask uProcessorTask;			// access: NBIO
    friend uCoroutine uProcessorKernel;			// access: NBIO

    // Make a pointer to allow static declaration for uniprocessor.
#ifndef __U_MULTI__
    static						// shared info on uniprocessor
#endif ! __U_MULTI__
    uNBIO *NBIO;					// non-blocking I/O facilities
    uProcessor processor;

    virtual void uProcessorAdd( uProcessor &p );

    void uCreateIOCluster();
    uIOCluster( uBaseSchedule<uBaseTaskDL> &ReadyQueue );
  public:
    uIOCluster( unsigned int stacksize = uDefaultStackSize(), const char *name = "uIOCluster" );
    uIOCluster( const char *name );
    ~uIOCluster();

    static const int uReadSelect;
    static const int uWriteSelect;
    static const int uExceptSelect;

    int uSelect( int fd, int rwe, timeval *timeout = NULL );
    int uSelect( fd_set *rfd, fd_set *wfd, fd_set *efd, timeval *timeout = NULL );
    int uSelect( int nfds, fd_set *rfd, fd_set *wfd, fd_set *efd, timeval *timeout = NULL );
}; // uIOCluster


//######################### uNBIO #########################


class uNBIOnode : public uSeqable {
    friend class uNBIO;
    friend class uSelectTimeoutHndlr;

    int nfds;						// return value
    uBaseTask *uPendingTask;
    enum { singleFd, multipleFds } fdType;
    bool uTimedout;
    union {
	struct {					// used if waiting for only one fd
	    int fd;
	    int *uRWE;
	} sfd;
	struct {					// used if waiting for multiple fds
	    fd_mask uNFDs;
	    fd_set *uRFDs;
	    fd_set *uWFDs;
	    fd_set *uEFDs;
	} mfd;
    } smfd;
    uCondition uPending;
  public:
}; // uNBIOnode


class uNBIO {						// monitor (private mutex member)
    friend uCoroutine uProcessorKernel;			// access: uOkToSelect, uIOPoller

    fd_set uRFDs;					// master copy of all waiting I/O for all tasks
    fd_set uWFDs;
    fd_set uEFDs;

    bool uOkToSelect;					// uniprocessor flag indicating blocking select
    int uFound;						// declared here so uniprocessor kernel can check if I/O occurred
    uBaseTask *uIOPoller;				// pointer to current IO poller task, or 0
    uSequence<uNBIOnode> uPendingIO;			// list of waiting tasks

    void uCheckIO( uDuration delay );
    bool uCheckPoller( uNBIOnode &uNode );
    uMutex bool uPollIO( uNBIOnode &uNode );
    uMutex bool uInitSfd( uNBIOnode &uNode );
    uMutex bool uInitSfd( uNBIOnode &uNode, uEventNode &uTimeoutEvent, uProcessor &proc );
    uMutex bool uInitMfds( fd_mask nfds, uNBIOnode &uNode );
    uMutex bool uInitMfds( fd_mask nfds, uNBIOnode &uNode, uEventNode &uTimeoutEvent, uProcessor &proc );
  public:
    uNBIO();
    ~uNBIO();
    int uSelect( int fd, int &rwe, timeval *timeout = NULL );
    int uSelect( fd_mask nfds, fd_set *rfds, fd_set *wfds, fd_set *efds, timeval *timeout = NULL );
}; // uNBIO


//######################### uMain #########################


uTask uMain {
    // The arguments that are passed to main are passed to the first user task
    // and stored as member variables.

    int argc;
    char **argv;

    // A reference to a variable that holds the return code that the uMain task
    // returns to the OS.

    int &uRetCode;

    // Main routine for the first user task, declared here, defined by user.

    void main();
  public:
    // Must appear inline so that trace code is generated.
    uMain( uCluster &cluster, int size, int argc, char *argv[], int &retcode ) :
		uBaseTask( cluster, size ), argc( argc ), argv( argv ), uRetCode( retcode ) {
    } // uMain::uMain

    // Must appear inline so that trace code is generated.
    ~uMain() {
    } // uMain::~uMain
}; // uMain


//######################### Kernel Boot #########################


class uKernelBoot {
    static int uCount;

    void startup();
    void finishup();
  public:
    uKernelBoot() {
	uCount += 1;
	if ( uCount == 1 ) {
	    startup();
	} // if
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uKernelBoot &)0x%p.uKernelBoot\n", this );
#endif __U_DEBUG_H__
    } // uKernelBoot::uKernelBoot

    ~uKernelBoot() {
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uKernelBoot &)0x%p.~uKernelBoot\n", this );
#endif __U_DEBUG_H__
	if ( uCount == 1 ) {
	    finishup();
	} // if
	uCount -= 1;
    } // uKernelBoot::uKernelBoot
}; // uKernelBoot


// debugger

#ifdef __U_DEBUG__
#include <uLocalDebugger.h>
#endif __U_DEBUG__


// Create an instance in each translation unit, but only the first instance to
// execute performs the system bootstrap. Do not include instances in the
// kernel modules.

#ifndef __U_KERNEL__
static uKernelBoot uBootKernel;

#if __U_LOCALDEBUGGER_H__
static uLocalDebuggerBoot uBootLocalDebugger;
#endif __U_LOCALDEBUGGER_H__

#if defined( __U_PROFILE__ )
#ifndef __U_PROFILEABLE_ONLY__
#include <uProfilerBoot.h>
#ifndef __U_EXECUTABLE_FILENAME__
static uProfilerBoot uBootProfiler( "a.out" ); 
#else
#define __U_STRINGIFYARG(s) #s
#define __U_STRINGIFY(s) __U_STRINGIFYARG(s)
static uProfilerBoot uBootProfiler( __U_STRINGIFY( __U_EXECUTABLE_FILENAME__ ) );
#undef  __U_STRINGIFY
#undef  __U_STRINGIFYARG
#endif __U_EXECUTABLE_FILENAME__

#endif __U_PROFILEABLE_ONLY__
#endif __U_PROFILE__

#ifdef __U_TRACE__
static uCollectorBoot uBootCollector;
#endif __U_TRACE__

#endif __U_KERNEL__


#pragma __U_USER_CODE__

#endif __U_CPLUSPLUS_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
