//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uC++.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Fri Dec 17 22:10:52 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 26 10:28:06 1999
// Update Count     : 1097
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uProfiler.h>
#include "uNetwork.h"
#include "uHeapLmmm.h"
#include <uBootTask.h>
#include <uSystemTask.h>
//#include <uDebug.h>

#include <exception>


bool		uKernelModule::uCoreDumped		= false;
#ifndef __U_MULTI__
bool		uKernelModule::uDeadlock		= false;
#endif ! __U_MULTI__
bool		uKernelModule::uTerminate		= false;
bool		uKernelModule::uGlobalAbort		= false;
bool		uKernelModule::uGlobalSpinAbort		= false;
uLock		*uKernelModule::uGlobalAbortLock	= (uLock *)0;
uSpinLock	*uKernelModule::uGlobalProcessorLock	= (uSpinLock *)0;
uSpinLock	*uKernelModule::uGlobalClusterLock	= (uSpinLock *)0;
uHeap		*uKernelModule::uHeapManager		= (uHeap *)0;
uDefaultScheduler *uKernelModule::uSystemScheduler	= (uDefaultScheduler *)0;
uIOCluster	*uKernelModule::uSystemCluster		= (uIOCluster *)0;
uProcessor	*uKernelModule::uSystemProcessor	= (uProcessor *)0;
uBootTask	*uKernelModule::uTaskBoot		= (uBootTask *)&uTaskBootStorage;
uSystemTask	*uKernelModule::uTaskSystem		= (uSystemTask *)0;
uProcessor	*uKernelModule::uUserProcessor		= (uProcessor *)0;
uCluster	*uKernelModule::uUserCluster		= (uCluster *)0;

unsigned int    uKernelModule::uAttaching		= 0; // debugger
unsigned int	uKernelModule::uDisableExactProfilingCnt= 0; // profiling

double		uKernelModule::uSystemClusterStorage[(sizeof(uIOCluster) + sizeof(double)) / sizeof(double)] = {0.0};
double		uKernelModule::uTaskBootStorage[(sizeof(uBootTask) + sizeof(double)) / sizeof(double)] = {0.0};
double		uThrowLockStorage[(sizeof(uLock) + sizeof(double)) / sizeof(double)] = {0.0};

uProcessorSeq	*uKernelModule::uGlobalProcessors	= (uProcessorSeq *)0;
uClusterSeq	*uKernelModule::uGlobalClusters		= (uClusterSeq *)0;
#ifdef uFloatingPointDataSize
int		uFloatingPointContext::uUniqueKey	= 0;
#endif // uFloatingPointDataSize
#ifndef __U_MULTI__
uNBIO		*uIOCluster::NBIO			= (uNBIO *)0;
#endif // ! __U_MULTI__
int		uKernelBoot::uCount			= 0;

extern bool uncaught_exception();			// C++ runtime


//######################### uSpinLock #########################


extern "C" int uAtomic( int *lock ) asm("uAtomic");	// assembler routine that performs atomic read/write


uSpinLock::uSpinLock() {
    uValue = 0;						// unlock
} // uSpinLock::uSpinLock


void uSpinLock::uAcquire() {
    // No race condition exists for accessing uDisableIntSpin in the
    // multiprocessor case because this variable is private to each UNIX
    // process. Also, the spin lock must be acquired after adjusting
    // uDisableIntSpin because the time slicing must see the attempt to access
    // the lock first to prevent live-lock on the same processor.  For example,
    // one task acquires the ready queue lock, a time slice occurs, and it does
    // not appear that the current task is in the kernel because
    // uDisableIntSpin is not set so the signal handler tries to yield.
    // However, the ready queue lock is held so the yield live-locks. There is
    // a similar situation on releasing the lock.

#ifdef __U_DEBUG__
#ifndef __U_MULTI__
    if ( uValue != 0 ) {				// locked ?
	uAbort( "(uSpinLock &)0x%p.uAcquire() : internal error, attempt to multiply acquire spin lock by same task", this );
    } // if
#endif __U_MULTI__
#endif __U_DEBUG__

    uKernelModule::uDisableIntSpinLock();

#ifdef __U_MULTI__
    if ( uAtomic( &uValue ) != 0 ) {			// test and set, uAtomic returns 0 or non-zero
	int spin = 1;
	for ( ;; ) {					// poll for lock
	    uKernelModule::uEnableIntSpinLock();
	    for ( int i = 0; i < spin; i += 1 ) {	// exponential spin
		if ( uKernelModule::uGlobalSpinAbort ) {
			_exit( -1 );			// close down in progress, shutdown immediately!
		} // if
	    } // for
	    spin += spin;				// powers of 2
	    if ( spin > 65536 ) spin = 1;		// prevent overflow
	    uKernelModule::uDisableIntSpinLock();
	  if ( uAtomic( &uValue ) == 0 ) break;		// test and set, uAtomic returns 0 or non-zero
	} // for
    } // if
#else
    uValue = 1;						// lock
#endif __U_MULTI__
} // uSpinLock::uAcquire

bool uSpinLock::uTryAcquire() {
#ifdef __U_DEBUG__
#ifndef __U_MULTI__
    if ( uValue != 0 ) {				// locked ?
	uAbort( "(uSpinLock &)0x%p.uTryAcquire() : internal error, attempt to multiply acquire spin lock by same task", this );
    } // if
#endif __U_MULTI__
#endif __U_DEBUG__

    uKernelModule::uDisableIntSpinLock();

#ifdef __U_MULTI__
    if ( uAtomic( &uValue ) == 0 ) {			// get the lock ?
	return true;
    } else {
	uKernelModule::uEnableIntSpinLock();
	return false;
    } // if
#else
    uValue = 1;						// lock
    return true;
#endif __U_MULTI__
} // uSpinLock::uTryAcquire

void uSpinLock::uRelease() {
    uAssert( uValue != 0 );
    uValue = 0;						// unlock
    uKernelModule::uEnableIntSpinLock();
} // uSpinLock::uRelease


uCSpinLock::uCSpinLock( uSpinLock &SpinLock ) : SpinLock( SpinLock ) {
    SpinLock.uAcquire();
} // uCSpinLock::uCSpinLock

uCSpinLock::~uCSpinLock() {
    SpinLock.uRelease();
} // uCSpinLock::~uCSpinLock


//######################### Lock #########################


uLock::uLock() {
    uValue = 1;
} // uLock::uLock

uLock::uLock( unsigned int value ) {
#ifdef __U_DEBUG__
    if ( value > 1 ) {
	uAbort( ": attempt to initialize uLock 0x%p to %d, which exceeds range 0-1.",
	       this, value );
    } // if
#endif __U_DEBUG__
    uValue = value;
} // uLock::uLock

void uLock::uAcquire() {
    for ( ;; ) {
	SpinLock.uAcquire();
      if ( uValue == 1 ) break;
	SpinLock.uRelease();
	uThisTask().uYield();
    } // for
    uValue = 0;
    SpinLock.uRelease();
} // uLock::uAcquire

bool uLock::uTryAcquire() {
    SpinLock.uAcquire();
    if ( uValue == 1 ) {
	uValue = 0;
	SpinLock.uRelease();
	return true;
    } else {
	SpinLock.uRelease();
	return false;
    } // if
} // uLock::uTryAcquire

void uLock::uRelease() {
    uValue = 1;
} // uLock::uRelease


//######################### Real-Time #########################


uWakeupHndlr::uWakeupHndlr( uBaseTask &t ) {
    uThis = &t;
} // uWakeupHndlr::uWakeupHndlr

void uWakeupHndlr::uHandler() {
    uThis->uWake();
} // uWakeupHndlr::uHandler

void uCxtSwtchHndlr::uHandler() {
    // Do not use uYield here because it polls for async events. Async events
    // cannot be delivered because there is a signal handler stack frame on the
    // current stack, and it is unclear what the semantics are for abnormally
    // terminating that frame.

    uThisTask().uYieldNoPoll();
} // uCxtSwtchHndlr::uHandler

uTimeoutHndlr::uTimeoutHndlr( uBaseTask &t, uSerial &serial ) : userial( serial ){
    uThis = &t;
} // uTimeoutHndlr::uTimeoutHndlr

uTimeoutHndlr::uTimeoutHndlr( uSerial &serial ) : userial( serial ){
    uThis = NULL;
} // uTimeoutHndlr::uTimeoutHndlr

void uTimeoutHndlr::uHandler() {
    userial.uEnterTimeout();
} // uTimeoutHndlr::uHandler

uSelectTimeoutHndlr::uSelectTimeoutHndlr( uBaseTask &t, uNBIOnode &n ) : uNode( n ){
    uThis = &t;
} // uTimeoutHndlr::uTimeoutHndlr

void uSelectTimeoutHndlr::uHandler() {
    uNode.uTimedout = true;
} // uTimeoutHndlr::uHandler


uBaseScheduleFriend::uTaskCategory uBaseScheduleFriend::uGetCategory( uBaseTask &t ) const {
    return t.uGetCategory();
} // uBaseScheduleFriend::uGetCategory

uBaseTask &uBaseScheduleFriend::uGetInheritTask( uBaseTask &t ) const {
    return t.uGetInheritTask();
} // uBaseScheduleFriend::uGetInheritTask

int uBaseScheduleFriend::uGetActivePriority( uBaseTask &t ) const {
    // special case for base of active priority stack
    return t.uGetActivePriority();
} // uBaseScheduleFriend::uGetActivePriority

int uBaseScheduleFriend::uSetActivePriority( uBaseTask &t1, uBaseTask &t2 ) {
    return t1.uSetActivePriority( t2 );
} // uBaseScheduleFriend::uSetActivePriority

int uBaseScheduleFriend::uGetBasePriority( uBaseTask &t ) const {
    return t.uGetBasePriority();
} // uBaseScheduleFriend::uGetBasePriority

int uBaseScheduleFriend::uSetBasePriority( uBaseTask &t, int p ) {
    return t.uSetBasePriority( p );
} // uBaseScheduleFriend::uSetBasePriority


//######################### uBasePrioritySeq #########################


bool uBasePrioritySeq::uEmpty() const {
    return list.uEmpty();
} // uBasePrioritySeq::uEmpty

uBaseTaskDL *uBasePrioritySeq::uHead() const {
    return list.uHead();
} // uBasePrioritySeq::uHead

void uBasePrioritySeq::uAdd( uBaseTaskDL *node ) {
    list.uAddTail( node );
} // uBasePrioritySeq::uAdd

uBaseTaskDL *uBasePrioritySeq::uDrop() {
    return list.uDropHead();
} // uBasePrioritySeq::uDrop

void uBasePrioritySeq::uRemove( uBaseTaskDL *node ) {
    list.uRemove( node );
} // uBasePrioritySeq::uRemove


//######################### uDefaultScheduler #########################


bool uDefaultScheduler::uEmpty() const {
    return list.uEmpty();
} // uDefaultScheduler::uEmpty

void uDefaultScheduler::uAdd( uBaseTaskDL *node ) {
    list.uAddTail( node );
} // uDefaultScheduler::uAdd

uBaseTaskDL *uDefaultScheduler::uDrop() {
    return list.uDropHead();
} // uDefaultScheduler::uDrop

bool uDefaultScheduler::uCheckPriority( uBaseTaskDL &, uBaseTaskDL & ) { return false; }

void uDefaultScheduler::uResetPriority( uBaseTaskDL &, uBaseTaskDL & ) {}

void uDefaultScheduler::uAddInitialize( uBaseTaskSeq & ) {};

void uDefaultScheduler::uRemoveInitialize( uBaseTaskSeq & ) {};

void uDefaultScheduler::uRescheduleTask( uBaseTaskDL *, uBaseTaskSeq & ) {};


//######################### uRollForward #########################


void uKernelModule::uRollForward( bool inKernel ) {
    uAssert( ! uDisableIntSpin );
#ifdef __U_DEBUG_H__
    char buffer[256];
    int debugCnt = 0;
    uDebugPrtBuf( buffer, "uRollForward( %d ), uDisableInt:%d, uDisableIntCnt:%d, uInKernelRF:%d\n",
		  inKernel, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uKernelModule::uInKernelRF );
#endif __U_DEBUG_H__

    uEventList *events = uThisProcessor().uEvents;	// copy the current processor as it could change during execution
    uEventNode *event;

    for ( uEventListPop gen( *events, inKernel ); gen >> event; ) {
#ifdef __U_DEBUG_H__
	debugCnt += 1;
	uDebugPrtBuf( buffer, "uRollForward, pop #%d\n", debugCnt );
#endif __U_DEBUG_H__
    } // for

#ifdef __U_DEBUG_H__
    uDebugPrtBuf( buffer, "uRollForward, leaving, uInKernelRF:%d\n", uKernelModule::uInKernelRF );
#endif __U_DEBUG_H__
} // uRollForward


//######################### Translator Generated Definitions #########################


uCoroutineConstructor::uCoroutineConstructor( uAction f, uBaseCoroutine &c, char *n ) {
    if ( f == uYes ) {
	c.uStartHere( (void (*)( uMachContext & ))uMachContext::uInvokeCoroutine );
	c.uName = n;					// do not use uSetName for trace reasons

	if ( c.uProfileActive && uProfiler::uProfiler_RegisterCoroutine ) { // profiling this coroutine & coroutine registered for profiling ? 
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	    // make sure the currently executing task doesn't profile call
	    (*uProfiler::uProfiler_RegisterCoroutine)( uProfiler::uProfilerInstance, c );
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
	} // if
    } // if
} // uCoroutineConstructor::uCoroutineConstructor


uCoroutineMain::uCoroutineMain( uBaseCoroutine &c ) : c( c ) {
} // uCoroutineMain::uCoroutineMain

uCoroutineMain::~uCoroutineMain() {
} // uCoroutineMain::~uCoroutineMain


uSerial::uSerial( uBasePrioritySeq &uEntryList ) : uEntryList( uEntryList ) {
    uMask.zero();					// mutex members start closed
    uMutexOwner = &uThisTask();				// set the current mutex owner *for the creating task*

    // abnormal event

    uLastAcceptor = NULL;
    uAlive = true;
    uTimedoutRF = false;

    // real-time

    uTimeoutEvent.uExecuteLocked = true;
    uProc = NULL;
    uEvents = NULL;
} // uSerial::uSerial

uSerial::~uSerial() {
    uAlive = false;					// no more entry call can be accepted
#ifdef __U_DEBUG__
    uBaseTask &uCallingTask = uThisTask();

    for ( ;; ) {
	uBaseTaskDL *p = uAcceptSignalled.uPop();
      if ( p == NULL ) break;
	uMutexOwner = &(p->uGet());
	uThrow uEntryFailure( this, "blocked on acceptor/signalled stack" ) uAt *(uMutexOwner->uCurrCoroutine);
	uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) ); // suspend current task on top of accept/signalled stack
	uActiveProcessorKernel->uSchedule( uMutexOwner );
    } // for

    if ( ! uEntryList.uEmpty() ) {			// no need to acquire the lock if the queue is empty
	for ( ;; ) {
	    lock.uAcquire();
	    uBaseTaskDL *p = uEntryList.uDrop();
	  if ( p == NULL ) break;
	    uMutexOwner = &(p->uGet());
	    uMutexOwner->uCalledEntryMem->uDrop();
	    uThrow uEntryFailure( this, "blocked on entry queue" ) uAt *(uMutexOwner->uCurrCoroutine);
	    uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) ); // suspend current task on top of accept/signalled stack
	    uActiveProcessorKernel->uSchedule( &lock, uMutexOwner );
	} // for
	lock.uRelease();
    } // if
#endif __U_DEBUG__
} // uSerial::~uSerial

void uSerial::uEnter( int &mr, uBasePrioritySeq &entry, int maskPosn ) {
    lock.uAcquire();

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uEnter, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, entry:0x%p, maskPosn:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, &entry, maskPosn );
#endif __U_DEBUG_H__
    uBaseTask &uCallingTask = uThisTask();		// optimization
    if ( uMask.isSet( maskPosn ) ) {			// member acceptable ?
	uMask.zero();					// clear the mask
	mr = uCallingTask.uMutexRecursion;		// save previous recursive count
	uCallingTask.uMutexRecursion = 0;		// reset recursive count
	uMutexOwner = &uCallingTask;			// set the current mutex owner
	lock.uRelease();
    } else if ( uMutexOwner == &uCallingTask ) {	// already hold mutex ?
	uCallingTask.uMutexRecursion += 1;		// another recursive call at the mutex object level
	lock.uRelease();
    } else {						// otherwise block the calling task
	entry.uAdd( &(uCallingTask.uMutexRef) );	// add to end of mutex queue
	uCallingTask.uCalledEntryMem = &entry;		// remember which entry was called
	uEntryList.uAdd( &(uCallingTask.uEntryRef) );	// add mutex object to end of general entry deque
	uEntryList.uAfterEntry( *uMutexOwner );	// perform any priority inheritance
	uActiveProcessorKernel->uSchedule( &lock );	// find someone else to execute; release lock on kernel stack
	mr = uCallingTask.uMutexRecursion;		// save previous recursive count
	uCallingTask.uMutexRecursion = 0;		// reset recursive count
	uEnable <uSerial::uFailure> {
	    uPollAE();
	} // uEnable
    } // if
    uMutexMaskPosn = maskPosn;				// set active mutex member
} // uSerial::uEnter

void uSerial::uEnterNoPoll( int &mr, uBasePrioritySeq &entry, int maskPosn ) {
    lock.uAcquire();

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uEnterNoPoll, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, entry:0x%p, maskPosn:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, &entry, maskPosn );
#endif __U_DEBUG_H__
    uBaseTask &uCallingTask = uThisTask();		// optimization
    if ( uMask.isSet( maskPosn ) ) {			// member acceptable ?
	uMask.zero();					// clear the mask
	mr = uCallingTask.uMutexRecursion;		// save previous recursive count
	uCallingTask.uMutexRecursion = 0;		// reset recursive count
	uMutexOwner = &uCallingTask;			// set the current mutex owner
	lock.uRelease();
    } else if ( uMutexOwner == &uCallingTask ) {	// already hold mutex ?
	uCallingTask.uMutexRecursion += 1;		// another recursive call at the mutex object level
	lock.uRelease();
    } else {						// otherwise block the calling task
	entry.uAdd( &(uCallingTask.uMutexRef) );	// add to end of mutex queue
	uCallingTask.uCalledEntryMem = &entry;		// remember which entry was called
	uEntryList.uAdd( &(uCallingTask.uEntryRef) );	// add mutex object to end of general entry deque
	uEntryList.uAfterEntry( *uMutexOwner );	// perform any priority inheritance
	uActiveProcessorKernel->uSchedule( &lock );	// find someone else to execute; release lock on kernel stack
	mr = uCallingTask.uMutexRecursion;		// save previous recursive count
	uCallingTask.uMutexRecursion = 0;		// reset recursive count
    } // if
    uMutexMaskPosn = maskPosn;				// set active mutex member
} // uSerial::uEnterNoPoll

void uSerial::uEnterTimeout() {
    // SKULLDUGGERY: The monitor spin lock is acquired directly because this
    // pseudo mutex member is called from the kernel, and therefore, cannot
    // block, but it can spin.

    lock.uAcquire();
    uDoTimeout();
    lock.uRelease();
} // uSerial::uEnterTimeout

void uSerial::uDoTimeout() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uDoTimeout, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p, uMutexMaskPosn:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner, uMutexMaskPosn );
#endif __U_DEBUG_H__
    if ( uMask.isSet( 0 ) ) {				// timeout member acceptable ?  0 => timeout mask bit
	uMask.zero();					// clear the mask
	uMutexMaskPosn = 0;				// set timeout mutex member  0 => timeout mask bit
	uMutexOwner = &(uAcceptSignalled.uDrop()->uGet()); // next task to gain control of the mutex object
	
	// priority-inheritance, bump up priority of mutexowner from head
	// of prioritized entry queue (NOT leaving task), because suspended
	// stack is not prioritized.
	
	uEntryList.uAfterEntry( *uMutexOwner );

#ifdef __U_DEBUG_H__
	uDebugPrt( "(uSerial &)0x%p.uDoTimeout, waking task 0x%p (%.256s) \n", this, uMutexOwner, uMutexOwner->uGetName() );
#endif __U_DEBUG_H__
	uMutexOwner->uWake();				// wake up next task to use this mutex object
    } // if
} // uSerial::uDoTimeout

// uLeave and uLeave2 do not poll for asynchronous abnormal events because they
// are called in some critical destructors.  Throwing an exception out of these
// destructors causes problems.

void uSerial::uLeave( int mr ) {			// used when a task is leaving a mutex and has not queued itself before calling
    uBaseTask &uCallingTask = uThisTask();		// optimization
    if ( uCallingTask.uMutexRecursion != 0 ) {		// already hold mutex ?
	uCallingTask.uMutexRecursion -= 1;
    } else {
	if ( uAcceptSignalled.uEmpty() ) {		// no tasks waiting re-entry to mutex object ?
	    lock.uAcquire();
	    if ( uEntryList.uEmpty() ) {		// no tasks waiting entry to mutex object ?
		uMask.one();				// accept all members
		uMutexOwner = (uBaseTask *)0;		// reset no task in mutex object
		lock.uRelease();
	    } else {					// tasks wating entry to mutex object
		uMutexOwner = &(uEntryList.uDrop()->uGet()); // next task to gain control of the mutex object
		uMutexOwner->uCalledEntryMem->uDrop();	// remove member from front of entry queue
		lock.uRelease();
#ifdef __U_DEBUG_H__
		uDebugPrt( "(uSerial &)0x%p.uLeave, waking task 0x%p (%.256s)\n", this, uMutexOwner, uMutexOwner->uGetName() );
#endif __U_DEBUG_H__
		uMutexOwner->uWake();			// wake up next task to use this mutex object
	    } // if
	} else {
	    uMutexOwner = &(uAcceptSignalled.uDrop()->uGet()); // next task to gain control of the mutex object

	    // priority-inheritance, bump up priority of mutexowner from head
	    // of prioritized entry queue (NOT leaving task), because suspended
	    // stack is not prioritized.

	    uEntryList.uAfterEntry( *uMutexOwner );

#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSerial &)0x%p.uLeave, waking task 0x%p (%.256s)\n", this, uMutexOwner, uMutexOwner->uGetName() );
#endif __U_DEBUG_H__
	    uMutexOwner->uWake();			// wake up next task to use this mutex object
	} // if
	uCallingTask.uMutexRecursion = mr;		// restore previous recursive count
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uLeave, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif __U_DEBUG_H__
} // uSerial::uLeave

void uSerial::uLeave2() {				// used when a task is leaving a mutex and has queued itself before calling
    if ( uAcceptSignalled.uEmpty() ) {			// no tasks waiting re-entry to mutex object ?
	lock.uAcquire();
	if ( uEntryList.uEmpty() ) {			// no tasks waiting entry to mutex object ?
	    uMask.one();				// accept all members
	    // unnecessary to set uMutexOwner to NULL because mask is open
	    uActiveProcessorKernel->uSchedule( &lock ); // find someone else to execute; release lock on kernel stack
	} else {
	    uMutexOwner = &(uEntryList.uDrop()->uGet()); // next task to gain control of the mutex object
	    uMutexOwner->uCalledEntryMem->uDrop();	 // remove from front of member entry queue
#ifdef __U_DEBUG_H__
	    uDebugPrt( "(uSerial &)0x%p.uLeave2, waking task 0x%p (%.256s)\n", this, uMutexOwner, uMutexOwner->uGetName() );
#endif __U_DEBUG_H__
	    uActiveProcessorKernel->uSchedule( &lock, uMutexOwner ); // find someone else to execute; release lock and wake on kernel stack
	} // if
    } else {
	uMutexOwner = &(uAcceptSignalled.uDrop()->uGet()); // next task to gain control of the mutex object

	// priority-inheritance, bump up priority of mutexowner from head of
	// prioritized entry queue (NOT leaving task), because suspended stack
	// is not prioritized.

	uEntryList.uAfterEntry( *uMutexOwner );

#ifdef __U_DEBUG_H__
	uDebugPrt( "(uSerial &)0x%p.uLeave2, waking task 0x%p (%s)\n", this, uMutexOwner, uMutexOwner->uGetName() );
#endif __U_DEBUG_H__
	uActiveProcessorKernel->uSchedule( uMutexOwner ); // find someone else to execute; wake on kernel stack
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uLeave2, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif __U_DEBUG_H__
} // uSerial::uLeave2

// The field uSerial::uLastAcceptor is set in uAcceptTry and uAcceptPause and
// reset to NULL in uSerialMember::uSerialMember, so an exception can be thrown
// when all the guards in the accept statement fail.  This ensures that
// uLastAcceptor is set only when a task rendezouvs with another task.

void uSerial::uAcceptStart( unsigned int &uMutexMaskPosn ) {
    lock.uAcquire();
    uMask.zero();
    uMutexMaskPosn = uSerial::uMutexMaskPosn;

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterAcceptStart ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterAcceptStart)( uProfiler::uProfilerInstance, *this, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uSerial::uAcceptStart

bool uSerial::uAcceptTry( uBasePrioritySeq &entry, int maskPosn ) {
    // lock is already acquired at beginning of accept statement
    if ( entry.uEmpty() ) {
	uMask.set( maskPosn );				// add this mutex member to the mask
	return false;					// the accept failed
    } else {
	uBaseTask &uCallingTask = uThisTask();		// optimization
	uMutexOwner = &(entry.uDrop()->uGet());		// next task to use this mutex object
	uLastAcceptor = &uCallingTask;			// saving the acceptor thread of a rendezvous
	uEntryList.uRemove( &(uMutexOwner->uEntryRef) ); // also remove task from general entry deque
	uMask.zero();					// clear the mask
	uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) ); // suspend current task on top of accept/signalled stack
	uActiveProcessorKernel->uSchedule( &lock, uMutexOwner ); // find someone else to execute; release lock and wake on kernel stack
	if ( uCallingTask.uAcceptedCall ) {             // accepted entry is suspended if true
	    uCallingTask.uAcceptedCall->uAcceptorSuspended = false; // acceptor resumes
	    uCallingTask.uAcceptedCall = NULL;
	} // if
	uEnable <uSerial::uRendezvousFailure> {
	    uPollAE();
	} // uEnable
	return true;
    } // if
} // uSerial::uAcceptTry

void uSerial::uAcceptTry() {
    // lock is already acquired at beginning of accept statement
    uMask.set( 0 );					// add this mutex member to the mask, 0 => timeout mask bit
} // uSerial::uAcceptTry

bool uSerial::uAcceptTestMask() {
    return uMask.isZero();
} // uSerial::uAcceptTestMask

void uSerial::uAcceptElse() {
    uMask.zero();
    lock.uRelease();
} // uSerial::uAcceptElse

void uSerial::uAcceptPause() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uAcceptPause, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif __U_DEBUG_H__
    // lock is acquired at beginning of accept statement
    uBaseTask &uCallingTask = uThisTask();		// optimization
    uLastAcceptor = &uCallingTask;			// saving the acceptor thread of a rendezvous
    uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) ); // suspend current task on top of accept/signalled stack
    // unnecessary to set uMutexOwner to NULL because mask is open
    uActiveProcessorKernel->uSchedule( &lock );		// find someone else to execute; release lock on kernel stack

    if ( uCallingTask.uAcceptedCall ) {			// accepted entry is suspended if true
        uCallingTask.uAcceptedCall->uAcceptorSuspended = false;	// acceptor resumes
	uCallingTask.uAcceptedCall = NULL;
    } // if
    uEnable <uSerial::uFailure> {
	uPollAE();
    } // uEnable
} // uSerial::uAcceptPause

void uSerial::uAcceptPause( uDuration duration ) {
    uAcceptPause( uActiveProcessorKernel->uKernelClock.uGetTime() + duration );
} // uSerial::uAcceptPause

void uSerial::uAcceptPause( uTime time ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uSerial &)0x%p.uAcceptPause, mask:0x%x,0x%x,0x%x,0x%x, owner:0x%p\n",
	       this, uMask[0], uMask[1], uMask[2], uMask[3], uMutexOwner );
#endif __U_DEBUG_H__
    uTimeoutHndlr handler( uThisTask(), *this );	// handler to wake up blocking task

    uTimeoutEvent.uExecuteLocked = true;
    uTimeoutEvent.timerT = time;
    uTimeoutEvent.uWho = &uThisTask();
    uTimeoutEvent.SigHandler = &handler;

    uProc = &uThisProcessor();
    uEvents = uProc->uEvents;
    uEvents->uAddEvent( uTimeoutEvent, *uProc );

    // lock is acquired at beginning of accept statement
    uBaseTask &uCallingTask = uThisTask();		// optimization
    uLastAcceptor = &uCallingTask;			// saving the acceptor thread of a rendezvous
    uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) );	// suspend current task on top of accept/signalled stack
    // unnecessary to set uMutexOwner to NULL because mask is open
    uActiveProcessorKernel->uSchedule( &lock );		// find someone else to execute; release lock on kernel stack

    uEvents->uRemoveEvent( uTimeoutEvent, *uProc );

    if ( uCallingTask.uAcceptedCall ) {			// accepted entry is suspended if true
        uCallingTask.uAcceptedCall->uAcceptorSuspended = false;	// acceptor resumes
	uCallingTask.uAcceptedCall = NULL;
    } // if
    uEnable <uSerial::uFailure> {
	uPollAE();
    } // uEnable
} // uSerial::uAcceptPause

void uSerial::uRemoveTimeout() {
    if ( uEvents != NULL ) {
	uEvents->uRemoveEvent( uTimeoutEvent, *uProc );
    } // if
} // uSerial::uRemoveTimeout

void uSerial::uAcceptEnd( unsigned int uMutexMaskPosn ) {
    uSerial::uMutexMaskPosn = uMutexMaskPosn;

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterAcceptEnd ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterAcceptEnd)( uProfiler::uProfilerInstance, *this, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uSerial::uAcceptEnd


uSerial::uProtectAcceptStmt::uProtectAcceptStmt(uSerial &s) : s(s) {
    s.uAcceptStart( uMutexMaskPosn );
} // uSerial::uProtectAcceptStmt::uProtectAcceptStmt

uSerial::uProtectAcceptStmt::uProtectAcceptStmt(uSerial &s, bool ) : s(s) {
    s.uRemoveTimeout();
    s.uAcceptStart( uMutexMaskPosn );
} // uSerial::uProtectAcceptStmt::uProtectAcceptStmt

uSerial::uProtectAcceptStmt::~uProtectAcceptStmt() {
    s.uAcceptEnd( uMutexMaskPosn );
} // uSerial::uProtectAcceptStmt::~uProtectAcceptStmt


uSerial::uFailure::uFailure( const uSerial *const serial, const char *const msg ) : uKernelFailure( msg ), serial( serial ) {}

uSerial::uFailure::uFailure( const char *const msg ) : uKernelFailure( msg ), serial( NULL ) {}

uSerial::uFailure::~uFailure() {}

const uSerial *const uSerial::uFailure::uSerialID() { return serial; }

void uSerial::uFailure::uDefaultTerminate() const {
    uAbort( "Unhandled event uSerial::uFailure : %.256s", uMsg() );
} // uSerial::uFailure::uDefaultTerminate


uSerial::uEntryFailure::uEntryFailure( const uSerial *const serial, const char *const msg ) : uSerial::uFailure( serial, msg ) {}

uSerial::uEntryFailure::uEntryFailure( const char *const msg ) : uSerial::uFailure( msg ) {}

uSerial::uEntryFailure::~uEntryFailure() {}

void uSerial::uEntryFailure::uDefaultTerminate() const {
    uAbort( "Unhandled event uSerial::uEntryFailure : while executing mutex destructor, task 0x%p (%.256s) found %.256s.",
	   &uSrc(), uSrcName(), uMsg() );
} // uSerial::uEntryFailure::uDefaultTerminate


uSerial::uRendezvousFailure::uRendezvousFailure( const uSerial *const serial_id, const char *const msg ) : uSerial::uFailure( serial_id, msg ), caller( &uThisCoroutine() ) {}

uSerial::uRendezvousFailure::~uRendezvousFailure() {}

const uBaseCoroutine *const uSerial::uRendezvousFailure::uCaller() { return caller; }

void uSerial::uRendezvousFailure::uDefaultTerminate() const {
    uAbort( "Unhandled event uSerial::uRendezvousFailure : %.256s from task 0x%p (%.256s) to mutex member of task 0x%p (%.256s).",
	   uMsg(), &uSrc(), uSrcName(), &uThisTask(), uThisTask().uGetName() );
} // uSerial::uRendezvousFailure::uDefaultTerminate


uInitEvent(uSerial::uFailure);
uInitEvent(uSerial::uEntryFailure);
uInitEvent(uSerial::uRendezvousFailure);


uTaskConstructor::uTaskConstructor( uAction f, uSerial &s, uBaseTask &t, const char *n, bool a ) {
    if ( f == uYes ) {
	t.uStartHere( (void (*)( uMachContext & ))uMachContext::uInvokeTask );
	t.uName = n;					// do not use uSetName for trace reasons

	t.uProfileActive = a;
	if ( t.uProfileActive && uProfiler::uProfiler_RegisterTask ) { // profiling this task & task registered for profiling ? 
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	    // make sure the currently executing task doesn't profile call
	    (*uProfiler::uProfiler_RegisterTask)( uProfiler::uProfilerInstance, t );
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
	} // if

	s.uAcceptSignalled.uAdd( &(t.uMutexRef) );

#if __U_LOCALDEBUGGER_H__
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->checkPoint();
#endif __U_LOCALDEBUGGER_H__

	t.uCurrCluster->uTaskAdd( t );			// add task to the list of tasks on this cluster
    } // if
} // uTaskConstructor::uTaskConstructor


uTaskDestructor::uTaskDestructor( uAction f, uBaseTask &t ) : flag( f ), t( t ) {
} // uTaskDestructor::uTaskDestructor

uTaskDestructor::~uTaskDestructor() {
    if ( flag == uYes ) {
#ifdef __U_DEBUG__
	if ( t.uBaseCoroutine::uGetState() != uBaseCoroutine::uHalt ) {
	    uAbort( ": attempt to delete task 0x%p (%.256s) that is not halted.\n"
		   "Possible cause is that the task is blocked on a condition queue.",
		   &t, t.uGetName() );
	} // if
#endif __U_DEBUG__

#if __U_LOCALDEBUGGER_H__
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->checkPoint();
#endif __U_LOCALDEBUGGER_H__

	t.uCurrCluster->uTaskRemove( t );		// remove the task from the list of tasks that live on this cluster.
    } // if
} // uTaskDestructor::uTaskDestructor


uTaskMain::uTaskMain( uSerial &s ) : s( s ) {
    // SKULLDUGGERY: To allow "main" to be treated as a normal member routine,
    // a counter is used to to allow recursive entry.

    if ( uThisTask().uRecursion == 0 ) {
#if __U_LOCALDEBUGGER_H__
	// Registering a task with the global debugger must occur in this
	// routine for the register set to be correct.

	if ( uLocalDebugger::uLocalDebuggerActive ) {
	    uLocalDebugger::uLocalDebuggerInstance->createULThread();
	} // if
#endif __U_LOCALDEBUGGER_H__
    } // if
    uThisTask().uRecursion += 1;
} // uTaskMain::uTaskMain

uTaskMain::~uTaskMain() {
    uThisTask().uRecursion -= 1;
    if ( uThisTask().uRecursion == 0 ) {
#if __U_LOCALDEBUGGER_H__
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->destroyULThread();
#endif __U_LOCALDEBUGGER_H__
	if ( ! uThisCoroutine().uUncaughtException() ) {
	    uDisable {					// task has terminated so ignore async events
		uThisTask().uNotHalted = false;
		s.uLeave2();
		// CONTROL SHOULD NOT RETURN HERE! 
		uAbort( "uTaskMain::~uTaskMain() : internal error." );
	    } // uDisable
	} // if
    } // if
} // uTaskMain::~uTaskMain


uSerialConstructor::uSerialConstructor( uAction f, uSerial &s ) : flag( f ), s( s ) {
    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterMonitor ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterMonitor)( uProfiler::uProfilerInstance, s, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uSerialConstructor::uSerialConstructor

uSerialConstructor::~uSerialConstructor() {
    if ( flag == uYes ) {
	int mr = uThisTask().uMutexRecursion;		// save previous recursive count
	uThisTask().uMutexRecursion = 0;		// reset recursive count
	s.uLeave( mr );
    } // if
} // uSerialConstructor::~uSerialConstructor


uSerialDestructor::uSerialDestructor( uAction f, uSerial &s, uBasePrioritySeq &e, int m ) : flag(f), s(s) {
    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_DeregisterMonitor ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_DeregisterMonitor)( uProfiler::uProfilerInstance, s, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if

    if ( f == uYes ) {
	s.uEnterNoPoll( mutexRecursion, e, m );
	if ( ! s.uAcceptSignalled.uEmpty() ) {
	    s.uLastAcceptor = NULL;
	    uBaseTask &uCallingTask = uThisTask();	// optimization
	    s.uMutexOwner = &(s.uAcceptSignalled.uDrop()->uGet());
	    s.uAcceptSignalled.uAdd( &(uCallingTask.uMutexRef) ); // suspend terminating task on accept/signalled stack
	    uActiveProcessorKernel->uSchedule( s.uMutexOwner ); // find someone else to execute; wake on kernel stack
	} // if
    } // if
} // uSerialDestructor::uSerialDestructor

uSerialDestructor::~uSerialDestructor() {
    if ( flag == uYes && uThisCoroutine().uUncaughtException() ) {
	s.uLeave( mutexRecursion );
    } // if
} // uSerialDestructor::~uSerialDestructor

uSerialMember::uSerialMember( uSerial &s, uBasePrioritySeq &e, int m ) : s( s ), uInheritTask( uThisTask().uGetInheritTask() ) {
#ifdef __U_DEBUG__
    // There is a race condition between setting and testing this flag.
    // However, it is the best that can be expected because the mutex storage
    // is being deleted.

    if ( ! s.uAlive ) {					// check against improper memory management
	uThrow uSerial::uEntryFailure( &s, "mutex object has been destroyed" );
    } // if
#endif __U_DEBUG__

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionEntryTry ) { // task registered for profiling ?
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterMutexFunctionEntryTry)( uProfiler::uProfilerInstance, s, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if

    // no #ifdef __U_DEBUG__ around try clause because there is implicit polling inside uEnter
    try {
	// Polling in uEnter happens after properly setting values of
	// mutexRecursion and therefore, in the catch clause, it can be used to
	// retore the mutexRecursion value in the uSerial object.

	s.uEnter( mutexRecursion, e, m );
        acceptor = s.uLastAcceptor;
	uAcceptorSuspended = acceptor != NULL;
	if ( uAcceptorSuspended ) {
	    acceptor->uAcceptedCall = this;
	} // if
	s.uLastAcceptor = NULL;				// avoid messing up subsequent mutex method invocation
    } catch( ... ) {
        if ( s.uLastAcceptor ) {
	    s.uLastAcceptor->uAcceptedCall = NULL;      // the rendezvous did not materialize
	    uRaise uSerial::uRendezvousFailure( &s, "accepted call fails" ) uAt *s.uLastAcceptor; // acceptor is not initialized
	    s.uLastAcceptor = NULL;
	} // if
	s.uLeave( mutexRecursion );			// look at ~uSerialMember()
	uThisTask().uSetActivePriority( uInheritTask );
	uThrow;
    } // try

    noUserOverride = true;

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionEntryDone ) { // task registered for profiling ?
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterMutexFunctionEntryDone )( uProfiler::uProfilerInstance, s, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uSerialMember::uSerialMember

uSerialMember::~uSerialMember() {
    if ( acceptor ) {
	acceptor->uAcceptedCall = NULL;			// accepted entry terminates
	// raise an asynchronous event at the acceptor
	if ( uThisCoroutine().uUncaughtException() && noUserOverride ) {
	    uRaise uSerial::uRendezvousFailure( &s, "accepted call fails" ) uAt *uAcceptor();
	} // if
    } // if

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterMutexFunctionExit ) { // task registered for profiling ?
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterMutexFunctionExit)( uProfiler::uProfilerInstance, s, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if

    s.uLeave( mutexRecursion );
    uThisTask().uSetActivePriority( uInheritTask );
} // uSerialMember::~uSerialMember

uBaseCoroutine *uSerialMember::uAcceptor() {
    noUserOverride = false;
    return ( s.uAlive && uAcceptorSuspended ) ? acceptor->uCurrCoroutine : (uBaseCoroutine *)0;
} // uSerialMember::uAcceptor


uCondition::uCondition() : owner( (uSerial *)0 ) {
} // uCondition::uCondition

uCondition::~uCondition() {
#ifdef __U_DEBUG__
    // A uCondition object must be destroyed before its owner.  Concurrent
    // execution of the destructor for a uCondition and its owner is
    // unacceptable.  The flag owner->uAlive tells if a mutex object is
    // destroyed or not but it cannot protect against concurrent execution.  As
    // long as uCondition objects are declared inside its owner mutex object,
    // the proper order of destruction is guaranteed.

    if ( ! uCondQueue.uEmpty() ) {
	// wake each task blocked on the condition with an async event
	for ( ;; ) {
	    uBaseTaskDL *p = uCondQueue.uHead();	// get the task blocked at the start of the condition
	  if ( p == (uBaseTaskDL *)0 ) break;		// list empty ?
	    uAEHM::uDeliverAEStack dummy( false );	// block all async abnormal events in destructor
	    uBaseTask &t = p->uGet();
	    uThrow uWaitingFailure( this, "found blocked task on condition variable" ) uAt *(t.uCurrCoroutine); // throw async event at blocked task
	    uSBlock( *owner );				// restart (signal) the blocked task
	} // for
    } // if
#endif __U_DEBUG__
} // uCondition::~uCondition

bool uCondition::uEmpty() const {			// test for tasks on a condition
    return uCondQueue.uEmpty();				// check if the condition queue is empty
} // uCondition::uEmpty

long int uCondition::uFront() const {			// return task information
#ifdef __U_DEBUG__
    if ( uCondQueue.uEmpty() ) {			// condition queue must not be empty
	uAbort( ": attempt to access data with uFront on an empty condition.\n"
	       "Possible cause is not checking if the condition is empty before attempting to read stored data."
	       );
    } // if
#endif __U_DEBUG__
    return uCondQueue.uHead()->uGet().uInfo;		// return condition information stored with blocked task
} // uCondition::uFront

void uCondition::uW( uSerial &s ) {			// wait on a condition
#ifdef __U_DEBUG__
    if ( &uThisTask() != s.uMutexOwner ) {		// must have mutex lock to wait
	uAbort( ": attempt to wait on a condition variable in a mutex object not locked by this task.\n"
	       "Possible cause is attempting to wait on a condition variable in a no mutex member routine."
	       );
    } // if
    if ( owner != &s ) {				// only owner can use condition
	if ( owner == (uSerial *)0 ) {			// owner exist ?
	    owner = &s;					// set condition owner
	} else {
	    uAbort( ": attempt to wait on a condition variable not owned by this mutex object.\n"
		   "Possible cause is passing the condition variable outside of the mutex object in which it is created but after it has been used."
		   );
	} // if
    } // if
#endif __U_DEBUG__
    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterWait ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterWait)( uProfiler::uProfilerInstance, *this, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if

    uCondQueue.uAdd( &(uThisTask().uMutexRef) );	// add to end of condition queue

    uEnable <uSerial::uFailure> {			// the list of exception enabled has to be determined
        s.uLeave2();					// release mutex and let it schedule another task
	uPollAE();					// uLeave2 does not poll for async abnormal events
    } // uEnable

    if ( uKernelModule::uActiveTask->uProfileActive && uProfiler::uProfiler_RegisterSignal ) { // task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterSignal)( uProfiler::uProfilerInstance, *this, uThisTask() );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uCondition::uW

void uCondition::uW( uSerial &s, long int info ) {	// wait on a condition with information
    uThisTask().uInfo = info;				// store the information with this task
    uW( s );						// wait on this condition
} // uCondition::uW

void uCondition::uS( uSerial &s ) {			// signal a condition
    if ( ! uCondQueue.uEmpty() ) {
#ifdef __U_DEBUG__
	if ( &uThisTask() != s.uMutexOwner ) {		// must have mutex lock to signal
	    uAbort( ": attempt to signal a condition variable in a mutex object not locked by this task.\n"
		   "Possible cause is attempting to signal a condition variable in a no mutex member routine."
		   );
	} // if
	if ( owner != &s ) {				// only owner can use condition
	    uAbort( ": attempt to signal a condition variable not owned by this mutex object.\n"
		   "Possible cause is passing the condition variable outside of the mutex object in which it is created but after it has been used."
		   );
	} // if
#endif __U_DEBUG__
	s.uAcceptSignalled.uAdd( uCondQueue.uDrop() );	// move signalled task on accept/signalled stack
    } // if
} // uCondition::uS

void uCondition::uSBlock( uSerial &s ) {		// signal a condition
    if ( ! uCondQueue.uEmpty() ) {
#ifdef __U_DEBUG__
	if ( &uThisTask() != s.uMutexOwner ) {		// must have mutex lock to signal
	    uAbort( ": attempt to signal a condition variable in a mutex object not locked by this task.\n"
		   "Possible cause is attempting to signal a condition variable in a no mutex member routine."
		   );
	} // if
	if ( owner != &s ) {				// only owner can use condition
	    uAbort( ": attempt to signal a condition variable not owned by this mutex object.\n"
		   "Possible cause is passing the condition variable outside of the mutex object in which it is created but after it has been used."
		   );
	} // if
#endif __U_DEBUG__
	s.uAcceptSignalled.uAdd( &(uThisTask().uMutexRef) ); // suspend signaller task on accept/signalled stack
	s.uAcceptSignalled.uAdd( uCondQueue.uDrop() );	// move signalled task on accept/signalled stack
	s.uLeave2();					// release mutex and let it schedule the signalled task
    } // if
} // uCondition::uSBlock


uCondition::uWaitingFailure::uWaitingFailure( const uCondition *const cond, const char *const msg ) : uSerial::uFailure( cond->owner, msg ), cond( cond ) {}

uCondition::uWaitingFailure::~uWaitingFailure() {}

const uCondition *const uCondition::uWaitingFailure::uConditionID() const { return cond; }

void uCondition::uWaitingFailure::uDefaultTerminate() const {
    uAbort( "Unhandled event uCondition::uWaitingFailure : task 0x%p (%.256s) found blocked task 0x%p (%.256s) on condition variable 0x%p.",
	   &uSrc(), uSrcName(), &uThisTask(), uThisTask().uGetName(), uConditionID() );
} // uCondition::uWaitingFailure::uDefaultTerminate

uInitEvent(uCondition::uWaitingFailure);


//######################### Kernel Boot #########################


void uKernelBoot::startup() {
    // create kernel locks

    uAEHM::uThrowLock = new((void *)&uThrowLockStorage) uLock;

    uKernelModule::uGlobalAbortLock = new uLock;
    uKernelModule::uGlobalProcessorLock = new uSpinLock;
    uKernelModule::uGlobalClusterLock = new uSpinLock;

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.startup1, uDisableInt:%d, uDisableIntCnt:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt );
#endif __U_DEBUG_H__

    // initialize kernel signal handlers

    uSigHandlerModule();

    // create global lists

    uKernelModule::uGlobalProcessors = new uProcessorSeq;
    uKernelModule::uGlobalClusters = new uClusterSeq;

    // SKULLDUGGERY: Initialize the global pointers with the appropriate memory
    // locations and then "new" the cluster and processor. Because the global
    // pointers are initialized, all the references through them in the cluster
    // and processor constructors work out. (HA!)

    uKernelModule::uSystemProcessor = &(((uIOCluster *)&uKernelModule::uSystemClusterStorage)->processor);
    uKernelModule::uSystemCluster = (uIOCluster *)&uKernelModule::uSystemClusterStorage;
    uKernelModule::uSystemScheduler = new uDefaultScheduler;

    // create system cluster: it is at a fixed address so storing the result is unnecessary.

    new((void *)&uKernelModule::uSystemClusterStorage) uIOCluster( *uKernelModule::uSystemScheduler );
#ifndef __U_MULTI__
    uProcessor::uEvents = new uEventList;
    uProcessor::uContextSwitchHandler = new uCxtSwtchHndlr;
    uProcessor::uContextEvent = new uEventNode( *uProcessor::uContextSwitchHandler );
    uIOCluster::NBIO = new uNBIO;
#endif ! __U_MULTI__

    // create processor kernel: it is at a fixed address so storing the result is unnecessary.

    new((void *)&uKernelModule::uProcessorKernelStorage) uProcessorKernel;

    // start boot task, which executes the global constructors and destructors

    uKernelModule::uTaskBoot = new((void *)&uKernelModule::uTaskBootStorage) uBootTask();

    // SKULLDUGGERY: Set the processor's last resumer to the boot task so it
    // returns to it when the processor coroutine terminates. This has to be
    // done explicitly because the kernel coroutine is never uResumed only
    // context switched to. Therefore, uLast is never set by uResume, and
    // subsequently copied to uStart.

    uActiveProcessorKernel->uLast = uKernelModule::uTaskBoot;

    // SKULLDUGGERY: Force a context switch to the system processor to set the
    // boot task's context to the current UNIX context. Hence, the boot task
    // does not begin through uInvoke, like all other tasks. It also starts the
    // system processor's companion task so that it is ready to receive
    // processor specific requests. The trick here is that uBootTask is on the
    // ready queue when this call is made. Normally, a task is not on a ready
    // queue when it is running. As result, there has to be a special check in
    // uSchedule to not assert that this task is NOT on a ready queue when it
    // starts the context switch.

    uThisTask().uYield();

    // SKULLDUGGERY: Set the boot task's stack base to some value close to the
    // UNIX stack so that visualization stuff gets some reasonable stack size.
    // This is only an approximation.

    uKernelModule::uTaskBoot->uBase = uKernelModule::uTaskBoot->uSP;

    // create system task

    uKernelModule::uTaskSystem = new uSystemTask();

    // create user cluster

    uKernelModule::uUserCluster = new uCluster( "uUserCluster" );

    // create user processor

    uKernelModule::uUserProcessor = new uProcessor( *uKernelModule::uUserCluster );

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.startup2, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uThisProcessor().uGetPreemption() );
#endif __U_DEBUG_H__

    uKernelModule::uTaskBoot->uMigrate( *uKernelModule::uUserCluster );

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.startup3, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uThisProcessor().uGetPreemption() );
#endif __U_DEBUG_H__
} // uKernelBoot::startup


void uKernelBoot::finishup() {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.finishup1, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uThisProcessor().uGetPreemption() );
#endif __U_DEBUG_H__

    uKernelModule::uTaskBoot->uMigrate( *uKernelModule::uSystemCluster );

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.finishup2, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uThisProcessor().uGetPreemption() );
#endif __U_DEBUG_H__

    delete uKernelModule::uUserProcessor;
    delete uKernelModule::uUserCluster;

    delete uKernelModule::uTaskSystem;
    
    uKernelModule::uDisableInterrupts();
    uThisProcessor().uSetContextSwitchEvent( uDuration( 0, 0 ) ); // clear the alarm on this processor
    uKernelModule::uEnableInterrupts();

#ifndef __U_MULTI__
    delete uIOCluster::NBIO;
    delete uProcessor::uContextEvent;
    delete uProcessor::uContextSwitchHandler;
    delete uProcessor::uEvents;
#endif ! __U_MULTI__

    // SKULLDUGGERY: The termination order for the boot task is different from
    // the starting order. This results from the fact that the boot task must
    // have a processor before it can start. However, the system processor must
    // have the thread from the boot task to terminate. Deleting the cluster
    // first requires that the boot task be removed first from the list of
    // tasks on the cluster or the cluster complains about unfinished
    // tasks. The boot task must be added again before its deletion because it
    // removes itself from the list. Also, when the boot task is being deleted
    // it is using the *already* deleted system cluster, which works only
    // because the system cluster storage is not dynamically allocated so the
    // storage is not scrubbed; therefore, it still has the necessary state
    // values to allow the boot task to be deleted. As well, the ready queue
    // has to be allocated spearately from the system cluster so it can be
    // deleted *after* the boot task is deleted because the boot task access
    // the ready queue during its deletion.

    // remove the boot task so the cluster does not complain
    uKernelModule::uSystemCluster->uTaskRemove( *(uBaseTask *)uKernelModule::uTaskBoot );

    // remove system processor, processor task and cluster
    uKernelModule::uSystemCluster->uIOCluster::~uIOCluster();

    // remove processor kernal coroutine with execution still pending
    uActiveProcessorKernel->uProcessorKernel::~uProcessorKernel();

    // add the boot task back so it can remove itself from the list
    uKernelModule::uSystemCluster->uTaskAdd( *(uBaseTask *)uKernelModule::uTaskBoot );
    ((uBootTask *)uKernelModule::uTaskBoot)->uBootTask::~uBootTask();

    // no tasks on the ready queue so it can be deleted
    delete uKernelModule::uSystemScheduler;

#ifdef __U_DEBUG_H__
    uDebugPrt( "(uKernelBoot &)0x%p.finishup3, uDisableInt:%d, uDisableIntCnt:%d, uPreemption:%d\n",
	       this, uKernelModule::uDisableInt, uKernelModule::uDisableIntCnt, uThisProcessor().uGetPreemption() );
#endif __U_DEBUG_H__

    delete uKernelModule::uGlobalClusters;
    delete uKernelModule::uGlobalProcessors;

    delete uKernelModule::uGlobalClusterLock;
    delete uKernelModule::uGlobalProcessorLock;
    delete uKernelModule::uGlobalAbortLock;

    // Explicitly invoking the destructor does not close down the heap because
    // it might still be used before the application terminates. The heap's
    // destructor does check for unreleased storage at this point. (The
    // constructor for the heap is called on the first call to malloc.)

    uKernelModule::uHeapManager->uHeap::~uHeap();

#ifdef __U_MULTI__
    // TEMPORARY: This _exit stops the execution of the destructor list because
    // of the problem with the static variable "p" in crtbegin used to walk the
    // ctor/dtor chain. Because "p" is static and crtbegin appears before
    // uPrivate.o on the compilation command line, it is not in shared memory,
    // so when the destructor list is started on the user cluster, this
    // variable is not carried over to the system cluster during the
    // migrate. As a result, the system cluster processor has an old value of
    // "p", and the destructor list starts execution again unless execution is
    // explicitly stopped here. This is suppose to be the last dtor anyway, but
    // I wish I didn't have to do this hack. Getting the static variable out of
    // crtbegin would be better.

    extern int uRetCode;
    _exit( uRetCode );
#endif __U_MULTI__
} // uKernelBoot::finishup


// Local Variables: //
// compile-command: "dmake" //
// End: //
