//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1996
// 
// uBaseTask.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jan  8 16:14:20 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri May 21 17:30:45 1999
// Update Count     : 86
// 

#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>
#include <stdarg.h>					// prototype: va_list


//######################### uBaseTaskDL #########################


uBaseTaskDL::uBaseTaskDL( uBaseTask &w ) : uWho( w ) {}
uBaseTask &uBaseTaskDL::uGet() const { return uWho; }


//######################### uBaseTaskSL #########################


uBaseTaskSL::uBaseTaskSL( uBaseTask &w ) : uWho( w ) {}
uBaseTask &uBaseTaskSL::uGet() const { return uWho; }


//######################### uBaseTask #########################


uBaseTask &uThisTask() {
    return *uKernelModule::uActiveTask;
} // uThisTask


void uBaseTask::uCreateTask( uCluster &uClus ) {
    uRecursion = 0;
    uAcceptedCall = NULL;                               // no accepted mutex entry yet
    uCategory = uBaseScheduleFriend::uNonRealtime;
    uPriority = uActivePriority = 0;
    uInheritTask = this;
    uCurrCoroutine = this;				// the first coroutine that a task executes is itself
    uCurrCluster = &uClus;				// remember the cluster task is created on
#if __U_LOCALDEBUGGER_H__
    DebugPCandSRR = NULL;
    uProcessBP = false;					// used to prevent triggering breakpoint while processing one
#endif __U_LOCALDEBUGGER_H__
} // uBaseTask::uCreateTask


uBaseTask::uBaseTask( uCluster &uClus, uProcessor &uProc ) : uBaseCoroutine( uClus.uGetStackSize() ), uClusterRef( *this ), uReadyRef( *this ), uEntryRef( *this ), uMutexRef( *this ), uBound( uProc ) {
    uCreateTask( uClus );
} // uBaseTask::uBaseTask


void uBaseTask::uWake() {
    uSetState( uReady );				// task is marked available for execution
    uCurrCluster->uMakeTaskReady( *this );		// put the task on the ready queue of the cluster
} // uBaseTask::uWake


uBaseTask::uTaskState uBaseTask::uSetState( uBaseTask::uTaskState state ) {
    uTaskState prev = uState;
    uState = state;
    return prev;
} // uBaseTask::uSetState


uBaseScheduleFriend::uTaskCategory uBaseTask::uGetCategory() const {
    return uCategory;
} // uBaseTask::uGetCategory


uBaseTask &uBaseTask::uGetInheritTask() {
    return *uInheritTask;
} // uBaseTask::uGetInheritTask


int uBaseTask::uSetActivePriority( uBaseTask &t ) {
    int temp = uActivePriority;
    uInheritTask = &t;
    uActivePriority = uInheritTask->uGetActivePriority();
    return temp;
} // uBaseTask::uSetActivePriority


int uBaseTask::uSetBasePriority( int p ) {
    int temp = uPriority;
    uPriority = p;
    return temp;
} // uBaseTask::uSetBasePriority


uBaseTask::uBaseTask() : uClusterRef( *this ), uReadyRef( *this ), uEntryRef( *this ), uMutexRef( *this ), uBound( *(uProcessor *)0 ) {
    uCreateTask( uThisCluster() );
} // uBaseTask::uBaseTask


uBaseTask::uBaseTask( unsigned int stacksize ) : uBaseCoroutine ( stacksize ), uClusterRef( *this ), uReadyRef( *this ), uEntryRef( *this ), uMutexRef( *this ), uBound( *(uProcessor *)0 ) {
    uCreateTask( uThisCluster() );
} // uBaseTask::uBaseTask


uBaseTask::uBaseTask( uCluster &uClus ) : uBaseCoroutine( uClus.uGetStackSize() ), uClusterRef( *this ), uReadyRef( *this ), uEntryRef( *this ), uMutexRef( *this ), uBound( *(uProcessor *)0 ) {
    uCreateTask( uClus );
} // uBaseTask::uBaseTask


uBaseTask::uBaseTask( uCluster &uClus, unsigned int stacksize ) : uBaseCoroutine( stacksize ), uClusterRef( *this ), uReadyRef( *this ), uEntryRef( *this ), uMutexRef( *this ), uBound( *(uProcessor *)0 ) {
    uCreateTask( uClus );
} // uBaseTask::uBaseTask


uBaseTask::~uBaseTask() {
    if ( uProfileTaskSamplerInstance && uProfiler::uProfiler_DeregisterTask ) {	// task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_DeregisterTask)( uProfiler::uProfilerInstance, *this );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if
} // uBaseTask::~uBaseTask


uBaseTask::uTaskState uBaseTask::uGetState() const {
    return uState;
} // uBaseTask::uGetState


uCluster &uBaseTask::uGetCluster() const {
    return *uCurrCluster;
} // uBaseTask::uGetCluster


int uBaseTask::uGetActivePriority() const {
    // special case for base of active priority stack
    return ( (uBaseTask *)this == uInheritTask ) ? uPriority : uActivePriority;
} // uBaseTask::uGetActivePriority


int uBaseTask::uGetBasePriority() const {
    return uPriority;
} // uBaseTask::uGetBasePriority


uCluster &uBaseTask::uMigrate( uCluster &uClus ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseTask &)0x%p.uMigrate, from cluster:0x%p to cluster:0x%p\n", this, &uThisCluster(), &uClus );
#endif __U_DEBUG_H__

    uAssert( &uBound == (uProcessor *)0 );

#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( ": attempt to migrate task 0x%p (%.256s) to cluster 0x%p (%.256s).\n"
	       "A task can only migrate itself to another cluster.",
	       this, this->uGetName(), &uClus, uClus.uGetName() );
    } // if
#endif __U_DEBUG__

    // A simple optimization: migrating to the same cluster that the task is
    // currently executing on simply returns the value of the current cluster.
    // Therefore, migrate does not always produce a context switch.

  if ( &uClus == uCurrCluster ) return uClus;

#if __U_LOCALDEBUGGER_H__
    if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->checkPoint();
#endif __U_LOCALDEBUGGER_H__

    // Remove the task from the list of tasks that live on this cluster,
    // and add it to the list of tasks that live on the new cluster.

    uCluster &uPrev = *uCurrCluster;			// save for return
    uPrev.uTaskRemove( *this );				// remove from current cluster
    uClus.uTaskAdd( *this );				// add to new cluster
    uCurrCluster = &uClus;				// change task's notion of which cluster it is executing on

#if __U_LOCALDEBUGGER_H__
    if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->migrateULThread( uClus );
#endif __U_LOCALDEBUGGER_H__

    if ( uProfileActive && uProfiler::uProfiler_RegisterTaskMigrate ) {	// task registered for profiling ?              
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	// make sure the currently executing task doesn't profile call
	(*uProfiler::uProfiler_RegisterTaskMigrate)( uProfiler::uProfilerInstance, *this, uPrev, uClus );
	uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
    } // if

    // Force a context switch so the task is scheduled on the new cluster.

    uYield();

    return uPrev;					// return reference to previous cluster
} // uBaseTask::uMigrate


void uBaseTask::uYieldNoPoll() {
    uAssert( ! uKernelModule::uDisableIntSpin );
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( ": attempt to yield the execution of task 0x%p (%.256s).\n"
	       "A task can only yield itself.",
	       this, this->uGetName() );
    } // if
#endif __U_DEBUG__

    uActiveProcessorKernel->uSchedule( this );		// find someone else to execute; wake on kernel stack
} // uBaseTask::uYieldNoPoll


void uBaseTask::uYield() {
    uYieldNoPoll();
    uPollAE();
} // uBaseTask::uYield


void uBaseTask::uYield( unsigned int times ) {
    for ( ; times > 0 ; times -= 1 ) {
	uYield();
    } // for
} // uBaseTask::uYield


void uBaseTask::uYieldYield( unsigned int times ) {	// inserted by translator for -yield
    // Calls to uYieldYield can be inserted in any inlined routine, which can
    // than be called from a uWhen clause, resulting in an attempt to context
    // switch while holding a spin lock.

    if ( ! uKernelModule::uDisableIntSpin ) {
	uYield( times );
    } // if
} // uBaseTask::uYieldYield


void uBaseTask::uSleep( uTime time ) {
#ifdef __U_DEBUG__
    if ( this != &uThisTask() ) {
	uAbort( ": attempt to put task 0x%p (%.256s) to sleep.",
	       this, this->uGetName() );
    } // if
#endif __U_DEBUG__

  if ( time <= uActiveProcessorKernel->uKernelClock.uGetTime() ) return;

    uWakeupHndlr handler( *this );			// handler to wake up blocking task
    uEventNode uRTEvent( *this, handler, time );	// event node for event list
    uThisProcessor().uEvents->uAddEvent( uRTEvent );

    uActiveProcessorKernel->uSchedule();
} // uBaseTask::uSleep


void uBaseTask::uSleep( uDuration duration ) {
    uSleep( uActiveProcessorKernel->uKernelClock.uGetTime() + duration );
} // uBaseTask::uSleep


void uBaseTask::uProfileActivate() {
    if ( ! uProfileTaskSamplerInstance ) {
	if ( uProfiler::uProfiler_RegisterTask ) {	// profiling this task & task registered for profiling ? 
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue += 1;
	    // make sure the currently executing task doesn't profile call
	    (*uProfiler::uProfiler_RegisterTask)( uProfiler::uProfilerInstance, *this );
	    uKernelModule::uActiveTask->uProfileTaskSamplerInstance->inside_uFunctionPrologue -= 1;
	    uProfileActive = true;
	} // if
    } else {
	uProfileActive = true;
    } // if 
} // uBaseTask::uProfileActivate

void uBaseTask::uProfileInactivate() {
    uProfileActive = false;
} // uBaseTask::uProfileInactivate

void uBaseTask::uPrintCallStack( const char * const format, ... ) const {
    if ( uProfileTaskSamplerInstance ) {
	va_list args;
	va_start( args, format );
	(*uProfileTaskSampler::uProfileTaskSampler_printCallStack)( uProfileTaskSamplerInstance, format, args );
	va_end( args );
    } // if
} // uBaseTask::uPrintCallStack

void uBaseTask::uPrintCallStack( char * const buf, unsigned int const bufsize, const char * const format, ... ) const {
    if ( uProfileTaskSamplerInstance ) {
	va_list args;
	va_start( args, format );
	(*uProfileTaskSampler::uProfileTaskSampler_printCallStackToBuffer)( uProfileTaskSamplerInstance, buf, bufsize, format, args );
	va_end( args );
    } // if
} // uBaseTask::uPrintCallStack


// Local Variables: //
// compile-command: "dmake" //
// End: //
