//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1997
// 
// uBaseCoroutine.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 27 16:46:37 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri May 21 17:30:43 1999
// Update Count     : 82
// 

#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
//#include <uDebug.h>

#include <string.h>					// strncpy


//######################### uBaseCoroutine #########################


uBaseCoroutine &uThisCoroutine() {
    return *uThisTask().uCurrCoroutine;
} // uThisCoroutine


void uBaseCoroutine::uCreateCoroutine() {
#ifdef __U_DEBUG__
    uLast = (uBaseCoroutine *)0;			// for error checking
#endif __U_DEBUG__
    uNotHalted = true;					// must be a non-zero value so detectable after memory is scrubbed

    // abnormal event handling

    uSyncHandlers = uAsyncHandlers = (uAEHM::uResumptionHandlers *)0;
    uDAEStack = (uAEHM::uDeliverAEStack *)0;
    uThrowEventCnt = 0;
} // uBaseCoroutine::uCreateCoroutine


uBaseCoroutine::uBaseCoroutine( double ) : uMachContext( 1.0 ) {
    uCreateCoroutine();
} // uBaseCoroutine::uBaseCoroutine


uBaseCoroutine::uBaseCoroutine() : uMachContext( uThisCluster().uGetStackSize() ) {
    uCreateCoroutine();
} // uBaseCoroutine::uBaseCoroutine


uBaseCoroutine::uBaseCoroutine( unsigned int stacksize ) : uMachContext( stacksize ) {
    uCreateCoroutine();
} // uBaseCoroutine::uBaseCoroutine


uBaseCoroutine::~uBaseCoroutine() {
} // uBaseCoroutine::~uBaseCoroutine


uBaseCoroutine::uCoroutineState uBaseCoroutine::uGetState() const {
    return uNotHalted ? uState : uHalt;
} // uBaseCoroutine::uGetState


uBaseCoroutine::uCoroutineState uBaseCoroutine::uSetState( uCoroutineState state ) {
    uCoroutineState prev = uState;
    uState = state;
    return prev;
} // uBaseCoroutine::uSetState


void uBaseCoroutine::uContextSw() {			// switch between a task and the kernel
    uBaseCoroutine *uCurr = &uThisCoroutine();
    uCurr->uSetState( uInActive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.uContextSw, uCurr:0x%p, uSP:0x%p\n",
	       this, uCurr, uCurr->uSP );
#endif __U_DEBUG_H__
    uCurr->uSave();
    uSwitch( this, uCurr );
    uCurr = &uThisCoroutine();
    uCurr->uRestore();
    uCurr->uSetState( uActive );			// set state of next coroutine to active
} // uBaseCoroutine::uContextSw


void uBaseCoroutine::uContextSw2() {			// switch between two coroutine contexts
    uKernelModule::uDisableInterrupts();

    uBaseCoroutine *uCurr = &uThisCoroutine();
    uCurr->uSetState( uInActive );			// set state of current coroutine to inactive
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uBaseCoroutine &)0x%p.uContextSw2, uCurr:0x%p, uSP:0x%p\n",
	       this, uCurr, uCurr->uSP );
#endif __U_DEBUG_H__
    uCurr->uSave();
    uThisTask().uCurrCoroutine = this;			// set new coroutine that task is executing

#ifdef __U_MULTI__
    // It is necessary to touch the stack base before a context switch
    // from the uC++ kernel to a task. The problem occurs when one
    // processor tries to execute a task that is not mapped into its
    // address space. Normally, loading the invalid stack pointer
    // causes a sigsegv, and the sigsegv handler fixes up the address
    // space. However, if the invalid stack pointer is loaded and a
    // sigalrm is delivered before the sigsegv, the sigalrm cannot be
    // delivered on the stack because it is invalid. The problem is
    // that control is now in the UNIX kernel, which is trying to
    // deliver the sigalrm, when the invalid stack pointer is detected;
    // UNIX does not invoke the sigsegv handler in the user program.
    // This is the same problem that occurs when an invalid address is
    // given to an I/O routine.  The I/O routine accesses the pointer
    // in the kernel, and the kernel does not invoke the user's sigsegv
    // handler.  The fundamental problem is that UNIX should
    // recursively invoke the user's sigsegv for invalid address and it
    // does not.

    int dummy;
#ifdef __U_STACK_GROWS_UP__
    dummy = *(unsigned int *)(this->uLimit);
#else
    dummy = *(unsigned int *)(this->uBase);
#endif __U_STACK_GROWS_UP__
#endif __U_MULTI__

    uSwitch( this, uCurr );
    uCurr = &uThisCoroutine();
    uCurr->uRestore();
    uCurr->uSetState( uActive );			// set state of next coroutine to active

    uKernelModule::uEnableInterrupts();
} // uBaseCoroutine::uContextSw2


void uBaseCoroutine::uCoStarter() {			// remembers who started a coroutine
    uStart = uLast;
} // uBaseCoroutine::uCoStarter


void uBaseCoroutine::uCoFinish() {			// resumes the coroutine that first resumed this coroutine
    uNotHalted = false;
    uStart->uContextSw2();
    // CONTROL SHOULD NOT RETURN HERE!
    // Error message printed in uMachContext::uInvokeCoroutine if it does.
} // uBaseCoroutine::uCoFinish


const char *uBaseCoroutine::uGetName() const {
#ifdef __U_DEBUG__
    if ( uName == NULL ) return "*unknown*";		// storage might be scrubbed
#endif __U_DEBUG__
    return uName;
} // uBaseCoroutine::uGetName


void uBaseCoroutine::uCoResume() {			// restarts the coroutine's main where last suspended
    if ( &uThisCoroutine() != this ) {			// ignore resume to oneself
#ifdef __U_DEBUG__
        if ( ! uNotHalted ) {				// check if terminated
	    uThrow uTerminated( *this, "context switching to terminated coroutine" );
	} // if
#endif __U_DEBUG__
	uLast = &uThisCoroutine();
	uContextSw2();
    } // if
    uEnable <uBaseCoroutine::uFailure> {
	uPollAE();
    } // uEnable
} // uBaseCoroutine::uCoResume


void uBaseCoroutine::uCoSuspend() {			// restarts the coroutine that most recently resumed this coroutine
#ifdef __U_DEBUG__
    if ( uLast == (uBaseCoroutine *)0 ) {
	uAbort( ": attempt to suspend coroutine 0x%p (%.256s), which has never been resumed.\n"
	       "Possible cause is a uSuspend statement executed in a member called by a coroutine user rather than by the coroutine main.",
	       this, this->uGetName() );
    } // if
    if ( ! uLast->uNotHalted ) {			// check if terminated
	uThrow uTerminated( *uLast, "context switching to terminated coroutine" );
    } // if
#endif __U_DEBUG__
    uLast->uContextSw2();
    uEnable <uBaseCoroutine::uFailure> {
	uPollAE();
    } // uEnable
} // uBaseCoroutine::uCoSuspend


uBaseCoroutine &uBaseCoroutine::uLastResume() const {
    return *uLast;
} // uBaseCoroutine::uLastResume


bool uBaseCoroutine::uUncaughtException() {
    return uThrowEventCnt != 0;
} // uBaseCoroutine::uUncaughtException


void uBaseCoroutine::uFailure::uCreateFailure() {
    // coroutine name is copied because its storage can be freed and scrubbed before handler starts
    strncpy( uName, cor.uGetName(), uAEHMMaxName );
    if ( strlen( cor.uGetName() ) > uAEHMMaxName ) {	// name too long ?
	strcpy( &uName[uAEHMMaxName], "..." );		// add 4 character ...
    } // if
} // uBaseCoroutine::uFailure::uFailure

uBaseCoroutine::uFailure::uFailure( const uBaseCoroutine &cor, const char *const msg ) : uKernelFailure( msg ), cor( cor ) {
    uCreateFailure();
} // uBaseCoroutine::uFailure::uFailure

uBaseCoroutine::uFailure::uFailure( const char *const msg ) : uKernelFailure( msg ), cor( uThisCoroutine() ) {
    uCreateFailure();
} // uBaseCoroutine::uFailure::uFailure

uBaseCoroutine::uFailure::~uFailure() {
} // uBaseCoroutine::uFailure::~uFailure

const uBaseCoroutine &uBaseCoroutine::uFailure::uDst() const { return cor; }

const char *uBaseCoroutine::uFailure::uGetName() const { return uName; }

void uBaseCoroutine::uFailure::uDefaultTerminate() const {
    uAbort( "Unhandled event uBaseCoroutine::uFailure : %s coroutine 0x%p (%.256s) from coroutine 0x%p (%.256s).",
	   uMsg(), &uThisCoroutine(), uThisCoroutine().uGetName(), &uSrc(), uSrcName() );
} // uBaseCoroutine::uFailure::uDefaultTerminate


uBaseCoroutine::uTerminated::uTerminated( const uBaseCoroutine &cor, const char *const msg ) : uBaseCoroutine::uFailure( cor, msg ) {}

uBaseCoroutine::uTerminated::uTerminated( const char *const msg ) : uBaseCoroutine::uFailure( msg ) {}

uBaseCoroutine::uTerminated::~uTerminated() {}

void uBaseCoroutine::uTerminated::uDefaultTerminate() const {
    uAbort( "Unhandled event uBaseCoroutine::uTerminated : coroutine 0x%p (%.256s) %s 0x%p (%.256s).",
	    &uSrc(), uSrcName(), uMsg(), &uDst(), uGetName() );
} // uBaseCoroutine::uTerminated::uDefaultTerminate


uInitEvent(uBaseCoroutine::uFailure);
uInitEvent(uBaseCoroutine::uTerminated);


// Local Variables: //
// compile-command: "dmake" //
// End: //
