//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
// 
// uAlign.h -- 
// 
// Author           : Peter Buhr
// Created On       : Sat Dec 18 22:08:40 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May  2 10:56:01 1998
// Update Count     : 13
// 


#ifndef __U_ALIGN_H__
#define __U_ALIGN_H__


// Word size used to align the stack pointers and memory allocations on aligned
// boundaries.

#define uAlign() sizeof( double )


// Returns value aligned at the floor of align.

static inline unsigned long int uFloor( unsigned long int value, unsigned long int align ) {
    return value - ( value % align );
} // uFloor


// Returns value aligned at the ceiling of align.

static inline unsigned long int uCeiling( unsigned long int value, unsigned long int align ) {
    value += align - 1;
    return uFloor( value, align );
} // uCeiling


#endif __U_ALIGN_H__


// Local Variables: //
// compile-command: "dmake" //
// End: //
