//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Philipp E. Lim and Ashif S. Harji 1995, 1997
// 
// uAlarm.h -- 
// 
// Author           : Philipp E. Lim
// Created On       : Thu Dec 21 14:01:24 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jul 31 11:39:35 1998
// Update Count     : 140
// 


#ifndef __U_ALARM_H__
#define __U_ALARM_H__


class uSignalHandler;					// forward declaration


//######################### uEventNode #########################


class uEventNode : public uSeqable {
    friend class uEventList;				// access: everything
    friend class uEventListPop;				// access: everything
    friend uCoroutine uProcessorKernel;			// access: timerT, private constructor
    friend class uBaseTask;				// access: everything
    friend class uSerial;				// access: everything
    friend class uNBIO;					// access: everything
    friend class uKernelBoot;                           // access: new
    friend class uProcessor;                            // access: new

    uTime timerT;					// time when alarm goes off (in internal clock time)
    uDuration timerD;					// if periodic, timerD contains period of alarm (after timerT)
    uSignalHandler *SigHandler;				// signal handler function when timer goes up
    uBaseTask *uWho;					// task that created the event
    bool uExecuteLocked;				// indicates if handler is executed with uEventlock acquired

    uEventNode();
    uEventNode( uBaseTask &t, uSignalHandler &sig, uTime tT, uDuration tD = 0 );
    uEventNode( uSignalHandler &sig );
}; // uEventNode


//######################### uEventList #########################


class uEventList {
    friend uCoroutine uProcessorKernel;			// access: new
    friend class uSerial;				// access: uAddEvent, uRemoveEvent
    friend class uNBIO;					// access: uAddEvent, uRemoveEvent, uNextAlarm
    friend class uBaseTask;				// access: uAddEvent
    friend class uCluster;				// access: uNextAlarm
    friend int uGethostname( const char *const name, int len );	// access: uPauseEvents, uRestartEvents
    friend int uGethostbyname( const char *const name, struct hostent *h ); // access: uPauseEvents, uRestartEvents
    friend class uKernelBoot;				// access: new
    friend class uProcessor;				// access: new
    friend class uEventListPop;				// access: uL

    uSequence<uEventNode> uL;
    uSpinLock uEventLock;				// protect EventQueue

    void *operator new( size_t, void *storage ) { return storage; }
    void *operator new( size_t size ) { return ::operator new( size ); }
    void uAddEvent( uEventNode &newAlarm, uProcessor &processor = uThisProcessor() );
    void uRemoveEvent( uEventNode &oldNode, uProcessor &processor = uThisProcessor() );
    void uPauseEvents();
    void uRestartEvents();
    uEventNode *uNextEvent();
    uTime uNextAlarm();
    bool uUserEventPresent();
    void uAcquireEventLock();
    void uReleaseEventLock();
  public:
}; // uEventList


class uEventListPop {
    uEventList *uEL;
    uTime curTime;
    uSignalHandler *uCxtSwHandler;                      // ContextSwitch encountered?
    bool uInKernel;
  public:
    uEventListPop();
    uEventListPop( uEventList &e, bool inKernel );
    ~uEventListPop();
    void uOver( uEventList &e, bool inKernel );
    bool operator>>( uEventNode *&node );
}; // uEventListPop


#endif __U_ALARM_H__


// Local Variables:
// compile-command: "dmake"
// End:
