//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uAbort.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Fri Oct 26 11:54:31 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jan 23 08:06:46 1999
// Update Count     : 399
// 


#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>


#include <stdio.h>
#include <unistd.h>					// prototype for _exit
#include <stdarg.h>
#include <errno.h>
#include <signal.h>					// prototype for kill


#if defined( __gizmo__ )
extern "C" int fprintf(FILE *, const char *, ...);
extern "C" int vfprintf(FILE *, const char *, va_list);
#endif


void uAbortExit() {
#ifdef __U_MULTI__					// all processors point to the same UNIX process on uniprocessor
    // Deal with any starting processors spinning to get onto the global
    // processor list.

    uKernelModule::uGlobalSpinAbort = true;

    // Destory any remaining processors.

    uProcessorDL *pr;
    for ( uSeqGen<uProcessorDL> gen(*uKernelModule::uGlobalProcessors); gen >> pr; ) {
	if ( &(pr->uGet()) != &uThisProcessor() ) {
#ifdef __U_DEBUG_H__
	    fprintf( stderr, "uAbortExit(), killing process %d\n", pr->uGet().uGetPid() );
#endif __U_DEBUG_H__
	    kill( pr->uGet().uGetPid(), SIGKILL );
	} // if
    } // for
#endif __U_MULTI__
} // uAbortExit


void uExit( int retcode ) {
    uKernelModule::uGlobalAbort = true;
  if ( ! uKernelModule::uGlobalAbortLock->uTryAcquire() ) _exit( -1 ); // close down in progress, shutdown immediately!
    // Try to shut down other processors.

    if ( uKernelModule::uGlobalProcessorLock->uTryAcquire() ) {
	uAbortExit();
    } // if
    
    // _exit is called instead of exit so the global destructors are not
    // called.  Trying to execute the global destructors after the processors
    // have been killed just generates incomprehensible errors.

    _exit( retcode );
    // CONTROL NEVER REACHES HERE!
} // uExit


// Only one processor should call abort and succeed.  Once a processor calls
// abort, all other processors quietly exit while the aborting processor cleans
// up the system and possibly dumps core.

void uAbort( const char *fmt, ... ) {
    va_list args;

    // uAbort can be recursively entered by the same processor, e.g., a problem
    // on this processor and then an asynchronous sigchld from a failing child
    // processor or an external sigterm.

    uKernelModule::uGlobalAbort = true;
    if ( ! uKernelModule::uGlobalAbortLock->uTryAcquire() ) { // not the first task to abort ?
	if ( uKernelModule::uDisableInt ) return;	// in the kernel ? go back to the kernel
	uActiveProcessorKernel->uSchedule();		// block the task to prevent further damage during abort
	// CONTROL SHOULD NOT RETURN HERE!
    } // if

    // profiling

    uThisTask().uProfileInactivate();			// make sure the profiler is not called from this point on

    // Display the relevant shut down information.

    va_start( args, fmt );
    fprintf( stderr, "uC++ Runtime error (UNIX pid:%ld) ", getpid() );
    vfprintf( stderr, fmt, args );
    va_end( args );

    const char *taskName, *coroutineName;
    if ( &uThisTask() != NULL ) {
	taskName = uThisTask().uGetName();
	if ( &uThisCoroutine() != NULL ) {
	    coroutineName = uThisCoroutine().uGetName();
	} else {
	    coroutineName = "*unknown*";
	} // if
    } else {
	taskName = "*unknown*";
	coroutineName = "*unknown*";
    } // if
    fprintf( stderr, "\nError occurred while executing task 0x%p (%.256s)", &uThisTask(), taskName );
    if ( &uThisTask() != &uThisCoroutine() ) {
	fprintf( stderr, " in coroutine 0x%p (%.256s).\n", &uThisCoroutine(), coroutineName );
    } else {
	fprintf( stderr, ".\n" );
    } // if

    // In profiling mode, output information about the current task's call stack.

    uThisTask().uPrintCallStack( "" );

    // In debugger mode, tell the global debugger to stop the application.

#if __U_LOCALDEBUGGER_H__
    if ( ! uKernelModule::uDisableInt && ! uKernelModule::uDisableIntSpin ) {
	if  ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->abortApplication();
    } // if
#endif __U_LOCALDEBUGGER_H__

    // Try to shut down other processors.

    if ( uKernelModule::uGlobalProcessorLock->uTryAcquire() ) {
	uAbortExit();
    } // if

    // After having killed off the other processors, dump core if required,
    // otherwise, quietly call "_exit". Cannot call "exit" because of global
    // destructors.

    if ( ! uKernelModule::uCoreDumped ) {		// child process may have failed and dumped core already
	uKernelModule::uCoreDumped = true;		// prevent other UNIX processes from dumping core
	abort();
    } else {
        _exit( -1 );
    } // if

    // CONTROL NEVER REACHES HERE!
} // uAbort


// Local Variables: //
// compile-command: "dmake" //
// End: //
