//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Russell Mok 1997
// 
// uAEHM.h -- 
// 
// Author           : Russell Mok
// Created On       : Mon Jun 30 16:46:18 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri May 21 18:00:12 1999
// Update Count     : 86
// 


#ifndef __U_AEHM_H__
#define __U_AEHM_H__


#define uInitEvent( ae_class ) void *ae_class::uId = NULL;
#define uPollAE uAEHM::uDeliverEvents
#define uRendezvousAcceptor uSerialMemberInstance.uAcceptor
#define uAEHMMaxName 50


//######################### uAEHM ########################


class uAEHM {
    class uRaiseWorkHorseInit;
    class uGarbageCollectAE;
    class uAsyncAEMsg;
  public:
    class uAsyncAEMsgBuffer;
    struct uHandlerClause;
    class uResumptionHandlers;
    class uDeliverAEStack;
    class uProtectLock;					// a class to acquire and release a lock
    class uProtectInterrupts;
    class uDualClass;
    class uThrowClass;
    class uRaiseClass;
    enum uFlagT { uThrowF, uDualThrowF, uDualRaiseF, uRaiseF };
    class uClosure;					// the root reference of all closure class

    static void uAEThrow(const uDualClass &, uBaseCoroutine &);
    static void uAEThrow(const uThrowClass &, uBaseCoroutine &);
    static void uAEThrow(const uDualClass &);
    static void uAEThrow(const uThrowClass & );
    static void uAERaise(const uDualClass & , uBaseCoroutine & );
    static void uAERaise(const uRaiseClass &, uBaseCoroutine &);
    static void uAERaise(const uDualClass &);
    static void uAERaise(const uRaiseClass & );
    static void uDeliverEvents();
    static void uTerminate();
    static uLock *uThrowLock;
  private:
    typedef void (* uDualClosureHandler)(uDualClass &, uClosure &);
    typedef void (* uDualHandler)(uDualClass &);
    typedef void (* uRaiseClosureHandler)(uRaiseClass &, uClosure &);
    typedef void (* uRaiseHandler)(uRaiseClass &);
    friend class uBaseCoroutine;
    static void uAERaiseWorkHorse(const uDualClass &, const bool);
    static bool uMatch_abnormal_event(void *, void * const);
    static bool deliverable_event(void *);
}; // uAEHM


//######################### uAEHM::uAsyncAEMsg ########################


class uAEHM::uAsyncAEMsg : public uSeqable {
    friend void uAEThrow( const uDualClass &, uBaseCoroutine & );
    friend void uAEThrow( const uThrowClass &, uBaseCoroutine & );
    friend void uAERaise( const uDualClass &, uBaseCoroutine & );
    friend void uAERaise( const uRaiseClass &, uBaseCoroutine & );
    friend void uDeliverEvents();
    friend class uAsyncAEMsgBuffer;

    const uFlagT flag;
    uDualClass *ae;

    uAsyncAEMsg &operator=( const uAsyncAEMsg & );
    uAsyncAEMsg( const uAsyncAEMsg & );

    uAsyncAEMsg( const uDualClass &, const uFlagT );
    uAsyncAEMsg( const uThrowClass & );
    uAsyncAEMsg( const uRaiseClass & );
  public:
    ~uAsyncAEMsg();
}; // uAEHM::uAsyncAEMsg


//######################### uAEHM::uProtectLock ########################


class uAEHM::uProtectLock {
    uSpinLock &lock;
    uProtectLock( const uProtectLock & );
    uProtectLock &operator=( const uProtectLock & );
  public:
    uProtectLock( uSpinLock & );
    ~uProtectLock();
}; // uAEHM::uProtectLock


//######################### uAEHM::uAsyncAEMsgBuffer ########################


//  uAsyncAEMsgBuffer looks like public uQueue<uAsyncAEMsg> but with mutex

class uAEHM::uAsyncAEMsgBuffer : public uSequence<uAEHM::uAsyncAEMsg> {
    friend void uAEHM::uDeliverEvents();		// access lock
    friend class uTaskMain;
    friend class uCoroutineMain;

    uAsyncAEMsgBuffer( const uAsyncAEMsgBuffer & );
    uAsyncAEMsgBuffer& operator=( const uAsyncAEMsgBuffer & );
  public:
    uSpinLock lock;
    uAsyncAEMsgBuffer();
    ~uAsyncAEMsgBuffer();
    void uAddMsg( uAsyncAEMsg * );
    uAsyncAEMsg *uRmMsg();
    uAsyncAEMsg *uMsgHead();
    bool uMsgEmpty();
}; // uAEHM::uAsyncAEMsgBuffer


//######################### uAEHM::uDualClass ########################


class uAEHM::uDualClass {
    friend void uAEThrow( const uDualClass &, uBaseCoroutine & );
    friend void uAEThrow( const uDualClass & );
    friend void uAERaise( const uDualClass &, uBaseCoroutine & );
    friend void uAERaise( const uDualClass & );
    friend void uAERaiseWorkHorse( const uDualClass &, const bool );
    friend void uDeliverEvents();
    friend class uAsyncAEMsg;

    const char *const msg;
    const uBaseCoroutine &src;
    char uName[uAEHMMaxName + sizeof("...")];		// room for "...\0"
  protected:
    // These routines are generated by the translator so they are object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual uDualClass *uDuplicate() const = 0;
    virtual void uStackThrow() const = 0;
  public:
    static void *uId;

    uDualClass( const char *const msg = "" );
    virtual ~uDualClass();

    const char *const uMsg() const;
    const uBaseCoroutine &uSrc() const;
    const char *uSrcName() const;

    virtual void uDefaultResume() const;
    virtual void uDefaultTerminate() const;
}; // uAEHM::uDualClass


//######################### uAEHM::uThrowClass ########################


// uThrowClass is the root class of all throwable abnormal events

class uAEHM::uThrowClass : private uAEHM::uDualClass {
    friend class uAsyncAEMsg;				// enable conversion to uDualClass;
    friend void uAEThrow( const uThrowClass &, uBaseCoroutine & );
    friend void uAEThrow( const uThrowClass & );

    // The following definition is conditional because of the private
    // inheritance only a few routines and classes know the private inheritance
    // in the kernel and they must deal with the casting cautiously.
#ifdef __DEBUG__
    virtual void uDefaultResume() const;
#endif __DEBUG__
  protected:
    // These routines are generated by the translator so they are object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual uThrowClass *uDuplicate() const = 0;
    virtual void uStackThrow() const = 0;
  public:
    static void *uId;

    uThrowClass( const char *const msg = "" );
    virtual ~uThrowClass();

    const char *const uMsg() const;
    const uBaseCoroutine &uSrc() const;

    virtual void uDefaultResume() const;
    virtual void uDefaultTerminate() const;
}; // uAEHM::uThrowClass


//######################### uAEHM::uRaiseClass ########################


class uAEHM::uRaiseClass : private uAEHM::uDualClass {
    friend void uAERaise( const uRaiseClass &, uBaseCoroutine & );
    friend void uAERaise( const uRaiseClass & );
    friend class uAsyncAEMsg;

#ifdef __DEBUG__
    virtual void uDefaultTerminate const();
#endif __DEBUG__
  protected:
    // These routines are generated by the translator so they are object
    // specific.
    virtual void *uEvent_id() const = 0;
    virtual uRaiseClass *uDuplicate() const = 0;

    virtual void uStackThrow() const;
  public:
    static void *uId;

    uRaiseClass( const char *const msg = "" );
    virtual ~uRaiseClass();

    const char *const uMsg() const;
    const uBaseCoroutine &uSrc() const;

    // must override the one in uDualClass because uRaiseClass cannot be
    // thrown!!
    virtual void uDefaultTerminate() const;
    virtual void uDefaultResume() const;
}; // uAEHM::uRaiseClass


//######################### uAEHM::uClosure ########################


class uAEHM::uClosure {
  private:
    uClosure( const uClosure & );
    uClosure & operator=( const uClosure & );
  public:
    uClosure();
    ~uClosure();
}; // uAEHM::uClosure


//######################### internal class and function declarations ########################


// Tuple of <event_id, resuming handler, local object> in the template try
// block.

struct uAEHM::uHandlerClause {
    void *const event_id;
    void *const handler;
    const uClosure *const cls_ptr;
}; // uHandlerClause


// Every set of resuming handlers bound to a template try block is saved in a
// uAEHM::uResumptionHandlers object The resuming handler hierarchy is
// implemented as a linked list

class uAEHM::uResumptionHandlers {
    friend void uAERaiseWorkHorse( const uDualClass &, const bool );

    uResumptionHandlers *uSyncNext, *uAsyncNext;	// the propagation mechanism requires two handler hierarchies
    const unsigned int size;				// number of handlers
    uHandlerClause *uHandlerTable;			// pointer to array of resumption handlers

    uResumptionHandlers( const uResumptionHandlers & );	// no copy
    uResumptionHandlers &operator=( const uResumptionHandlers & ); // no assignment
  public:
    uResumptionHandlers( uHandlerClause *const , const unsigned int );
    ~uResumptionHandlers();
}; // uAEHM::uResumptionHandlers


// The following actually implements a linked list of event_id's table.  Used
// in uEnable and uDisable block

class uAEHM::uDeliverAEStack {
    friend bool deliverable_event( void * );

    uDeliverAEStack *next;
    bool uDeliverFlag;                                  // true when events in table is Enable, otherwise false
    int  table_size;                                    // number of events in the table, 0 implies everything
    void **event_table;                                 // event id table

    uDeliverAEStack( uDeliverAEStack & );		// no copy
    uDeliverAEStack &operator=( uDeliverAEStack & );	// no assignment
  public:
    uDeliverAEStack( bool f, void **t = NULL, unsigned int s = 0 ); // for enable and disable blocks
    ~uDeliverAEStack();
}; // uAEHM::uDeliverAEStack


#endif __U_AEHM_H__


// Local Variables:
// compile-command: "dmake"
// End:
