//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Russell Mok 1997
// 
// uAEHM.cc -- 
// 
// Author           : Russell Mok
// Created On       : Sun Jun 29 00:15:09 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Feb 25 09:55:37 1999
// Update Count     : 180
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <string.h>					// prototype: strlen, strncpy, strcpy


#if defined( __svr4__ ) && defined( __sun__ )
#if ( __GNUG__ == 2 && __GNUC_MINOR__ >= 8 )		// gcc releases >= 2.8
// TEMPORARY: Solaris 2.5 linking problem for multiprocessor with exception
// code in _eh.c. Does not exist in Solaris 2.6
extern "C" int pthread_mutex_trylock();
static void uDummyRtn() {
    pthread_mutex_trylock();
}
#endif
#endif


uLock	*uAEHM::uThrowLock = (uLock *)0;


//######################### uAEHM::uAsyncAEMsg ########################


uAEHM::uAsyncAEMsg::uAsyncAEMsg( const uDualClass &ae_obj, const uFlagT f ) : flag( f ) {
    ae = ae_obj.uDuplicate();
} // uAEHM::uAsyncAEMsg::uAsyncAEMsg

uAEHM::uAsyncAEMsg::uAsyncAEMsg( const uThrowClass &ae_obj ) : flag( uThrowF ) {
    uThrowClass *tmp = ae_obj.uDuplicate();
    ae = tmp;
} // uAEHM::uAsyncAEMsg::uAsyncAEMsg

uAEHM::uAsyncAEMsg::uAsyncAEMsg( const uRaiseClass &ae_obj ) : flag( uRaiseF ) {
    uRaiseClass *tmp = ae_obj.uDuplicate();
    ae = tmp;
} // uAEHM::uAsyncAEMsg::uAsyncAEMsg

uAEHM::uAsyncAEMsg::~uAsyncAEMsg() {
    delete ae;
} // uAEHM::uAsyncAEMsg::~uAsyncAEMsg


//######################### uAEHM::uAsyncAEMsgBuffer ########################


// msg queue for asynchronous abnormal events in a coroutine

uAEHM::uAsyncAEMsgBuffer::uAsyncAEMsgBuffer() {}

uAEHM::uAsyncAEMsgBuffer::~uAsyncAEMsgBuffer() {
    uProtectLock dummy( lock );
    for ( uAsyncAEMsg *tmp = uDrop(); tmp; tmp = uDrop() ) {
	delete tmp;
    } // for
} // uAEHM::uAsyncAEMsgBuffer::~uAsyncAEMsgBuffer

void uAEHM::uAsyncAEMsgBuffer::uAddMsg( uAsyncAEMsg *msg ) {
    uProtectLock dummy( lock );
    uAdd( msg );
} // uAEHM::uAsyncAEMsgBuffer::uAddMsg

uAEHM::uAsyncAEMsg *uAEHM::uAsyncAEMsgBuffer::uRmMsg() {
    uProtectLock dummy( lock );
    return uDrop();
} // uAEHM::uAsyncAEMsgBuffer::uRmMsg


//######################### uAEHM::uProtectLock ########################


uAEHM::uProtectLock::uProtectLock( uSpinLock &lock ) : lock( lock ) {
    lock.uAcquire();
} // uAEHM::uProtectLock::uProtectLock

uAEHM::uProtectLock::~uProtectLock() {
    lock.uRelease();
} // uAEHM::uProtectLock::~uProtectLock


//######################### uDualClass ########################


uAEHM::uDualClass::uDualClass( const char *const msg ) : msg( msg ), src( uThisCoroutine() ) {
    const char *name = src.uGetName();
    int lnth = strlen( name );
    strncpy( uName, name, uAEHMMaxName );
    if ( lnth > uAEHMMaxName ) {			// name too long ?
	strcpy( &uName[uAEHMMaxName], "..." );		// add 4 character ...
    } // if
}; // uAEHM::uDualClass::uDualClass

uAEHM::uDualClass::~uDualClass() {}

const char *const uAEHM::uDualClass::uMsg() const {
    return msg;
} // uAEHM::uDualClass::uMsg

const uBaseCoroutine &uAEHM::uDualClass::uSrc() const {
    return src;
} // uAEHM::uDualClass::uSrc

const char *uAEHM::uDualClass::uSrcName() const { return uName; }

void uAEHM::uDualClass::uDefaultResume() const {
    uStackThrow();
    // CONTROL NEVER REACHES HERE!
} // uAEHM::uDualClass::uDefaultResume

void uAEHM::uDualClass::uDefaultTerminate() const {
} // uAEHM::uDualClass::uDefaultTerminate


uInitEvent(uAEHM::uDualClass);


//######################### uAEHM::uThrowClass ########################


uAEHM::uThrowClass::uThrowClass( const char *const msg ) : uDualClass( msg ) {}

uAEHM::uThrowClass::~uThrowClass() {}

void uAEHM::uThrowClass::uDefaultResume() const {
    uAbort( "uThrowClass object has been casted to a raise-able object" );
} // uAEHM::uThrowClass::uDefaultResume

void uAEHM::uThrowClass::uDefaultTerminate() const {
} // uAEHM::uThrowClass::uDefaultTerminate


uInitEvent(uAEHM::uThrowClass);


//######################### uAEHM::uRaiseClass ########################


void uAEHM::uRaiseClass::uStackThrow() const {
    uAbort( "Event cannot be thrown." );
} // uAEHM::uRaiseClass::uStackThrow

uAEHM::uRaiseClass::uRaiseClass( const char *const msg ) : uDualClass( msg ) {}

uAEHM::uRaiseClass::~uRaiseClass() {}

void uAEHM::uRaiseClass::uDefaultTerminate() const {
    uAbort( "uRaiseClass object has been casted to a throw-able object." );
} // uAEHM::uRaiseClass::uDefaultTerminate

void uAEHM::uRaiseClass::uDefaultResume() const {
    uTerminate();
} // uAEHM::uRaiseClass::uDefaultResume


uInitEvent(uAEHM::uRaiseClass);


//######################### uAEHM::uClosure ########################


uAEHM::uClosure::uClosure() {};
uAEHM::uClosure::~uClosure() {};


//######################### uAEHM::uResumptionHandlers ########################


uAEHM::uResumptionHandlers::uResumptionHandlers( uHandlerClause *const t, const unsigned int msg ) : size( msg ), uHandlerTable( t ) {
    uBaseCoroutine &tmp = uThisCoroutine();
    uSyncNext = tmp.uSyncHandlers;
    uAsyncNext = tmp.uAsyncHandlers;
    tmp.uSyncHandlers = this;
    tmp.uAsyncHandlers = this;
} // uAEHM::uResumptionHandlers::uResumptionHandlers

uAEHM::uResumptionHandlers::~uResumptionHandlers() {
    uBaseCoroutine &tmp = uThisCoroutine();
    tmp.uSyncHandlers = uSyncNext;
    tmp.uAsyncHandlers = uAsyncNext;
} // uAEHM::uResumptionHandlers::~uResumptionHandlers


//######################### uAEHM::uDeliverAEStack ########################


uAEHM::uDeliverAEStack::uDeliverAEStack( bool f, void **t = NULL, unsigned int msg = 0 ) : uDeliverFlag( f ), table_size( msg ), event_table( t ) {
    // the current node applies to all abnormal events when table_size is 0

    uBaseCoroutine &tmp = uThisCoroutine();
    next = tmp.uDAEStack;
    tmp.uDAEStack = this;
} // uAEHM::uDeliverAEStack::uDeliverAEStack

uAEHM::uDeliverAEStack::~uDeliverAEStack() {
    uBaseCoroutine &tmp = uThisCoroutine();
    tmp.uDAEStack = next;
} // uAEHM::uDeliverAEStack::~uDeliverAEStack


//######################### uAEHM::uRaiseWorkHorseInit ########################


// Initialization and finalization when handling a signalled event after
// finding a handler. This ensures the two different resuming handler
// hierarchies are properly maintained.

class uAEHM::uRaiseWorkHorseInit {
  private:
    uResumptionHandlers *prevSync;
  public:
    uRaiseWorkHorseInit( uResumptionHandlers *h ) {
	uBaseCoroutine &current = uThisCoroutine();
	prevSync = current.uSyncHandlers;
	current.uSyncHandlers = h;
    } // uAEHM::uRaiseWorkHorseInit::uRaiseWorkHorse

    ~uRaiseWorkHorseInit() {
	uThisCoroutine().uSyncHandlers = prevSync;
    } // uAEHM::uRaiseWorkHorseInit::~uRaiseWorkHorse
}; // uAEHM::uRaiseWorkHorseInit


//######################### uAEHM::uGarbageCollectAE ########################


class uAEHM::uGarbageCollectAE {
    uAsyncAEMsg *msg;
  public:
    uGarbageCollectAE( uAsyncAEMsg *msg ) : msg( msg ) {};
    ~uGarbageCollectAE() { delete msg; }
}; // uAEHM::uGarbageCollectAE


//######################### uAEHM ########################


// The asynchronous throw and raise, i.e, uAEThrow and uAERaise check if a null
// coroutine is used as a target.  no-op if so.  The user no longer needs to
// check if uSerialMember::uAcceptor returns a null address.

void uAEHM::uAEThrow( const uDualClass &ae_obj ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uAEHM::uAEThrow( uDualClass::ae_obj:0x%p ) from task 0x%p (%s)\n", &ae_obj, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
    ae_obj.uStackThrow();
} // uAEHM::uAEThrow

void uAEHM::uAEThrow( const uThrowClass &ae_obj ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uAEHM::uAEThrow( uThrowClass::ae_obj:0x%p ) from task 0x%p (%s)\n", &ae_obj, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
    ae_obj.uStackThrow();
} // uAEHM::uAEThrow

void uAEHM::uAEThrow( const uThrowClass &ae_obj, uBaseCoroutine &target ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "uAEHM::uAEThrow( uThrowClass::ae_obj:0x%p, target:0x%p ) from task 0x%p (%s)\n", &ae_obj, &target, &uThisTask(), uThisTask().uGetName() );
#endif __U_DEBUG_H__
    if ( &target != NULL && target.uGetState() != uBaseCoroutine::uHalt ) {
	uAsyncAEMsg *temp = new uAsyncAEMsg( ae_obj );
	target.uAsyncAEBuf.uAddMsg( temp );
    } // if
} // uAEHM::uAEThrow

void uAEHM::uAEThrow( const uDualClass &ae_obj, uBaseCoroutine &target ) {
    if ( &target != NULL && target.uGetState() != uBaseCoroutine::uHalt ) {
	uAsyncAEMsg *temp = new uAsyncAEMsg( ae_obj, uDualThrowF );
	target.uAsyncAEBuf.uAddMsg( temp );
    } // if
} // uAEHM::uAEThrow


void uAEHM::uAERaise( const uDualClass &ae_obj ) {
    uAERaiseWorkHorse( ae_obj, true );
} // uAEHM::uAERaise

void uAEHM::uAERaise( const uRaiseClass &ae_obj ) {
    uAERaiseWorkHorse( (uDualClass &)ae_obj, true );
} // uAEHM::uAERaise

void uAEHM::uAERaise( const uDualClass &ae_obj, uBaseCoroutine &target ) {
    if ( &target != NULL && target.uGetState() != uBaseCoroutine::uHalt ) {
	uAsyncAEMsg *temp = new uAsyncAEMsg( ae_obj, uDualRaiseF );
	target.uAsyncAEBuf.uAddMsg( temp );
    } // if
} // uAEHM::uAERaise

void uAEHM::uAERaise( const uRaiseClass &ae_obj, uBaseCoroutine &target ) {
    if ( &target != NULL && target.uGetState() != uBaseCoroutine::uHalt ) {
	uAsyncAEMsg *temp = new uAsyncAEMsg( ae_obj );
	target.uAsyncAEBuf.uAddMsg( temp );
    } // if
} // uAEHM::uAERaise


// Check for and handle pending asynchronous abnormal event.

void uAEHM::uDeliverEvents() {
    uAsyncAEMsgBuffer &msgbuf = uThisCoroutine().uAsyncAEBuf;
    uAsyncAEMsg *ae_msg;				// hold the return value from iterator
    uProtectLock dummy( msgbuf.lock );			// locking the AE Message Buffer before creating the iterator

    uThisCoroutine().uOrderEvents();			// re-order events if necessary

    for ( uSeqGen<uAsyncAEMsg> uMsgGen(msgbuf); uMsgGen >> ae_msg; ) {
	if ( deliverable_event( (void *)(ae_msg->ae->uEvent_id()) ) ) {
	    msgbuf.uRemove(ae_msg);			// remove deliverable event from the queue
	    uDualClass *ae = ae_msg->ae;

	    // Recover memory allocated for async event message. Resuming handler
	    // should not destroyed raised events regardless of whether the event
	    // is synchronous or asynchronous.

	    uGarbageCollectAE dummy_var( ae_msg );
	    if ( ae_msg->flag <= uDualThrowF ) {	// throw the event
		ae->uStackThrow();
	    } // if
	    uAERaiseWorkHorse( *ae, false );
	} // if
    } // for
} // uAEHM::uDeliverEvents


void uAEHM::uTerminate() {
    uAbort( "Unhandled abnormal event for task 0x%p (%.256s)", &uThisTask(), uThisTask().uGetName() );
} // uAEHM::uTerminate


bool uAEHM::uMatch_abnormal_event( void *derived_id, void *const parent_id ) {
    // return true if derived_id event is derived from parent_id event
#ifdef __DEBUG__
    if ( ! parent_id ) uAbort( "Error in setting up guarded region." );
#endif __DEBUG__
    for ( ; derived_id && derived_id != parent_id; derived_id = *((void **)derived_id) ) {
    } // for

    // all the ancestors of raised_id have been tested or a match found
    return derived_id;
}  // uAEHM::uMatch_abnormal_event


bool uAEHM::deliverable_event( void *event_id ) {
    for ( uDeliverAEStack *tmp = uThisCoroutine().uDAEStack; tmp; tmp=tmp->next ) {
	if ( tmp->table_size == 0 ) {			// table_size == 0 is a short hand for all abnormal events
	    return tmp->uDeliverFlag;
	} // if

	for( int i=0; i < tmp->table_size; i += 1 ) {
	    if ( uMatch_abnormal_event( event_id, tmp->event_table[i] ) ) {
		return tmp->uDeliverFlag;
	    } // if
	} // for
    } // for
    return false;
} // uAEHM::deliverable_event


// uAERaiseWorkHorse signals an event synchronously if is_sync is true;
// otherwise asynchronously it searches a handler and handles an abnormal event
// in the current threads.

void uAEHM::uAERaiseWorkHorse( const uDualClass &ae_obj, const bool is_sync ) {
    void *event_id = ae_obj.uEvent_id();
    uResumptionHandlers *tmp = (is_sync) ? uThisCoroutine().uSyncHandlers : uThisCoroutine().uAsyncHandlers;

    while ( tmp ) {
	uResumptionHandlers *next = (is_sync) ? tmp->uSyncNext : tmp->uAsyncNext;
	uHandlerClause *table = &(tmp->uHandlerTable[0]);
	for ( unsigned int i = 0; i < tmp->size; i += 1 ) {
	    if ( uMatch_abnormal_event( event_id, table[i].event_id ) ) {
		uRaiseWorkHorseInit modify_sync_handlers( next );
		void *const h = uDualClosureHandler( table[i].handler );
		uClosure *cls = (uClosure *)table[i].cls_ptr;

		if ( ! h ) return;			// event is explicitly ignored by the execution

		if ( cls ) {
		    (uDualClosureHandler(h))((uDualClass &)(ae_obj), *cls); // with handler and closure
		} else {
		    (uDualHandler(h))((uDualClass &)(ae_obj)); // with handler, no closure
		} // if

		return;					// return after handling the event
	    } // if
	    // try next resumption handler in the same clause
	} // for
	tmp = next;					// next resumption handler clause
    } // while

    // cannot find a handler, use the default handler

    ae_obj.uDefaultResume();				// default handler can change the event
} // uAEHM::uAERaiseWorkHorse


// Local Variables: //
// compile-command: "dmake" //
// End: //
