//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uContext.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Thu Jul  7 13:08:01 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul  4 20:14:25 1996
// Update Count     : 9
// 

#include <uC++.h>
#include <stdio.h>

// WARNING: Do not use uCout or uCerr in uSave or uRestore as they cause a
// recursive context switch (BAD!).

class uCoProcessorCxt1 : public uContext {
    static int uUniqueKey;
  public:
    uCoProcessorCxt1() : uContext( &uUniqueKey ) {};
    void uSave() {
	printf( "uCoProcessorCxt1::uSave\n" );
    }
    void uRestore() {
	printf( "uCoProcessorCxt1::uRestore\n" );
    }
}; // uCoProcessorCxt1

int uCoProcessorCxt1::uUniqueKey = 0;

class uCoProcessorCxt2 : public uContext {
  public:
    void uSave() {
	printf( "uCoProcessorCxt2::uSave\n" );
    }
    void uRestore() {
	printf( "uCoProcessorCxt2::uRestore\n" );
    }
}; // uCoProcessorCxt2

void uMain::main() {
    uCoProcessorCxt1 cpCxt11, cpCxt12;
    uCoProcessorCxt2 cpCxt21, cpCxt22;

    for ( int i = 0; i < 5; i += 1 ) {
	uYield();
    } // for
} // uMain::main
    
// Local Variables: //
// compile-command: "u++ -O uContext.cc" //
// End: //
