//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// uCalibrate.cc -- Calibrate the number of iterations of a set piece of code
//    to produce a 100 microsecond delay.
// 
// Author           : Peter A. Buhr
// Created On       : Fri Aug 16 14:12:08 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 27 10:32:12 1996
// Update Count     : 17
// 

#include <uC++.h>
#include <uIOStream.h>

#include "Time.h"

#define TIMES 10000000					// cannot be larger or overflow occurs

void uMain::main() {
    int i;
    int StartTime, EndTime;
    
    StartTime = Time();
    for ( i = 1; i <= TIMES; i += 1 ) {
    } // for
    EndTime = Time();

    uCout << "#define ITERATIONS_FOR_100USECS " << ( 100 * TIMES ) / ( EndTime - StartTime ) << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ uCalibrate.cc" //
// End: //
