extern "C" {
#if defined( __svr4__ ) || defined( __hpux__ )

#include <sys/times.h>
#include <sys/param.h>
#include <unistd.h>
#include <limits.h>
#include <time.h>

inline int Time( void ) {
    struct tms usage;

    times( &usage );
    return usage.tms_utime * ( 1000000 / CLK_TCK ) +
	   usage.tms_stime * ( 1000000 / CLK_TCK );
} /* Time */

#else							/* BSD */

#include <sys/time.h>
#include <sys/resource.h>

inline int Time( void ) {
    struct rusage usage;

    getrusage( RUSAGE_SELF, &usage );
    return usage.ru_utime.tv_sec * 1000000 + usage.ru_utime.tv_usec +
	   usage.ru_stime.tv_sec * 1000000 + usage.ru_stime.tv_usec;
} /* Time */

#endif
} // extern "C"
