//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// TaskAcceptBB.cc -- Generic bounded buffer using a task
// 
// Author           : Peter A. Buhr
// Created On       : Sun Sep 15 20:24:44 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Sep 24 10:34:26 1997
// Update Count     : 62
// 

#include <uC++.h>
#include <uIOStream.h>

template<class ELEMTYPE> uTask BoundedBuffer {
	const int size;										// number of buffer elements
	int front, back;									// position of front and back of queue
	int count;											// number of used elements in the queue
	ELEMTYPE *Elements;
  public:
	BoundedBuffer( const int size = 10 ) : size( size ) {
		front = back = count = 0;
		Elements = new ELEMTYPE[size];
	} // BoundedBuffer::BoundedBuffer

	~BoundedBuffer() {
		delete [] Elements;
	} // BoundedBuffer::~BoundedBuffer

	uNoMutex int query() {
		return count;
	} // BoundedBuffer::query

	void insert( ELEMTYPE elem ) {
		Elements[back] = elem;
	} // BoundedBuffer::insert

	ELEMTYPE remove() {
		return Elements[front];
	} // BoundedBuffer::remove
  protected:
	void BoundedBuffer::main() {
		for ( ;; ) {
			uAccept( ~BoundedBuffer ) {
				break;
			} uOr uWhen ( count != size ) uAccept( insert ) {
				back = ( back + 1 ) % size;
				count += 1;
			} uOr uWhen ( count != 0 ) uAccept( remove ) {
				front = ( front + 1 ) % size;
				count -= 1;
			} // uAccept
		} // for
	} // BoundedBuffer::main
}; // BoundedBuffer

#include "ProdConsDriver.i"

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ TaskAcceptBB.cc" //
// End: //
