//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// SpinLock.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Feb 13 15:47:48 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Feb 17 20:29:31 1995
// Update Count     : 8
// 

#include <uC++.h>
#include <uIOStream.h>

int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

uBaseTask *CurrTid;					// current task id

void CriticalSection() {
    ::CurrTid = &uThisTask();				// address of current task
    
    for ( int i = 1; i <= 100; i += 1 ) {		// delay
	// perform critical section operation
	if ( ::CurrTid != &uThisTask() ) {		// check for mutual exclusion violation
	    uAbort( "interference" );
	} // if
    } // for
} // CriticalSection   

uSpinLock Lock;

uTask Tester {
    void main() {
	for ( int i = 1; i <= 10000; i += 1 ) {
	    ::Lock.uAcquire();
	    CriticalSection();				// critical section
	    ::Lock.uRelease();
	} // for
    } // main
  public:
    Tester() {}
}; // Tester
    
void uMain::main() {
    Tester t[10];
} // main

// Local Variables: //
// compile-command: "../../bin/u++ -multi -g SpinLock.cc" //
// End: //
