//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// Sim.cc -- This program performs a benchmark test on the concurrency facilities
//    of the multiprocessor uC++.
// 
// Author           : Peter A. Buhr
// Created On       : Fri Aug 16 13:51:34 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Sep 11 22:34:13 1997
// Update Count     : 113
// 


#include <uC++.h>
#include <uIOStream.h>
#include "uCalibrate.h"
#include <stdlib.h>					// prototype: atoi


//int uDefaultPreemption() {
//    return 1;
//} // uDefaultPreemption

//int uDefaultSpin() {
//     return 0;
//} // uDefaultSpin

uTask Worker {
    int NoWorkers, PerWorker, Extra;

    void main();
  public:
    Worker( int NoWorkers, int PerWorker, int Extra ) : NoWorkers( NoWorkers ), PerWorker( PerWorker ), Extra( Extra ) {
    } // Worker::Worker
}; // Worker

void Worker::main() {
    int i, j;
    int leftworkers, rightworkers, work, extrawork;
    Worker *LeftWorker, *RightWorker;

    work = PerWorker;
    if ( Extra > 0 ) {					// if there are still extras, take one
	Extra -= 1;
	work += 1;
    } // if
    NoWorkers -= 1;					// take a worker
    if ( NoWorkers > 0 ) {				// create siblings
	leftworkers = NoWorkers / 2;
	extrawork = Extra / 2;
	if ( leftworkers != 0 ) {
	    LeftWorker = new Worker( leftworkers, PerWorker, extrawork );
	} // if
	rightworkers = NoWorkers - leftworkers;
	extrawork = Extra - extrawork;
	RightWorker = new Worker( rightworkers, PerWorker, extrawork );
    } // if

    for ( i = 1; i <= work; i += 1 ) {
	for ( j = 1; j <= ITERATIONS_FOR_100USECS; j += 1 ) { // 0.1 millisecond loop
	} // for
    } // for

    if ( NoWorkers > 0 ) {				// wait for sibling, if any
	if ( leftworkers != 0 ) {
	    delete LeftWorker;
	} // if
	delete RightWorker;
    } // if
} // Worker::main

void uMain::main() {
    int NoWorkers, NoProcessors, work;

    if ( argc != 4 ) {
	uAbort( "Usage: no.-processors  no.-worker-tasks  amount-of-task-work" );
    } // if

    NoProcessors  = atoi( argv[1] );
    NoWorkers = atoi( argv[2] );
    work = atoi( argv[3] );
    {
	uProcessor processor[NoProcessors - 1];
	Worker worker( NoWorkers, work / NoWorkers, work % NoWorkers );
    }
    uCout << "successful completion" << endl;
} // uMain

// Local Variables: //
// compile-command: "../../bin/u++ -multi -g Sim.cc" //
// End: //
