//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// SemaphoreBB.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug 15 16:42:42 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Dec  3 07:04:34 1998
// Update Count     : 50
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uSemaphore.h>

template<class ELEMTYPE> class BoundedBuffer {
	const int size;										// number of buffer elements
	int front, back;									// position of front and back of queue
	uSemaphore full, empty;								// synchronize for full and empty BoundedBuffer
	uSemaphore ilock, rlock;							// insertion and removal locks
	ELEMTYPE *Elements;

	BoundedBuffer( BoundedBuffer & );					// no copy
	BoundedBuffer &operator=( BoundedBuffer & );		// no assignment
  public:
	BoundedBuffer( const int size = 10 ) : size( size ), full( 0 ), empty( size ) {
		front = back = 0;
		Elements = new ELEMTYPE[size];
	} // BoundedBuffer::BoundedBuffer

	~BoundedBuffer() {
		delete  Elements;
	} // BoundedBuffer::~BoundedBuffer

	void insert( ELEMTYPE elem ) {
		empty.uP();										// wait if queue is full

		ilock.uP();										// serialize insertion
		Elements[back] = elem;
		back = ( back + 1 ) % size;
		ilock.uV();

		full.uV();										// signal a full queue space
	} // BoundedBuffer::insert

	ELEMTYPE remove() {
		ELEMTYPE elem;
		
		full.uP();										// wait if queue is empty

		rlock.uP();										// serialize removal
		elem = Elements[front];
		front = ( front + 1 ) % size;
		rlock.uV();

		empty.uV();										// signal empty queue space
		return elem;
	} // BoundedBuffer::remove
}; // BoundedBuffer

#include "ProdConsDriver.i"

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ SemaphoreBB.cc" //
// End: //
