//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// RWEx1.cc -- Readers and Writer Problem
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:51:34 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul  4 20:13:54 1996
// Update Count     : 82
// 

#include <uC++.h>
#include <uIOStream.h>


uMonitor ReaderWriter {
	int ReadCount, WriteUsage;
	uCondition ReaderAndWriter;
	enum RW { READER, WRITER };
  public:
	ReaderWriter() {
		ReadCount = WriteUsage = 0;
	} // ReaderWriter

	void StartRead() {
		if ( WriteUsage || !ReaderAndWriter.uEmpty() ) {
			uWait ReaderAndWriter uWith READER;
		} // if
		ReadCount += 1;
		if ( ! ReaderAndWriter.uEmpty() && ReaderAndWriter.uFront() == READER ) {
			uSignal ReaderAndWriter;
		} // if
	} // ReaderWriter::StartRead

	void EndRead() {
		ReadCount -= 1;
		if ( ReadCount == 0 ) {
			uSignal ReaderAndWriter;
		} // if
	} // ReaderWriter::EndRead

	void StartWrite() {
		if ( WriteUsage || ReadCount != 0 ) {
			uWait ReaderAndWriter uWith WRITER;
		} // if
		WriteUsage = 1;
	} // ReaderWriter::StartWrite

	void EndWrite() {
		WriteUsage = 0;
		uSignal ReaderAndWriter;
	} // ReaderWriter::EndWrite
}; // ReaderWriter


int SharedVar = 0;										// shared variable to test readers and writers

uTask Worker {
	ReaderWriter &rw;

	void main() {
		uYield( rand() % 100 );							// don't all start at the same time
		if ( rand() % 100 < 70 ) {						// decide to be a reader or writer
			rw.StartRead();
			uCout << uAcquire << "Reader:" << this << ", shared:" << SharedVar << endl << uRelease;
			uYield( 3 );
			rw.EndRead();
		} else {
			rw.StartWrite();
			SharedVar += 1;
			uCout << uAcquire << "Writer:" << this << ",  wrote:" << SharedVar << endl << uRelease;
			uYield( 1 );
			rw.EndWrite();
		} // if
	} // Worker::main
  public:
	Worker( ReaderWriter &rw ) : rw( rw ) {
	} // Worker::Worker
}; // Worker

#define MaxTask 50

void uMain::main() {
	ReaderWriter rw;
	Worker *workers;
	
	workers = new Worker[MaxTask]( rw );
	delete [] workers;

	uCout << uAcquire << "successful completion" << endl << uRelease;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ RWEx1.cc" //
// End: //
