//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// ProdConsDriver.i -- Producer/Consumer Driver for a bounded buffer
// 
// Author           : Peter A. Buhr
// Created On       : Sun Sep 15 18:19:38 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Sep  7 22:26:37 1998
// Update Count     : 64
// 


uTask producer {
	BoundedBuffer<int> &buf;

	void main() {
		const int NoOfItems = rand() % 20;
		int item;

		for ( int i = 1; i <= NoOfItems; i += 1 ) {		// produce a bunch of items
			uYield( rand() % 20 );						// pretend to spend some time producing
			item = rand() % 100 + 1;					// produce a random number
			uCout << uAcquire << "Producer:" << this << ", value:" << item << endl << uRelease;
			buf.insert( item );							// insert element into queue
		} // for
		uCout << uAcquire << "Producer " << this << " is finished!" << endl << uRelease;
	} // producer::main
  public:
	producer( BoundedBuffer<int> &buf ) : buf( buf ) {
	} // producer::producer
}; // producer

uTask consumer {
	BoundedBuffer<int> &buf;

	void main() {
		int item;

		for ( ;; ) {									// consume until a negative element appears
			item = buf.remove();						// remove from front of queue
			uCout << uAcquire << "Consumer:" << this << ", value:" << item << endl << uRelease;
		  if ( item == -1 ) break;
			uYield( rand() % 20 );						// pretend to spend some time consuming
		} // for
		uCout << uAcquire << "Consumer " << this << " is finished!" << endl << uRelease;
	} // consumer::main
  public:
	consumer( BoundedBuffer<int> &buf ) : buf( buf ) {
	} // consumer::consumer
}; // consumer

void uMain::main() {
	const int NoOfCons = 2, NoOfProds = 3;
	BoundedBuffer<int> buf;								// create a buffer monitor
	consumer *cons;										// pointer to an array of consumers
	producer *prods;									// pointer to an array of producers

	cons = new consumer[NoOfCons]( buf );				// create consumers
	prods = new producer[NoOfProds]( buf );				// create producers

	delete [] prods;									// wait for producers to end
			
	for ( int i = 0; i < NoOfCons; i += 1 ) {			// terminate each consumer
		buf.insert( -1 );
	} // for

	delete [] cons;										// wait for consumers to end

	uCout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// End: //
