//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1996
// 
// MutexOwner.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Feb  6 13:51:59 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Aug 24 13:13:40 1998
// Update Count     : 10
// 

#include <uC++.h>
#include <uIOStream.h>

uCoMonitor tom {
  public:
    reset() {
	uCout << uAcquire << "(" << &uThisTask() << ") tom::reset" << endl << uRelease;
    }
    tom() {
	reset();
    }
};    

uCoMonitor fred : public tom {
    void main() {
	for ( int i = 0; i < 3; i += 1 ) {
	    mem();
	} // for
	uResume;
    }
  public:
    reset() {
	uCout << uAcquire << "(" << &uThisTask() << ") fred::reset" << endl << uRelease;
    }
    fred() {
	reset();
    }
    void mem() {
	uResume;
    }
};

uMonitor mary {
    uCondition delay;
  public:
    mem( int i ) {
	if ( i >= 0 ) {
	    mem( i - 1 );
	    uCout << uAcquire << "(" << &uThisTask() << ") mary::mem, i:" << i << endl << uRelease;
	} else {
	    if ( delay.uEmpty() ) {
		uWait delay;
	    } else {
		uSignal delay;
	    } // if
	} // if
    } // mary::mem
}; // mary

uTask jane {
    mary &m;
  public:
    jane( mary &m ) : m( m ) {}
    mem( int i ) {
	if ( i == 2 ) {
	    m.mem( i );
	} // if
    }
  protected:
    void main() {
	for ( int i = 0; i < 3; i += 1 ) {
	    uCout << uAcquire << "(" << &uThisTask() << ") jane::main, i:" << i << endl << uRelease;
	    mem( i );
	} // for
    } // jane::main
}; // jane

void uMain::main() {
    fred f;
    f.mem();

    mary m;
    jane j1( m );
    jane j2( m );
} // uMain::main

// Local Variables: //
// compile-command: "../../bin/u++ -multi -g MutexOwner.cc" //
// End: //
