//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// Migrate.cc -- Test migrating of tasks among clusters.
// 
// Author           : Peter Buhr
// Created On       : Tue Jun 28 10:23:11 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Oct 23 09:39:28 1998
// Update Count     : 28
// 

#include <uC++.h>
#include <uIOStream.h>


int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

uTask dummy {
    uCluster &c1, &c2, &c3;

    void main() {
	const int NoOfTimes = 10000;

        for ( int i = 0; i < NoOfTimes; i += 1 ) {
	    uMigrate( c3 );
	    uMigrate( c2 );
	    uMigrate( c1 );
        } // for
    } // dummy::main
  public:
    dummy( uCluster &c1, uCluster &c2, uCluster &c3 ) : uBaseTask( c1 ), c1( c1 ), c2( c2 ), c3( c3 ) {
    } // dummy::dummy
}; // dummy

uCluster c1;
uProcessor p1(c1);

uCluster c2;
uProcessor p2(c2);

void uMain::main() {
    {
	dummy d1( uThisCluster(), c1, c2 ), d2( c2, uThisCluster(), c1 ), d3( c1, c2, uThisCluster() );
    }
    uCout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Migrate.cc" //
// End: //
