//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// Lang.cc -- Extended finite-state machine to match language
// 
// Author           : Peter A. Buhr
// Created On       : Wed Mar 20 14:11:27 1991
// Last Modified By : Peter Buhr
// Last Modified On : Wed May 11 17:32:07 1994
// Update Count     : 84
// 

#include <uC++.h>
#include <uFStream.h>

//  This grammar parses the language ab+c*d, where the number of b's must
//  be exactly one greater than the number of c's. The coroutine has 3 states:
//  
//  CONT  => continue parsing
//  ERROR => error in string
//  MATCH => string occurs in language

#define CONT	0
#define ERROR	1
#define MATCH	2

uCoroutine grammar {
    char ch;
    int ok;

    void main() {
	int bcnt, ccnt;

	ok = CONT;
	if ( ch == 'a' ) {
	    bcnt = 0;
	    for ( ;; ) {
		uSuspend;
	      if ( ch != 'b' ) break;
		bcnt += 1;
	    } // for
	    ccnt = 0;
	    for ( ;; ) {
	      if ( ch != 'c' ) break;
		ccnt += 1;
	      if ( bcnt < ccnt + 1 ) break;
		uSuspend;
	    } // for
	    ok = ( ch == 'd' && bcnt == ccnt + 1 ) ? MATCH : ERROR;
	} else {
	    ok = ERROR;
	} // if
    }; // grammar::main
  public:
    int check( char ch ) {
	grammar::ch = ch;
	uResume;
	return ok;
    }; // grammer::check
}; // grammar

void uMain::main() {
    uIStream *input;
    grammar gram;
    int status, i, state;
    char string[256];
    
    switch ( argc ) {
      case 1:
	input = &uCin;
	break;
      case 2:
	input = new uIFStream( argv[1] );
	break;
      default:
	uCerr << "Usage:" << argv[0] << " input-file" << endl;
	uExit( -1 );
    } // switch
    
    for ( ;; ) {
	*input >> string;				// input a string delimited by whitespace
      if ( input->eof() ) break;
	uCout << "string:\"";
	{
	    grammar gram;

	    for ( i = 0; i < strlen(string) + 1; i += 1 ) { // pass the string termination character, if necessary
		state = gram.check( string[i] );
		if ( string[i] != '\0' ) uCout << string[i]; // don't print the terminator character
	      if ( state == ERROR ) {
		    uCout << "\" is NOT in language" << endl;
		    break;
		} // exit
	      if ( state == MATCH ) {
		    uCout << "\" is in language" << endl;
		    break;
		} // exit
	    } // for
	}
    } // for

    if ( input != &uCin ) delete input;			// close file
} // uMain::main

// Local Variables: //
// compile-command: "u++ Lang.cc" //
// End: //
