#include <iostream.h>

#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>					// perror

#define EOD '\377'

int main() {
    int code;

    int s = socket( AF_UNIX, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
		perror( "server socket" );
		exit( -1 );
    } // if

    struct sockaddr_un server;
    server.sun_family = AF_UNIX;
    strcpy( server.sun_path, "fred" );

    code = bind( s, (struct sockaddr *)&server, sizeof(server) );
    if ( code == -1 ) {
		perror( "server bind" );
		exit( -1 );
    } // if

    struct sockaddr_un client;
	int clientlen = sizeof(client);
	memset( client, '\0', clientlen );

    for ( ;; ) {
		char msg[256];
		int len;

		len = recvfrom( s, msg, sizeof(msg), 0, (sockaddr *)&client, &clientlen );
		if ( len == -1 ) {
			perror( "server recvfrom" );
			exit( -1 );
		} // if
	  if ( msg[0] == EOD ) break;
		len = sendto( s, msg, len, 0, (sockaddr *)&client, clientlen );
		if ( len == -1 ) {
			perror( "server sendto" );
			exit( -1 );
		} // if
    } // for

	close( s );
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "g++ -g server2.cc -o server2 -lsocket -lnsl" //
// End: //
