#include <sys/socket.h>
#include <netdb.h>					// MAXHOSTNAMELEN on Solaris
#include <stdio.h>					// perror
#include <string.h>					// memset

int gethostname( char *name, int namelen );	// missing from 

#define EOD '\377'

int main( int argc, char *argv[] ) {
    int code, s, len;
	unsigned short port;								// our port number
	unsigned short client_port;							// client port number
	unsigned client_addr;								// client IP address
    char name[MAXHOSTNAMELEN+1];
	struct hostent *hp;
    struct sockaddr_in saddr;

    s = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
		perror( "server socket" );
		exit( -1 );
    } // if

    code = gethostname( name, sizeof(name) );			// get host name for this system
    if ( code == -1 ) {
		perror( "server gethostname" );
		exit( -1 );
    } // if

    hp = gethostbyname( name );							// get internet address from internet name
    if ( hp == NULL ) {
		perror( "server gethostbyname" );
		exit( -1 );
    } // if

    saddr.sin_family = AF_INET;
    saddr.sin_port = htons( 0 );						// let host select a free port number
    memcpy( &(saddr.sin_addr), hp->h_addr, hp->h_length );
    memset( &(saddr.sin_zero), '\0', sizeof(saddr.sin_zero) );

    code = bind( s, (struct sockaddr *)&saddr, sizeof(saddr) );
    if ( code == -1 ) {
		perror( "server bind" );
		exit( -1 );
    } // if

    len = sizeof(saddr);								// get host selected port number
    code = getsockname( s, (struct sockaddr *)&saddr, &len );
    if ( code == -1 ) {
		perror( "getsockname" );
		exit( -1 );
    } // if
    port = ntohs( saddr.sin_port );

    printf( "%d\n", port );
#if 1
    len = recvfrom( s, (char *)&client_addr, sizeof(client_addr), 0, NULL, NULL);
    if ( len == -1) {
		perror( "server recvfrom of client address" );
		exit( -1 );
    } // if
    if ( len != sizeof(client_addr)) {
		fprintf( stderr, "bad length receiving client address" );
		exit( -1 );
    } // if
    saddr.sin_addr.s_addr = client_addr;

    len = recvfrom( s, (char *)&client_port, sizeof(client_port), 0, NULL, NULL);
    if ( len == -1) {
		perror( "server recvfrom of client port" );
		exit( -1 );
    } // if
    if ( len != sizeof(client_port)) {
		fprintf( stderr, "bad length receiving client port" );
		exit( -1 );
    } // if
    saddr.sin_port = client_port;
#endif
    for ( ;; ) {
		char msg[256];

		len = recvfrom( s, msg, sizeof(msg), 0, NULL, NULL );
		if ( len == -1 ) {
			perror( "server recvfrom" );
			exit( -1 );
		} // if
		len = sendto( s, msg, len, 0, (struct sockaddr *)&saddr, sizeof(saddr) );
		if ( len == -1 ) {
			perror( "server sendto" );
			exit( -1 );
		} // if
	  if ( msg[0] == EOD ) break;
    } // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "gcc -g server.c -o server -lsocket -lnsl" //
// End: //
