#include <iostream.h>

#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>										// perror
#include <strings.h>									// strncpy
#include <unistd.h>										// unlink

#define EOD '\377'

int main() {
    int code;

    int s = socket( AF_UNIX, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
		perror( "client socket" );
		exit( -1 );
    } // if

    struct sockaddr_un client;
    client.sun_family = AF_UNIX;
	char *tmpnm = tempnam( NULL, "uC++" );
	printf( "name:\"%s\"\n", tmpnm );
	strncpy( client.sun_path, tmpnm, sizeof(client.sun_path) );
	delete tmpnm;

    code = bind( s, (struct sockaddr *)&client, sizeof(client) );
    if ( code == -1 ) {
		perror( "client bind" );
		exit( -1 );
    } // if

    struct sockaddr_un server;
    server.sun_family = AF_UNIX;
    strcpy( server.sun_path, "fred" );

    for ( ;; ) {
		char msg[256];
		int len;

		cin.getline( msg, sizeof(msg) );
		len = strlen(msg);
		msg[len] = '\n';								// add newline at end
		msg[len+1] = '\0';
		if ( cin.eof() ) {
			msg[0] = EOD;
			msg[1] = '\0';
		} // if
		len = sendto( s, msg, strlen(msg),  0, (struct sockaddr *)&server, sizeof(server) );
		if ( len == -1 ) {
			perror( "client sendto" );
			exit( -1 );
		} // if
	  if ( cin.eof() ) break;
		len = recvfrom( s, msg, sizeof(msg), 0, (sockaddr *)NULL, NULL );
		if ( len == -1 ) {
			perror( "client recvfrom" );
			exit( -1 );
		} // if
		cout << msg;
    } // for

	close( s );
	code = unlink( client.sun_path );
    if ( code == -1 ) {
		perror( "client unlink" );
		exit( -1 );
    } // if
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "g++ -g client2.cc -o client2 -lsocket -lnsl" //
// End: //
