#include <sys/types.h>   
#include <sys/socket.h>
#include <netdb.h>										// MAXHOSTNAMELEN on Solaris
#include <stdio.h>										// perror
#include <stdlib.h>										// atoi
#include <netinet/in.h>
#include <unistd.h>

int gethostname( char *name, int namelen );				// missing from 

#define EOD '\377'

int main( int argc, char *argv[] ) {
    int code, s, len;
    unsigned short port;
    char name[MAXHOSTNAMELEN+1];
    struct hostent *hp;
    struct sockaddr_in saddr;
	struct sockaddr_in caddr;

    switch ( argc ) {
      case 2:
        break;
      default:
        printf( "Usage: %s port-number\n", argv[0] );
        exit( -1 );
    } // switch

    port = atoi( argv[1] );

    s = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
        perror( "client socket" );
        exit( -1 );
    } // if

    code = gethostname( name, sizeof(name) );			// get host name for this system
    if ( code == -1 ) {
        perror( "client gethostname" );
        exit( -1 );
    } // if

    hp = gethostbyname( name );							// get internet address from internet name
    if ( hp == NULL ) {
        perror( "client gethostbyname" );
        exit( -1 );
    } // if

	memset((char *) &caddr, 0, sizeof(caddr));			// construct client address
	caddr.sin_family = AF_INET;
	caddr.sin_addr.s_addr = htonl(INADDR_ANY);
	caddr.sin_port = htons(0);

	if ( bind( s, (struct sockaddr *)&caddr, sizeof(caddr) ) == -1 ) {
		perror( "client bind" );
		exit( -1 );
	} // if

	memset((char *) &saddr, 0, sizeof(saddr));			// construct server address
    saddr.sin_family = AF_INET;
    memcpy( &(saddr.sin_addr), hp->h_addr, hp->h_length );
    saddr.sin_port = htons( port );

    for ( ;; ) {
        int msg;
        int len;

        msg = getc( stdin );
        if ( feof( stdin ) ) {
            msg = EOD;
        } // if
        len = sendto( s, (char *)&msg, sizeof(char), 0, (struct sockaddr *)&saddr, sizeof(saddr) );
        if ( len == -1 ) {
            perror( "client sendto" );
            exit( -1 );
        } // if
		
        len = recvfrom( s, (char *)&msg, sizeof(char), 0, NULL, NULL );
        if ( len == -1 ) {
            perror( "client recvfrom" );
            exit( -1 );
        } // if
	  if ( feof( stdin ) ) break;
        putc( msg, stdout );
    } // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "gcc -g client1.c -o client -lsocket -lnsl" //
// End: //
