#include <iostream.h>

#include <sys/socket.h>
#include <netdb.h>					// MAXHOSTNAMELEN on Solaris
#include <stdio.h>					// perror
#include <stdlib.h>					// atoi

extern "C" int gethostname( char *name, int namelen );	// missing from 

#define EOD '\377'

int main( int argc, char *argv[] ) {
    int code;
    unsigned short port;

	switch ( argc ) {
	  case 2:
		break;
	  default:
		cout << "Usage: " << argv[0] << " port-number" << endl;
		exit( -1 );
	} // switch

    port = atoi( argv[1] );

    int s = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
		perror( "socket" );
		exit( -1 );
    } // if

    char name[MAXHOSTNAMELEN+1];

    code = gethostname( name, sizeof(name) );			// get host name for this system
    if ( code == -1 ) {
		perror( "gethostname" );
		exit( -1 );
    } // if

    struct hostent *hp = gethostbyname( name );			// get internet address from internet name
    if ( hp == NULL ) {
		perror( "gethostbyname" );
		exit( -1 );
    } // if

    struct sockaddr_in sockinfo;
    sockinfo.sin_family = AF_INET;
    memcpy( &(sockinfo.sin_addr), hp->h_addr, hp->h_length );
    sockinfo.sin_port = htons( port );

    for ( ;; ) {
		char msg[256];
		int len;

		cin.getline( msg, sizeof(msg) );
		if ( cin.eof() ) {
			msg[0] = EOD;
			msg[1] = '\0';
		} // if
		len = sendto( s, msg, strlen(msg), 0, (struct sockaddr *)&sockinfo, sizeof(sockinfo) );
		if ( len == -1 ) {
			perror( "client sendto" );
			exit( -1 );
		} // if
		len = sendto( s, "\n", sizeof(char), 0, (struct sockaddr *)&sockinfo, sizeof(sockinfo) );
		if ( len == -1 ) {
			perror( "sendto" );
			exit( -1 );
		} // if
	  if ( cin.eof() ) break;
    } // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "g++ -g client.cc -o client -lsocket -lnsl" //
// End: //
