#include <sys/socket.h>
#include <netdb.h>					// MAXHOSTNAMELEN on Solaris
#include <stdio.h>					// perror
#include <stdlib.h>					// atoi

int gethostname( char *name, int namelen );	// missing from 

#define EOD '\377'

int main( int argc, char *argv[] ) {
    int code, s, len;
    unsigned short port;								// server port number
    unsigned short local_port;							// our port number
    unsigned local_addr;								// our address
    unsigned addr_len;									// length of struct sockaddr_in
    char name[MAXHOSTNAMELEN+1];
    struct hostent *hp;
    struct sockaddr_in saddr;

	switch ( argc ) {
	  case 2:
		break;
	  default:
		printf( "Usage: %s port-number\n", argv[0] );
		exit( -1 );
	} // switch

    port = atoi( argv[1] );

    s = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( s < 0 ) {
		perror( "client socket" );
		exit( -1 );
    } // if

    code = gethostname( name, sizeof(name) );			// get host name for this system
    if ( code == -1 ) {
		perror( "client gethostname" );
		exit( -1 );
    } // if

    hp = gethostbyname( name );							// get internet address from internet name
    if ( hp == NULL ) {
		perror( "client gethostbyname" );
		exit( -1 );
    } // if

    saddr.sin_family = AF_INET;
#if 1
    saddr.sin_addr.s_addr = INADDR_ANY;
    saddr.sin_port = INADDR_ANY;
    if (bind(s, (struct sockaddr *) &saddr, sizeof(saddr)) < 0) {
		perror( "client binding socket" );
		exit( -1 );
    } // if
    addr_len = sizeof(saddr);
    if (getsockname(s, (struct sockaddr *) &saddr, &addr_len) < 0) {
		perror( "client getsockname" );
		exit( -1 );
    } // if
    local_port = saddr.sin_port;						// still in network byte order
    local_addr = saddr.sin_addr.s_addr;
#endif
    memcpy( &(saddr.sin_addr), hp->h_addr, hp->h_length );
    saddr.sin_port = htons( port );
#if 1
    // send the server our address
    len = sendto ( s, (char *) &local_addr, sizeof(local_addr), 0, (struct sockaddr *) &saddr, sizeof(saddr) );
    if ( len == -1 ) {
		perror ( "client sendto of address" );
		exit( -1 );
    } // if

    // send the server our port number
    len = sendto ( s, (char *) &local_port, sizeof(local_port), 0, (struct sockaddr *) &saddr, sizeof(saddr) );
    if ( len == -1 ) {
		perror ( "client sendto of port number" );
		exit( -1 );
    } // if
#endif
    for ( ;; ) {
		int msg;
		int len;

		msg = getc( stdin );
		if ( feof( stdin ) ) {
			msg = EOD;
		} // if
		len = sendto( s, (char *)&msg, sizeof(char), 0, (struct sockaddr *)&saddr, sizeof(saddr) );
		if ( len == -1 ) {
			perror( "client sendto" );
			exit( -1 );
		} // if
		len = recvfrom( s, (char *)&msg, sizeof(char), 0, NULL, NULL );
		if ( len == -1 ) {
			perror( "client recvfrom" );
			exit( -1 );
		} // if
	  if ( feof( stdin ) ) break;
		putc( msg, stdout );
    } // for
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "gcc -g client.c -o client -lsocket -lnsl" //
// End: //
