//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1999
// 
// ServerUNIX2.cc -- Server for UNIX/datagram socket test. Server reads data
// from multiple clients. The server reads the data from the client and writes
// it back.
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 30 16:36:18 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 24 12:16:25 1999
// Update Count     : 14
// 

#include <uC++.h>
#include <uSocket.h>
#include <uIOStream.h>

#define EOD '\377'
#define BufferSize (8 * 1024)

uTask reader {
    uSocketServer &server;

    void main() {
		uDuration timeout( 60, 0 );						// timeout for read
        char buf[BufferSize];
		int len;

		try {
			for ( ;; ) {
				int len = server.recvfrom( buf, sizeof(buf), 0, &timeout );
				// uCerr << uAcquire << "Server::reader read len:" << len << endl << uRelease;
				server.sendto( buf, len );				// write byte back to client
			} // for
		} catch( uSocketServer::uReadTimeout ) {
		} // try
    } // reader::main
  public:
    reader( uSocketServer &server ) : server( server ) {
    } // reader::reader
}; // reader

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " socket-name" << endl;
		uExit( -1 );
	} // switch

	uSocketServer server( argv[1], SOCK_DGRAM );		// create and bind a server socket
	{
		reader rd( server );							// execute until EOD
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerUNIX2.cc" //
// End: //
