//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// ServerINET.cc -- Server for INET/stream socket test. Server accepts multiple
// connections from clients. Each client then communicates with an acceptor.
// The acceptor reads the data from the client and writes it back.
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:40:22 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 24 12:14:07 1999
// Update Count     : 157
// 

#include <uC++.h>
#include <uSocket.h>
#include <uIOStream.h>

#define EOD '\377'
#define BufferSize (8 * 1024)

uTask server;											// forward declaration

uTask acceptor {
	uSocketServer &sockserver;
	server &s;

	void main();
  public:
	acceptor( uSocketServer &socks, server &s ) : sockserver( socks ), s( s ) {
	} // acceptor::acceptor
}; // acceptor

uTask server {
	uSocketServer &sockserver;
	acceptor *terminate;
	int acceptorCnt;
	bool timeout;
  public:
	server( uSocketServer &socks ) : sockserver( socks ), timeout( false ), acceptorCnt( 1 ) {
	} // server::server

	void connection() {
	} // server::connection

	void complete( acceptor *terminate, bool timeout ) {
		server::terminate = terminate;
		server::timeout = timeout;
	} // server::complete
  private:
	void main() {
		new acceptor( sockserver, *this );				// create initial acceptor
		for ( ;; ) {
			uAccept( connection ) {
				new acceptor( sockserver, *this );		// create new acceptor after a connection
				acceptorCnt += 1;
			} uOr uAccept( complete ) {					// acceptor has completed with client
				delete terminate;						// delete must appear here or deadlock
				acceptorCnt -= 1;
		  if ( acceptorCnt == 0 ) break;				// if no outstanding connections, stop
				if ( timeout ) {
					new acceptor( sockserver, *this );	// create new acceptor after a timeout
					acceptorCnt += 1;
				} // if
			}; // uAccept
		} // for
	} // server::main
}; // server

void acceptor::main() {
	try {
		uDuration timeout( 60, 0 );						// timeout for accept
		uSocketAccept acceptor( sockserver, &timeout );	// accept a connection from a client
		char buf[BufferSize];
		int len;

		s.connection();									// tell server about client connection
		for ( ;; ) {
			len = acceptor.read( buf, sizeof(buf) );	// read byte from client
			// uCerr << uAcquire << "Server::acceptor read len:" << len << endl << uRelease;
			acceptor.write( buf, len );					// write byte back to client
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[0] == EOD || buf[len - 1] == EOD ) break; // end of data ?
		} // for
		acceptor.read( buf, sizeof(char) );				// end of transmission
		s.complete( this, false );						// terminate
	} catch( uSocketAccept::uOpenTimeout ) {
		s.complete( this, true );						// terminate
	} // try
} // acceptor::main

void uMain::main() {
	switch ( argc ) {
	  case 1:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << endl;
		uExit( -1 );
	} // switch

	short unsigned int port;
	uSocketServer sockserver( &port );					// create and bind a server socket to free port

	uCout << port << endl;								// print out free port for clients
	{
		server s( sockserver );							// execute until acceptor times out
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerINET.cc" //
// End: //
