//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// File.cc -- Print multiple copies of the same file to standard output
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:44:56 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Nov 26 18:13:16 1995
// Update Count     : 32
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uFile.h>

uTask Copier {
	uFile &input;

	void main() {
		uFileAccess in( input, O_RDONLY );
		int count;
		char buf[1];

		for ( ;; ) {									// copy in-file to out-file
			count = in.read( buf, sizeof( buf ) );
		  if ( count == 0 ) break;						// eof ?
			uCout << buf[0];
		} // for
	} // Copier::main
  public:
	Copier( uFile &in ) : input( in ) {
	} // Copier::Copier
}; // Copier

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " input-file" << endl;
		uExit( -1 );
	} // switch

	uFile input( argv[1] );								// connect with UNIX files
	{
		Copier c1( input ), c2( input );
	}
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ File.cc" //
// End: //
