//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1999
// 
// ClientINET2.cc -- Client for INET/datagram socket test. Client reads from
// standard input, writes the data to the server, reads the data from the
// server, and writes that data to standard output.
// 
// Author           : Peter A. Buhr
// Created On       : Thu Apr 29 16:04:50 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 24 12:10:27 1999
// Update Count     : 30
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uSocket.h>

#define EOD '\377'
// minimum buffer size is 2, 1 character and string terminator, '\0'
#define BufferSize (8 * 1024)

int rcnt = 0, wcnt = 0;

uTask reader {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];
		int len;

		for ( ;; ) {
			len = client.recvfrom( buf, sizeof(buf) );
			// uCerr << uAcquire << "Client::reader read len:" << len << endl << uRelease;
		  if ( buf[0] == EOD ) break;
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[len - 1] == EOD ) { rcnt += len - 1; uCout.write( buf, len - 1 ); break; }
			rcnt += len;
			uCout.write( buf, len );
		} // for
		// connection not closed until after this data received
		buf[0] = '\0';
		client.sendto( buf, sizeof(char) );
	} // reader::main
  public:
	reader( uSocketClient &client ) : client ( client ) {
	} // reader::reader
}; // reader

uTask writer {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];

		for ( ;; ) {
			uCin.get( buf, sizeof(buf), '\0' );	// leave room for string terminator
			int len = strlen( buf );
			// uCerr << uAcquire << "Client::writer read len:" << len << endl << uRelease;
		  if ( buf[0] == '\0' ) break;
			wcnt += len;
			client.sendto( buf, len );
		} // for
		buf[0] = EOD;
		client.sendto( buf, sizeof(char) );
	} // writer::main
  public:
	writer( uSocketClient &client ) : client( client ) {
	} // writer::writer
}; // writer

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " port-number" << endl;
		uExit( -1 );
	} // switch

	uSocketClient client( atoi( argv[1] ), SOCK_DGRAM ); // connection to server
	{
		reader rd( client );				// emit worker to read from server and write to output
		writer wr( client );				// emit worker to read from input and write to server
	}
	if ( wcnt != rcnt ) {
		uAbort( "not all data transfered\n" );
	} // if
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Client ClientINET2.cc" //
// End: //
