//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// Filter.cc -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Mon Jun  3 10:17:16 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Sep 28 14:22:42 1994
// Update Count     : 29
// 

#include <uC++.h>
#include <uFStream.h>
#include <ctype.h>

static const int blank = ' ';
static const char EOD = '\377';

uCoroutine filter {					// abstract class for all filters
  protected:
    char ch;
  public:
    void put( char c ) {
	ch = c;
	uResume;
    } // filter::put
}; // filter

uCoroutine reader : public filter {
  private:
    uIStream *in;
    filter *next;
  private:
    void main();
  public:
    reader( uIStream *i, filter *n ) {
	in = i;
	next = n;
	uResume;
    } // reader::reader
}; // reader

void reader::main() {
    for ( ;; ) {
	*in >> ch;
	if ( in->eof() ) ch = EOD;
	next->put( ch );
      if ( ch == EOD ) break;
    } // for
} // reader::main

uCoroutine writer : public filter {
  private:
    uOStream *out;
  private:
    void main();
  public:
    writer( uOStream *o ) {
	out = o;
    } // writer::writer
}; // writer

void writer::main() {
    for ( ;; ) {
      if ( ch == EOD ) break;
	*out << ch;
	uSuspend;
    } // for
} // writer::main

uCoroutine eliminate_white_space : public filter {
  private:
    filter *next;
  private:
    void main();
  public:
    eliminate_white_space( filter *n ) {
	next = n;
    } // eliminate_white_space::eliminate_white_space
}; // eliminate_white_space

void eliminate_white_space::main() {
    for ( ;; ) {
	
	// skip the leading blanks
	
	while ( ch == blank ) {
	    uSuspend;
	} // for

	// pass along all non-blank chararacters

	for ( ;; ) {
	    next->put( ch );
	    uSuspend;
	  if ( ch == blank ) break;
	  if ( ch == EOD ) break;
	} // for

      if ( ch == EOD ) break;
	
	// if we encounter a blank, keep eating them until we hit a non-blank character.
	// if we hit a new line, swallow the blank.

	while ( ch == blank ) {
	    uSuspend;
	} // while

	// process the next non-blank character
	
      if ( ch == EOD ) {
	    next->put( ch );
	    break;
	} // exit

	if ( ch == '\n' ) {
	    next->put( ch );
	} else {
	    next->put( blank );
	    next->put( ch );
	} // if

	uSuspend;
	
    } // for
} // eliminate_white_space::main

uCoroutine expand_tab : public filter {
  private:
    int space;
    filter *next;
  private:
    void main();
  public:
    expand_tab( int s, filter *n ) {
	space = s;
	next = n;
    } // expand_tab::expand_tab
}; // expand_tab

void expand_tab::main() {

    int column = 0;
    
    for ( ;; ) {
      if ( ch == EOD ) {
	    next->put( ch );
	    break;
	} // exit

	if ( ch == '\n' ) {
	    column = 0;
	    next->put( ch );
	    uSuspend;
	} else if ( ch == '\t' ) {
	    if ( space != 0 ) {
		ch = blank;
		
		// if you are in the right column for a tab, just pass
		// the character to the next routine, otherwise pass a
		// blank to the next routine until you reach a tab column.

		if ( column % space == 0 ) {
		    next->put( ch );
		    column += 1;
		} // if
		
		for ( ; column % space != 0; column += 1 ) {
		    next->put( ch );
		} // for
	    } // if
	    uSuspend;
	} else {
	    next->put( ch );
	    column += 1;
	    uSuspend;
	} // if
    } // for
} // expand_tab::main

uCoroutine convert_to_hex : public filter {
  private:
    filter *next;
    int many;
  private:
    void main();
  public:
    convert_to_hex( filter *n, int m ) {
	next = n;
	many = m;
    } // convert_to_hex::convert_to_hex
}; // convert_to_hex

void convert_to_hex::main() {
    const char *s = "0123456789abcdef";
    
    for ( ;; ) {
	for ( int i = 0; i < many; i += 1 ) {
	  if ( ch == EOD ) {
		next->put( '\n' );
		next->put( ch );
		break;
	    } // exit
	    next->put( s[(ch & 0xf0) >> 4] );
	    next->put( s[(ch & 0x0f)] );
	    next->put( blank );
	    uSuspend;
	} // for
      if ( ch == EOD ) break;
	next->put( '\n' );
    } // for
} // convert_to_hex::main

uCoroutine scramble : public filter {
  private:
    filter *next;
    char *key;
  private:
    void main();
  public:
    scramble( filter *n, char *k ) {
	next = n;
	key = k;
    } // scramble::scramble
}; // scramble
    
void scramble::main() {
    for ( ;; ) {
	for ( char *p = key; *p != 0; p += 1 ) {
	  if ( ch == EOD ) {
		next->put( ch );
		break;
	    } // if
	    next->put( ch ^ *p );
	    uSuspend;
	} // for
      if ( ch == EOD ) break;
    } // for
} // scramble::main

uCoroutine reverse : public filter {
  private:
    filter *next;
  private:
    void main();
  public:
    reverse( filter *n ) {
	next = n;
    } // reverse::reverse
}; // reverse

void reverse::main() {
    for ( ;; ) {
      if ( ch == EOD ) break;
	if ( islower( ch ) ) {
	    next->put( toupper( ch ) );
	} else if ( isupper( ch ) ) {
	    next->put( tolower( ch ) );
	} else {
	    next->put( ch );
	} // if
	uSuspend;
    } // for
} // reverse::main

void uMain::main() {
    filter *fa[argc];

    uCin.unsetf( ios::skipws );				// turn off white space skipping
    
    writer w( &uCout );

    filter *next = &w;

    for ( int i = argc - 1; i != 0; i -= 1 ) {
	fa[i] = NULL;
	if ( argv[i][0] == '-' ) {
	    switch ( argv[i][1] ) {
	      case 'w':
		fa[i] = next = new eliminate_white_space( next );
		break;
	    case 't':
		fa[i] = next = new expand_tab( atoi( argv[i+1] ), next );
		break;
	    case 'h':
		fa[i] = next = new convert_to_hex( next, atoi( argv[i+1] ) );
		break;
	    case 'e':
		fa[i] = next = new scramble( next, argv[i+1] );
		break;
	    case 'r':
		fa[i] = next = new reverse( next );
		break;
	      default:
		uCerr << argv[0] << ": unrecognized option: " << argv[i] << endl;
		break;
	    } // switch
	} // if
    } // for

    reader r( &uCin, next );
    
    for ( i = argc - 1; i != 0; i -= 1 ) {
	if ( fa[i] != NULL ) delete fa[i];
    } // for
} // uMain::main

// Local Variables: //
// compile-command: "u++ Filter.cc" //
// End: //
