//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// FibPar.cc -- Produce the fibonacci numbers in sequence on each call.
//
//  No explicit states, communication with argument-parameter
//  mechanism between suspend and resume
//
//  Demonstrate multiple instances of the same coroutine.
//
//  Accessiable by multiple threads
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:55:37 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul  4 20:12:12 1996
// Update Count     : 80
// 

#include <uC++.h>
#include <uIOStream.h>
#include <unistd.h>					// prototype: getpid


uMutex uCoroutine fibonacci {
    int fn, fn1, fn2;

    void main() {
	fn = 1;						// 1st case
	fn1 = fn;
	uSuspend;
	fn = 1;						// 2nd case
	fn2 = fn1;
	fn1 = fn;
	uSuspend;
	for ( ;; ) {					// general case
	    fn = fn1 + fn2;
	    fn2 = fn1;
	    fn1 = fn;
	    uSuspend;
	} // for
    } // fibonacci::main
  public:
    int next() {
	uResume;
	return fn;
    } // fibonacci::next
}; // fibonacci

uTask Worker {
    fibonacci &f1, &f2;
    int n1, n2;
    
    void main() {
	uYield( rand() % 10 );
	n1 = f1.next();
	uYield( rand() % 10 );
	n2 = f2.next();
	uCout << uAcquire << "task " << &uThisTask() << " " << n1 << " " << n2 << endl << uRelease;
    } // Worker::main
  public:
    Worker( fibonacci &f1, fibonacci &f2 ) : f1( f1 ), f2( f2 ) {
    } // Worker::Worker
}; // Worker

void uMain::main() {
    const int NoOfWorkers = 10;
    fibonacci f1, f2;					// create fibonacci generator

    srand( getpid() );
    uCout << "Fibonacci Numbers" << endl;

    Worker *workers[NoOfWorkers];
    int i;

    for ( i = 0; i < NoOfWorkers; i += 1 ) {
	workers[i] = new Worker( f1, f2 );
    } // for
    for ( i = 0; i < NoOfWorkers; i += 1 ) {
	delete workers[i];
    } // for

    uCout << uAcquire << "successful completion" << endl << uRelease;
} // uMain::main

// Local Variables: //
// compile-command: "u++ FibPar.cc" //
// End: //
