//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// BinaryInsertionSort.cc -- Binary Insertion Sort, semi-coroutines
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:53:37 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan 14 22:25:13 1998
// Update Count     : 53
// 

#include <uC++.h>
#include <uIOStream.h>


uCoroutine BinarySort {
  private:
	int in, out;
	void main();
  public:
	void input( int );
	int output();
}; // BinarySort

void BinarySort::main() {
	int pivot;

	pivot = in;											// first value is the pivot value
	if ( pivot == -1 ) {								// no data values
		uSuspend;										// acknowledge end of input
		out = -1;
		return;											// terminate output
	} // if

	BinarySort less, greater;							// create siblings

	for ( ;; ) {
		uSuspend;										// get more input
	  if ( in == -1 ) break;
		if ( in <= pivot ) {							// direct value along appropriate branch
			less.input( in );
		} else {
			greater.input( in );
		} // if
	} // for

	less.input( -1 );									// terminate input
	greater.input( -1 );								// terminate input
	uSuspend;											// acknowledge end of input

	// return sorted values

	for ( ;; ) {
		out = less.output();							// retrieve the smaller values
	  if ( out == -1 ) break;							// no more smaller values ?
		uSuspend;										// return smaller values
	} // for

	out = pivot;
	uSuspend;											// return the pivot

	for ( ;; ) {
		out = greater.output();							// retrieve the larger values
	  if ( out == -1 ) break;							// no more larger values ?
		uSuspend;										// return larger values
	} // for

	out = -1;
	return;												// terminate output
} // BinarySort::main

void BinarySort::input( int val ) {
	in = val;
	uResume;
} // BinarySort::input

int BinarySort::output() {
	uResume;
	return out;
} // BinarySort::output

void uMain::main() {
	const int NoOfValues = 40;
	BinarySort bs;
	int value;
	int i;
	
	// sort values

	uCout << "unsorted values:" << endl;
	for ( i = 1; i <= NoOfValues; i += 1 ) {
		value = rand() % 100;
		uCout << value << " ";
		bs.input( value );
	} // for
	uCout << endl;
	bs.input( -1 );

	// retrieve sorted values

	uCout << "sorted values:" << endl;
	for ( ;; ) {
		value = bs.output();							// retrieve values
	  if ( value == -1 ) break;							// no more values ?
		uCout << value << " ";							// print values
	} // for
	uCout << endl;
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ BinaryInsertionSort.cc" //
// End: //
