#include <uC++.h>
#include <uOStream.h>

uRaiseEvent R1 {
  public:
	int &i; char &c;
	R1( int &i, char &c ) : i( i ), c( c ) {}
};
uInitEvent(R1);

uRaiseEvent R2 {};
uInitEvent(R2);

void f( int x, char y ) {
	uCout << uAcquire << "enter f, x:" << x << " y:" << y << uRelease << endl;
	uRaise R2();
	uCout << uAcquire << "exit f, x:" << x << " y:" << y << uRelease << endl;
}
void g( int &x, char &y ) {
	uCout << uAcquire << "enter g, x:" << x << " y:" << y << uRelease << endl;
	uRaise R1( x, y );
	uCout << uAcquire << "exit g, x:" << x << " y:" << y << uRelease << endl;
}

struct args : public uAEHM::uClosure {
	int &i; char &c;
	args( int &i, char &c ) : i( i ), c( c ) {}
};

void rtn1( R1 &r ) {
	uCout << uAcquire << "rtn1" << uRelease << endl;
	r.i = 1; r.c = 'b';
}
void rtn2( R2 &r, args &a ) {
	uCout << uAcquire << "rtn2, a.i:" << a.i << " c:" << a.c << uRelease << endl;
	a.i = 2; a.c = 'c';
}

void uMain::main() {
	try <R1,rtn1> {
		int x = 0;
		char y = 'a';
		args a( x, y ); // closure for locals

		g( x, y );
		uCout << uAcquire << "try<R1,rtn1> x:" << x << " y:" << y << uRelease << endl;

		try <R2,rtn2,a> {
			f( x, y );
			uCout << uAcquire << "try<R2,rtn2,a>, x:" << x << " y:" << y << uRelease << endl;


		} // try
		try <R1> { // ignore R1
			g( x, y );
			uCout << uAcquire << "try<R1>, x:" << x << " y:" << y << uRelease << endl;

		} // try



	} // try
}

// Local Variables: //
// tab-width: 4 //
// End: //
