//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1997
// 
// AEHM1.cc -- testing abnormal event handling mechanism
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov 26 23:06:25 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Nov 27 17:59:46 1998
// Update Count     : 190
// 


#include <uC++.h>
#include <uIOStream.h>


//######################### uBaseCoroutine::uTerminated (uResume) #########################


uCoroutine CoroutineDummy1 {
    void main() {
    } // CoroutineDummy1::main
  public:
    mem() { uResume; }
}; // CoroutineDummy1


//######################### uBaseCoroutine::uTerminated (uSuspend) #########################


uCoroutine CoroutineDummy3;				// forward declaration

uCoroutine CoroutineDummy2 {
    CoroutineDummy3 &c3;

    void main();
  public:
    CoroutineDummy2( CoroutineDummy3 &c3 ) : c3( c3 ) {}
    mem() { uResume; }
}; // CoroutineDummy2

uCoroutine CoroutineDummy3 {
    CoroutineDummy2 c2;

    void main();
  public:
    CoroutineDummy3() : c2( *this ) {}
    mem() { uResume; }
}; // CoroutineDummy3

void CoroutineDummy2::main() {
    c3.mem();						// restart partner
} // CoroutineDummy2::main

void CoroutineDummy3::main() {
    c2.mem();						// become starter
    uSuspend;						// allow partner to terminate
    try {
	uSuspend;					// restart terminated partner
    } catch( uBaseCoroutine::uTerminated &evt ) {
	uCout << uAcquire << "handled event uBaseCoroutine::uTerminated : coroutine " << &(evt.uSrc()) << " (" << evt.uSrc().uGetName() << ") " << evt.uMsg() << " " << &(evt.uDst()) << " (" << evt.uGetName() << ")" << endl << endl << uRelease;
    } catch( ... ) {
	uAbort( "error" );
    } // try
} // CoroutineDummy3::main


//######################### uBaseCoroutine::uFailure #########################


uThrowEvent xxx {
  public:
    xxx( const char *const msg ) : uAEHM::uThrowClass( msg ) {}
};

uInitEvent(xxx);


uCoroutine CoroutineDummy4 {
    void main() {
	uThrow xxx( "test" );
    } // CoroutineDummy4::main
  public:
    mem() { uResume; }
}; // CoroutineDummy4


//######################### uCondition::uWaitingFailure #########################


uTask TaskDummy1 {
    uCondition x;
  public:
    mem() {
	uWait x;
    } // TaskDummy1::mem
  private:
    void main() {
	uAccept( mem );
    } // TaskDummy1::main
}; // TaskDummy1

uTask TaskDummy2 {
    TaskDummy1 &t1;

    void main() {
#if 0
	t1.mem();
#endif
	try {
	    t1.mem();
	} catch( uCondition::uWaitingFailure &evt ) {
	    uCout << uAcquire << "handled event uCondition::uWaitingFailure : task " << &(evt.uSrc()) << " (" << evt.uSrc().uGetName() << ") found blocked task" << " " << &uThisTask() << " (" << uThisTask().uGetName() << ") on condition variable " << evt.uConditionID() << endl << endl << uRelease;
	} // try
    } // TaskDummy2::main
  public:
    TaskDummy2( TaskDummy1 &t1 ) : t1( t1 ) {}
}; // TaskDummy2


//######################### uSerial::uRendezvousFailure #########################


uTask TaskDummy3 {
    uBaseTask &t;
  public:
    TaskDummy3( uBaseTask &t ) : t( t ) {}
    mem() {
    } // TaskDummy3::mem
  private:
    void main() {
	uThrow xxx( "test" ) uAt t;
#if 0
	uAccept( mem );
#endif
	try {
	    uAccept( mem );
	} catch ( uSerial::uRendezvousFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uRendezvousFailure : accepted call fails from task " << &(evt.uSrc()) << " (" << evt.uSrcName() << ") to mutex member of task " << &uThisTask() << " (" << uThisTask().uGetName() << ")" << endl << endl << uRelease;
	} // try
    } // TaskDummy3::main
}; // TaskDummy3


//######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################


uTask TaskDummy4 {
    uCondition temp;
  public:
    mem() {
	uWait temp;
    } // TaskDummy4::mem
  private:
    void main() {
	uAccept( mem );					// let TaskDummy5 in so it can wait
	uSignal temp;					// put TaskDummy5 on A/S stack
	uAccept( ~TaskDummy4 );				// uMain is calling the destructor
    } // TaskDummy4::main
}; // TaskDummy4

uTask TaskDummy5 {
    TaskDummy4 &t4;
  public:
    TaskDummy5( TaskDummy4 &t4 ) : t4( t4 ) {}
  private:
    void main() {
#if 0
	t4.mem();
#endif
	try {
	    t4.mem();
	} catch( uSerial::uEntryFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uEntryFailure : while executing mutex destructor, task " << &(evt.uSrc()) << " (" << evt.uSrc().uGetName() << ") found task " << &uThisTask() << " (" << uThisTask().uGetName() << ") " << evt.uMsg() << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy5::main
}; // TaskDummy5


//######################### uSerial::uEntryFailure (entry queue) #########################


uTask TaskDummy6 {
  public:
    mem() {
    } // TaskDummy6::mem
  private:
    void main() {
	uAccept( ~TaskDummy6 );
    } // TaskDummy6::main
};

uTask TaskDummy7 {
    TaskDummy6 &t6;
  public:
    TaskDummy7( TaskDummy6 &t6 ) : t6( t6 ) {}
  private:
    void main() {
#if 0
	t6.mem();
#endif
	try {
	    t6.mem();
	} catch( uSerial::uEntryFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uEntryFailure : while executing mutex destructor, task " << &(evt.uSrc()) << " (" << evt.uSrc().uGetName() << ") found task " << &uThisTask() << " (" << uThisTask().uGetName() << ") " << evt.uMsg() << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy7::main
}; // TaskDummy7


void uMain::main() {
    //######################### uBaseCoroutine::uTerminated (uResume) #########################
    {
	CoroutineDummy1 dummy1;
#if 0
	dummy1.mem();					// first  call works
	dummy1.mem();					// second call fails
#endif
	try {
	    dummy1.mem();				// first  call works
	    dummy1.mem();				// second call fails
	} catch( uBaseCoroutine::uTerminated &evt ) {
	    uCout << uAcquire << "handled event uBaseCoroutine::uTerminated : coroutine " << &(evt.uSrc()) << " (" << evt.uSrc().uGetName() << ") " << evt.uMsg() << " " << &(evt.uDst()) << " (" << evt.uGetName() << ")" << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uBaseCoroutine::uTerminated (uSuspend) #########################
    {
	CoroutineDummy3 c3;
	c3.mem();
    }
    //######################### uBaseCoroutine::uFailure #########################
    {
	CoroutineDummy4 dummy4;
#if 0
	dummy4.mem();					// first call fails
#endif
	try {
	    dummy4.mem();				// first call fails
	} catch( uBaseCoroutine::uFailure &evt ) {
	    uCout << uAcquire << "handled event uBaseCoroutine::uFailure : " << evt.uMsg() << " coroutine " << &uThisCoroutine() << " (" << uThisCoroutine().uGetName() << ") from coroutine " << &(evt.uSrc()) << " (" << evt.uSrcName() << ")" << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uCondition::uWaitingFailure #########################

    TaskDummy1 *t1 = new TaskDummy1;
    TaskDummy2 *t2 = new TaskDummy2( *t1 );
    delete t1;						// delete t1 with t2 blocked on condition variable
    delete t2;

    //######################### uSerial::uRendezvousFailure #########################
    {
	TaskDummy3 t3( uThisTask() );
	uEnable {
	    try {
		t3.mem();
	    } catch( xxx &evt ) {
	    } catch( ... ) {
		uAbort( "error" );
	    } // try
	} // uEnable
    }
    //######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################

    TaskDummy4 *t4 = new TaskDummy4;
    TaskDummy5 *t5 = new TaskDummy5( *t4 );
    delete t4;
    delete t5;

    //######################### uSerial::uEntryFailure (entry queue) #########################

    TaskDummy6 *t6 = new TaskDummy6;
    TaskDummy7 *t7 = new TaskDummy7( *t6 );
    delete t6;
    delete t7;

    uCerr << "successful execution" << endl;
} // uMain::main
