//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Jun Shih 1995
// 
// uBConditionEval.h -- 
// 
// Author           : Jun Shih
// Created On       : Sat Nov 11 14:44:08 EST 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Oct 16 23:22:56 1997
// Update Count     : 16
// 

#ifndef _uBConditionEval_h_
#define _uBConditionEval_h_
#include <uDebuggerProtocolUnit.h>


class uBConditionEval : public uSeqable {
    friend uTask uLocalDebugger;
    struct BreakpointCondition bp_cond;
    ULThreadId ul_thread_id;
    
    int eval_int( int which );
    
    CodeAddress eval_address_local( int which );
    CodeAddress eval_address_static( int which );
    CodeAddress eval_address_const( int which );
    CodeAddress eval_address_register( int which );
  public:
    uBConditionEval( ULThreadId ul_thread_id );
    ~uBConditionEval();
    void setId( ULThreadId Id );
    ULThreadId getId();
    void setFp ( long fp_val );
    void setSp ( long sp_val );
    long getFp();
    long getSp();
    BreakpointCondition::OperationType getOperator();
    BreakpointCondition& getBp_cond();
    int evaluate();
}; // uBConditionEval


// This class is necessary to avoid circular #include's
class uBConditionList {
    uSequence<uBConditionEval> bp_list;
  public:
    uBConditionList();
    ~uBConditionList();
    uBConditionEval *search( ULThreadId ul_thread_id );
    void add( uBConditionEval* bc_eval );
    bool del( ULThreadId ul_thread_id );
}; // uBConditionList


#endif // _uBConditionEval_h_


// Local Variables: //
// compile-command: "dmake" //
// End: //
