//                              -*- Mode: C++ -*-
// 
// uC++ Version 4.7, Copyright (C) Martin Karsten 1995
// 
// LangBasics.h -- 
// 
// Author           : Martin Karsten
// Created On       : Sat May 13 14:55:53 1995
// Last Modified By : Martin Karsten
// Last Modified On : Mon Jun 12 18:30:40 1995
// Update Count     : 2
// 

#ifndef _LangBasics_h_
#define _LangBasics_h_ 1

#ifdef __U_CPLUSPLUS__
#include <uC++.h>

typedef	uBaseTask*		ULThreadId;
typedef	uCluster*		ClusterId;
typedef uProcessor*		KernelThreadId;

uTask ULThread;
class Cluster;
uMonitor KernelThread;

struct ULThreadDescriptor {
	ULThreadId	id;
	ULThread*	pointer;
	int operator != ( const ULThreadDescriptor& x ) {
		return x.id != id;
	} // operator !=
	ULThreadDescriptor( ULThreadId id, ULThread* p ) : id(id), pointer(p) {}
	ULThreadDescriptor( ULThreadId id ) : id(id), pointer(NULL) {}
	ULThreadDescriptor();
}; // struct ULThreadDescriptor

inline int operator != ( const ULThreadDescriptor& x, const ULThreadDescriptor& y ) {
	return x.id != y.id;
} // operator !=

struct ClusterDescriptor {
	ClusterId	id;
	Cluster*	pointer;
	int operator != ( const ClusterDescriptor& x ) {
		return x.id != id;
	} // operator !=
	ClusterDescriptor( ClusterId id, Cluster* p ) : id(id), pointer(p) {}
	ClusterDescriptor( ClusterId id ) : id(id), pointer(NULL) {}
	ClusterDescriptor();
}; // struct ClusterDescriptor

inline int operator != ( const ClusterDescriptor& x, const ClusterDescriptor& y ) {
	return x.id != y.id;
} // operator !=

struct KernelThreadDescriptor {
	KernelThreadId	id;
	KernelThread*	pointer;
	int operator != ( const KernelThreadDescriptor& x ) {
		return x.id != id;
	} // operator !=
	KernelThreadDescriptor( KernelThreadId id, KernelThread* p ) : id(id), pointer(p) {}
	KernelThreadDescriptor( KernelThreadId id ) : id(id), pointer(NULL) {}
	KernelThreadDescriptor();
}; // struct KernelThreadDescriptor

inline int operator != ( const KernelThreadDescriptor& x, const KernelThreadDescriptor& y ) {
	return x.id != y.id;
} // operator !=

#endif /* __U_CPLUSPLUS__ */

#endif /* _LangBasics_h_ */


// Local Variables: //
// tab-width: 4 //
// End: //
