//                              -*- Mode: C++ -*-
// 
// uC++ Version 4.7, Copyright (C) Martin Karsten 1995
// 
// ArchBasics.h -- 
// 
// Author           : Martin Karsten
// Created On       : Sat May 13 14:54:59 1995
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Oct 25 11:57:03 1996
// Update Count     : 7
// 

#ifndef _ArchBasics_h_
#define _ArchBasics_h_ 1

#if defined( sparc ) && defined( __svr4__ ) /* Solaris 2.x */

#include <sys/procfs.h>

typedef long*			CodeAddress;
typedef long			Instruction;
typedef	long*			DataAddress;
typedef long			DataField;
typedef	char*			InternalAddress;
typedef unsigned long	CalcAddress;
typedef	prgreg_t		Register;

// this is the minimal set of registers needed to reconstruct a frame backtrace
struct MinimalRegisterSet {
	Register	sp;
	Register	fp;
	Register	pc;
}; // struct MinimalRegisterSet

// I don't want to use a function call in any case, hence this is a macro
#define CREATE_MINIMAL_REGISTER_SET(regs)\
	asm(" st %%sp,%0" : "=m" (regs.sp) : );\
	asm(" st %%fp,%0" : "=m" (regs.fp) : );\
	asm(" st %%i7,%0" : "=m" (regs.pc) : );

#elif defined( sparc )	/* SunOS 4.1 */

#include <machine/reg.h>

typedef long*			CodeAddress;
typedef long			Instruction;
typedef	long*			DataAddress;
typedef long			DataField;
typedef	char*			InternalAddress;
typedef unsigned long	CalcAddress;
typedef	int				Register;

// This is kind of a hack. Usually only 19 registers are supported,
// but I just extend it to also store the FP register at the last position
typedef int				prgregset_t[20];
typedef int				prgreg_t;

#define R_SP    O6
#define R_PC    PC
#define R_nPC   nPC
#define R_Y     Y
#define R_FP	19

// this is the minimal set of registers needed to reconstruct a frame backtrace
struct MinimalRegisterSet {
	Register	sp;
	Register	fp;
	Register	pc;
}; // struct MinimalRegisterSet

// I don't want to use a function call in any case, hence this is a macro
#define CREATE_MINIMAL_REGISTER_SET(regs)\
	asm(" st %%sp,%0" : "=m" (regs.sp) : );\
	asm(" st %%fp,%0" : "=m" (regs.fp) : );\
	asm(" st %%i7,%0" : "=m" (regs.pc) : );

#elif defined(__linux__)
#include <sys/ptrace.h>
#define NUM_REGS 16			// from gdb/config/i386/tm-i386v.h
typedef int				prgregset_t[NUM_REGS+1]; // to hold ORIG_EAX
typedef int				prgreg_t;
#define R_SP  UESP				/* Contains address of top of stack */
#define R_PC  EIP
#define R_FP  EBP				/* Contains address of executing stack frame */

typedef long*		CodeAddress;
typedef char		Instruction;
typedef long*		DataAddress;
typedef long		DataField;
typedef int			Register;
typedef char*		InternalAddress;

struct MinimalRegisterSet {
	Register	sp;
	Register	fp;
	Register	pc;
}; // struct MinimalRegisterSet

#define CREATE_MINIMAL_REGISTER_SET(regs)\
	asm(" movl %%esp,%0" : "=m" (regs.sp) : );\
	asm(" movl %%ebp,%0" : "=m" (regs.fp) : );\
	asm(" movl 4(%ebp),%eax");\
	asm(" movl %%eax,%0" : "=m" (regs.pc) : );

#else /* any not supported architecture */

typedef long*		CodeAddress;
typedef long		Instruction;
typedef long*		DataAddress;
typedef long		DataField;
typedef int			Register;
typedef char*		InternalAddress;

struct MinimalRegisterSet {
	Register	sp;
	Register	fp;
	Register	pc;
}; // struct MinimalRegisterSet

#define CREATE_MINIMAL_REGISTER_SET(regs)\
	regs.sp = 0;\
	regs.fp = 0;\
	regs.pc = 0;

#endif /* sparc && __svr4__ */

// once for all
#if defined( __svr4__ ) || defined( __linux__ )
#include <string.h>
#else
extern "C" bcopy( char*, char*, int );
extern "C" bzero( char*, int );
extern "C" bcmp( char*, char*, int );
#endif

// same for all UNIXs ?
typedef	int			OSKernelThreadId;

#endif /* _ArchBasics_h_ */




// Local Variables: //
// tab-width: 4 //
// End: //
