//                              -*- Mode: C++ -*- 
// 
// Copyright (C) Glen Ditchfield 1994
// 
// uStack.h -- 
// 
// Author           : Peter Buhr
// Created On       : Sun Feb 13 19:35:33 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Feb  6 21:22:50 1995
// Update Count     : 37
// 

#ifndef __U_STACK_H__
#define __U_STACK_H__


#include "uCollection.h"

// A uStack<T> is a uCollection<T> that defines an ordering among the elements:
// they are returned by uDrop() in the reverse order that they are added by
// uAdd().

// The implementation is a typical singly-linked list, except that uStack
// maintains uColable's invariant by having the next field of the last element
// of the list point to itself instead of being null.

template<class T> class uStack: public uCollection<T> {
  protected:
    uStack(const uStack&);				// no copy
    uStack &operator=(const uStack&);			// no assignment
  public:
    uStack() : uCollection<T>() {};			// post: isEmpty().
    T *uTop() const {
	return uHead();
    }
    void uAdd(T *n) {
#ifdef __U_DEBUG__
	if ( n->uListed() ) uAbort( "(uStack *)0x%p.uAdd( 0x%p ) node is already on another list.", this, n );
#endif __U_DEBUG__
	uNext(n) = root ? root : n;
	root = n;
    }
    void uPush(T *n) {
	uAdd( n );
    }
    T *uDrop() {
	T *_t = root;
	if (root) {
	    root = (T *)uNext(root);
	    if (root == _t) root = 0;			// There was only one element.
	    uNext(_t) = 0;
	};
	return _t;
    }
    T *uPop() {
	return uDrop();
    }
};


// A uStackGen<T> is a subclass of uColGen<T> that generates the elements of a
// uStack<T>.  It returns the elements in the order that they would be returned
// by uDrop().

template<class T> class uStackGen : public uColGen<T> {
  public:
    uStackGen() : uColGen<T>() {};			// post: elts = null.
    // Create a generator active in stack s.
    uStackGen(const uStack<T> &s) {
	curr = s.uHead();
    }
    // Make the generator active in stack s.
    void uOver(const uStack<T> &s) {			// post: elts = {e in s}.
	curr = s.uHead();
    }
    bool operator>>(T *&tp) {
	if (curr) {
	    tp = curr;
	    T *n = (T *)uNext(curr);
	    curr = (n == curr) ? 0 : n;
	}
	else tp = 0;
	return tp != 0;
    }
};


#endif __U_STACK_H__
