//                              -*- Mode: C++ -*- 
// 
// Copyright (C) Glen Ditchfield 1994
// 
// uQueue.h -- 
// 
// Author           : Glen Ditchfield
// Created On       : Sun Feb 13 17:35:59 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Feb  6 21:22:08 1995
// Update Count     : 39
// 


#ifndef __U_QUEUE_H__
#define __U_QUEUE_H__


#include "uCollection.h"

// A uQueue<T> is a uCollection<T> that defines an ordering among the elements:
// they are returned by uDrop() in the same order that they are added by uAdd().

// The implementation is a typical singly-linked list, except that uQueue
// maintains uColable's invariant by having the next field of the last element
// of the list point to itself instead of being null.

template<class T> class uQueue : public uCollection<T> {
  protected:
    T *last;						// Last element, or 0 if queue is empty.

    uQueue(const uQueue &);				// no copy
    uQueue &operator=(const uQueue &);			// no assignment
  public:
    uQueue() {						// post: isEmpty().
	last = 0;
    }
    T *uTail() const {
	return last;
    }
    void uAdd(T *n) {
#ifdef __U_DEBUG__
	if ( n->uListed() ) uAbort( "(uQueue *)0x%p.uAdd( 0x%p ) node is already on another list.", this, n );
#endif __U_DEBUG__
	if (last) uNext(last) = n;
	else root = n;
	last = n;
	uNext(n) = n;					// last node points to itself
    }
    T *uDrop() {
	T *t = root;
	if (root) {
	    root = (T *)uNext(root);
	    if (root == t) {
		root = 0;				// There was only one element.
		last = 0;
	    };
	    uNext(t) = 0;
	};
	return t;
    }
};


// A uQueueGen<T> is a subclass of uColGen<T> that generates the elements of a
// uQueue<T>.  It returns the elements in the order that they would be returned
// by uDrop().

template<class T> class uQueueGen : public uColGen<T> {
  public:
    uQueueGen():uColGen<T>() {}				// post: elts = null.
    // Create an generator active in queue q.
    uQueueGen(const uQueue<T> &q) {			// post: elts = {e in q}.
	curr = q.uHead();
    }
    // Make the generator active in queue q.
    void uOver(const uQueue<T> &q) {			// post: elts = {e in q}.
	curr = q.uHead();
    }
    bool operator>>(T *&tp) {
	if (curr) {
	    tp = curr;
	    T *n = (T *)uNext(curr);
	    curr = (n == curr) ? 0 : n;
	}
	else tp = 0;
	return tp != 0;
    }
};


#endif __U_QUEUE_H__
