//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr 1993
// 
// uBoundedBuffer.h -- Generic bounded buffer problem using a monitor and uAccept
// 
// Author           : Peter A. Buhr
// Created On       : Sun Apr  4 10:20:32 1993
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 31 22:25:36 1994
// Update Count     : 4
// 

#include <uC++.h>

template<class ELEMTYPE> uMonitor uBoundedBuffer {
  protected:
    const int size;					// number of buffer elements
    int front, back;					// position of front and back of queue
    int count;						// number of used elements in the queue
    ELEMTYPE *Elements;
  public:
    uBoundedBuffer( const int size = 10 ) : size( size ) {
        front = back = count = 0;
        Elements = new ELEMTYPE[size];
    } // uBoundedBuffer::uBoundedBuffer

    ~uBoundedBuffer() {
        delete [] Elements;
    } // uBoundedBuffer::~uBoundedBuffer

    uNoMutex int query() {
        return count;
    } // uBoundedBuffer::query

    void insert( ELEMTYPE elem );
    ELEMTYPE remove();
}; // uBoundedBuffer

template<class ELEMTYPE> inline void uBoundedBuffer<ELEMTYPE>::insert( ELEMTYPE elem ) {
    if ( count == size ) {				// buffer full ?
        uAccept( remove );				// only allow removals
    } // if

    Elements[back] = elem;
    back = ( back + 1 ) % size;
    count += 1;
} // uBoundedBuffer::insert

template<class ELEMTYPE> inline ELEMTYPE uBoundedBuffer<ELEMTYPE>::remove() {
    ELEMTYPE elem;

    if ( count == 0 ) {					// buffer empty ?
        uAccept( insert );				// only allow insertions
    } // if

    elem = Elements[front];
    front = ( front + 1 ) % size;
    count -= 1;

    return( elem );
} // uBoundedBuffer::remove

// Local Variables: //
// compile-command: "dmake" //
// End: //
