//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// FlexArray.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov 25 07:50:19 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Nov 23 17:51:45 1994
// Update Count     : 41
// 

#ifndef __FLEXARRAY_H__
#define __FLEXARRAY_H__

#include <memory.h>
#include <stdlib.h>

template<class T> class FlexArray {
    int NoOfElems, MaxNoOfElems;
    T *elems;
    void init( int max ) {
	MaxNoOfElems = max;
	elems = new T[MaxNoOfElems];
    } // FlexArray::init
  public:
    FlexArray( const int max = 20 ) {
	init( max );
	NoOfElems = 0;
    } // FlexArray::FlexArray

    FlexArray( const FlexArray &rhs ) {
	init( rhs.MaxNoOfElems );
#ifdef __svr4__
	memcpy( elems, rhs.elems, sizeof(T) * rhs.NoOfElems ); // copy old data to new array
#else
	bcopy( rhs.elems, elems, sizeof(T) * rhs.NoOfElems ); // copy old data to new array
#endif __svr4__
	NoOfElems = rhs.NoOfElems;
    } // FlexArray::FlexArray
    
    FlexArray &operator=( const FlexArray &rhs ) {
	if ( this != &rhs ) {				// x = x ?
	    delete elems;
	    init( rhs.MaxNoOfElems );
#ifdef __svr4__
	    memcpy( elems, rhs.elems, sizeof(T) * rhs.NoOfElems ); // copy old data to new array
#else
	    bcopy( rhs.elems, elems, sizeof(T) * rhs.NoOfElems ); // copy old data to new array
#endif __svr4__
	    NoOfElems = rhs.NoOfElems;
	} // if
	return *this;
    } // FlexArray::operator=
    
    int size() {
	return NoOfElems;
    } // FlexArray::size

    T &operator[]( int pos ) {
	if ( 0 <= pos && pos < NoOfElems ) {		// in range ?
	    return elems[pos];
	} else {
	    uAbort( "FlexArray::[], attempt to subscript an element at position %d in an array of size 0 to %d", pos, NoOfElems - 1 );
	} // if
    } // FlexArray::operator[]
    
    void add( T elem ) {
	if ( NoOfElems == MaxNoOfElems ) {
	    int tempMaxNoOfElems = MaxNoOfElems + MaxNoOfElems;
	    T *temp = new T[tempMaxNoOfElems];
#ifdef __svr4__
	    memcpy( temp, elems, sizeof(T) * MaxNoOfElems ); // copy old data to new array
#else
	    bcopy( elems, temp, sizeof(T) * MaxNoOfElems ); // copy old data to new array
#endif __svr4__
	    delete elems;
	    MaxNoOfElems = tempMaxNoOfElems;
	    elems = temp;
	} // if
	elems[NoOfElems] = elem;
	NoOfElems += 1;
    } // FlexArray::add
    
    void remove( int pos ) {
	if ( 0 <= pos && pos < NoOfElems ) {		// in range ?
	    for ( int i = pos; i < NoOfElems - 1; i += 1 ) { // shuffle values down
		elems[i] = elems[i + 1];
	    } // for
	    NoOfElems -= 1;
	} else {
	    uAbort( "FlexArray::remove, attempt to remove an element at position %d in an array of size 0 to %d", pos, NoOfElems - 1 );
	} // if
    } // FlexArray::remove
};

#endif __FLEXARRAY_H__
