#ifndef Receiver_H
#define Receiver_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   sender.h
class name      :   Sender
author          :   Andreas Rinkel

documentation   :   describes a process that sends messages
                    and comsumes virtual process time

version         :   1.0, 09.09.94
history         :   19.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <strstrea.h>

// TOOPS library
#include <procunit.h>
#include <message.h>
#include <toops.h>

// TOOPS Utilities (string class library)
#include <str.h>
// Note: str.h contains "String", a dynamic string class 
//       (written by Scott Robert Ladd).
//       It is contained in the "utility"-path of the TOOPS-Distribution. 

// Project header
#include "comproc.h"
#include "msg.h"

// Class Description  ----------------------------------------------------
class Receiver : public ComProcess
{

public:

    Receiver (ToopsProcessor *p, const char *name)
        : ComProcess (p, 1, name) {}

    ~Receiver () {}

    void writeProcessInfo (char* text=0);

    virtual void behavior(void);

private:

    // intermediate storage variable for the content of the 
    // message received
    String     _out;
};

//------------------------------------------------------------------------------------------
#endif

