/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   receiver.cpp
implementation
of class        :   Receiver
author          :   Andreas Rinkel
version         :   1.0, 09.09.94
history         :   19.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>

// Project header
#include "receiver.h"
#include "msg.h"


//------------------------------------------------------------------------
void Receiver::behavior ()
{ 
    // TextMessage is a child class of ToopsMessage.
    // (see file msg.h)
    TextMessage *msg;

    while (1)
    {
        // Check the socket for messages.
        // receive() returns the first ToopsMessage in the queue of received 
        // ToopsMessages if there is one.
        // If no ToopsMessage is in the queue, the ToopsProcess (owner) will 
        // wait until:
        // - a ToopsMessage arrives at this ToopsSocket (will be returned) or
        // - a ToopsTimer wakes the ToopsProcess up (0 will be returned)
        // The ToopsMessage will be removed from the queue (like get() does).
        msg  = (TextMessage*) _socket->receive();

        // Generate a string that will be sent to stdout.
        // Important: getText() as defined in msg.h only returns a reference 
        // to the string stored in msg.
        _out  = " Message received: ";
        _out += msg->getText();
        _out += "\n";
        
        // Deallocate the message received. Do not forget!
        delete msg;

        // Write info and the message's content to stdout.
        writeProcessInfo ();
        cout << _out << endl;
    }
}

//------------------------------------------------------------------------
void Receiver:: writeProcessInfo (char* text)
{
    cout <<  name()  << " is running, "
         << "current time: " << time()  << "\n" << flush;
    if (text != 0) { cout << text << "\n\n" << flush; }
}

