/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name:      Parallel.cpp

documentation:  Tutorial tut3 describes two processes exchanging simple
                text messages to demonstrate the interprocess communication
                features of TOOPS.

author:         Andreas Rinkel
version      :  1.0, 09.09.94
history      :  19.04.96  Manfred Kraess
                clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <iostream.h>
#include <strstrea.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>
#include <socket.h>
#include <channel.h>
#include <procunit.h>

// Project header
#include "sender.h"
#include "receiver.h"

//------------------------------------------------------------------------
int main()
{
    simtime duration = 16;

    // create 2 CPUs
    ToopsProcessor sender_CPU( "sender_cpu" );
    ToopsProcessor receiver_CPU( "receiver_cpu" );

    // create the processes
    // Sender and Receiver are defined in sender.h and receiver.h, 
    // respectively. They are derived from ComProcess (comproc.h), 
    // which is a child class of ToopsProcess.
    Sender sender( &sender_CPU, "Sender" );
    Receiver receiver( &receiver_CPU, "Receiver" );

    // definition of the variable reason
    ToopsSimulation::stopReason reason;

    // Start of the simulation.
    // Upon completion of the simulation the status will be returned
    // in the variable reason.
    reason = ToopsSimulation::start( duration );

    // Output reporting the successful completion of the simulation.
    cout << "\n Simulation tut3 completed. Return value is: ";
    cout <<  (int)reason << "\n";

    return reason;
}
