/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   process.h
class name      :   Process
author          :   Andreas Rinkel

documentation   :   describes a simple process;
                    writes output describing the time progress to stdout
                    and comsumes virtual process time

version         :   1.0, 09.09.94
history         :   01.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/
#ifndef PROCESS_H
#define PROCESS_H

#include <tprocess.h>

// Class Description  ----------------------------------------------------
class Process : public ToopsProcess
{

public:
    // constructor
    Process( ToopsProcessor &processor, uint prio, const char *name  );
    // 2nd constructor with different parameter format (used in tut2!)
    Process( ToopsProcessor *processor, uint prio, const char *name  );
    // destructor
    ~Process();

    // behavior() is a virtual method declared in class ToopsProcess.
    // behavior() describes the execution flow of this process. It is the
    // equivalent of the main()-function in C/C++-programs and may contain
    // (almost) any C++-code (except for functions like setjmp(), longjmp(), 
    // ...). ToopsSimulation controls the execution of behavior().
    virtual void behavior(void);

    // writeProcessInfo() is a simple method, that just writes some process
    // info to stdout. It is called from behavior() as defined in 
    // process.cpp 
    void writeProcessInfo(void);

};

#endif

