/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   process.cpp
implementation
of class        :   Process
author          :   Andreas Rinkel

version         :   1.0, 09.09.94
history         :   01.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <assert.h>
#include <strstrea.h>

// TOOPS library
#include <toops.h>
#include <tprocess.h>

// Project header
#include "process.h"


//------------------------------------------------------------------------
Process:: Process( ToopsProcessor &processor, uint prio, const char *name )
    :  ToopsProcess( processor, prio, name )
{  
    // Definition of member objects
}

//------------------------------------------------------------------------
Process:: Process( ToopsProcessor *processor, uint prio, const char *name )
    :  ToopsProcess( processor, prio, name )
{  
    // Definition of member objects
}

//------------------------------------------------------------------------
Process:: ~Process( )
{  
    // Delete the member objects
}


//------------------------------------------------------------------------
void Process:: writeProcessInfo( void )
{
   cout << " Process " << name()  << " is running, "
        << "current time: " << time()  << " \n" << flush;
}


//------------------------------------------------------------------------
void Process:: behavior( void )
{
    while (1)     // "forever", i.e. until simulation time expires
    {  
        writeProcessInfo();  
        // execution needs no virtual time

        consumeTime( 5 );      
        // explicit consumption of time
        // Hands control back to ToopsSimulation, which checks if there 
        // are any other ToopsProcesses that are ready to run.
        // Returns after 5 units of time.
    }
}
